/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.TaskConfigurator;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilingSupport.class, (String)"CAPTION_Question");
    private static final String STOP_START_PROFILE_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartProfileSessionMessage");
    private static final String STOP_START_ATTACH_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartAttachSessionMessage");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_FailedLoadSettingsMsg");
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public static boolean checkProfilingInProgress() {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)STOP_START_PROFILE_SESSION_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return true;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)STOP_START_ATTACH_SESSION_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return true;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return false;
    }

    public AttachSTPData selectTaskForAttach(Lookup.Provider project, SessionSettings sessionSettings) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureAttachProfilerTask(project);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Lookup.Provider project, SessionSettings sessionSettings, FileObject profiledFile, boolean enableOverride) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureProfileProjectTask(project, profiledFile, enableOverride);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    public void setProfilingActionInvoked(boolean pai) {
        this.profilingActionInvoked = pai;
    }

    public boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    Lookup.Provider project = null;
                    GlobalProfilingSettings gps = Profiler.getDefault().getGlobalProfilingSettings();
                    SessionSettings ss = new SessionSettings();
                    ss.setPortNo(gps.getPortNo());
                    ProjectProfilingSupport pps = ProjectProfilingSupport.get(project);
                    pps.setupProjectSessionSettings(ss);
                    boolean settingsAccepted = false;
                    ProfilingSettings ps = null;
                    while (!settingsAccepted) {
                        AttachSTPData asd = ProfilingSupport.this.selectTaskForAttach(project, ss);
                        if (asd == null) {
                            return;
                        }
                        project = asd.getProject();
                        ps = asd.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + project));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + ps));
                        settingsAccepted = true;
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(project, null);
                    AttachSettings as = null;
                    try {
                        as = ProjectStorage.loadAttachSettings(project);
                    }
                    catch (IOException e) {
                        ProfilerDialogs.displayWarning((String)MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, e.getMessage()));
                        ProfilerLogger.log((Exception)e);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + as));
                    if (as == null) {
                        as = AttachWizard.getDefault().configure(as);
                        if (as == null) {
                            return;
                        }
                        ProjectStorage.saveAttachSettings((Lookup.Provider)project, (AttachSettings)as);
                    }
                    if (!as.isRemote() && as.isDynamic16()) {
                        int pid = PIDSelectPanel.selectPID();
                        if (pid == -1) {
                            return;
                        }
                        as.setPid(pid);
                    }
                    Profiler.getDefault().attachToApp(ps, as);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TargetAppRunner.getDefault().getAppStatusHandler().pauseLiveUpdates();
                    boolean attach = Profiler.getDefault().getProfilingMode() == 0;
                    TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureModifyProfilingTask(NetBeansProfiler.getDefaultNB().getProfiledProject(), NetBeansProfiler.getDefaultNB().getProfiledSingleFile(), Profiler.getDefault().getProfilingMode() == 0);
                    if (configuration == null) {
                        return;
                    }
                    Profiler.getDefault().modifyCurrentProfiling(configuration.getProfilingSettings());
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    TargetAppRunner.getDefault().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Lookup.Provider p;

        private AttachSTPData(ProfilingSettings ps, Lookup.Provider p) {
            this.ps = ps;
            this.p = p;
        }

        public Lookup.Provider getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

