/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

public final class ProfilerModule
extends ModuleInstall {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_QuestionDialogCaption");
    private static final String EXITING_FROM_PROFILE_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromProfileMessage");
    private static final String EXITING_FROM_ATTACH_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromAttachMessage");
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        if (!NetBeansProfiler.isInitialized()) {
            return true;
        }
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)EXITING_FROM_PROFILE_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)EXITING_FROM_ATTACH_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        if (!ResultsManager.getDefault().ideClosing()) {
            return false;
        }
        if (LiveResultsWindow.hasDefault()) {
            LiveResultsWindow.getDefault().ideClosing();
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int state = Profiler.getDefault().getProfilingState();
                    int mode = Profiler.getDefault().getProfilingMode();
                    if (state == 8 || state == 4) {
                        if (mode == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    new ResetResultsAction().actionPerformed(null);
                }
            });
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        super.uninstalled();
    }
}

