/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.WireIO;
import org.netbeans.modules.profiler.GestureSubmitter;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerModule;
import org.netbeans.modules.profiler.ProfilingMonitor;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.api.GlobalStorage;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.spi.SessionListener;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public abstract class NetBeansProfiler
extends Profiler {
    private static final Logger LOGGER = Logger.getLogger(NetBeansProfiler.class.getName());
    private static final String CALIBRATION_FAILED_MESSAGE;
    private static final String CALIBRATION_MISSING_MESSAGE;
    private static final String CALIBRATION_MISSING_SHORT_MESSAGE;
    private static final String PROGRESS_DIALOG_CAPTION;
    private static final String ENTIRE_APPLICATION_PROFILING_WARNING;
    private static final String DIRECTORY_DOES_NOT_EXIST_MESSAGE;
    private static final String DIRECTORY_IS_WRITE_PROTECTED_MESSAGE;
    private static final String ERROR_LOADING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_FILTER_SETS_MESSAGE;
    private static final String CANNOT_FIND_LIBS_MSG;
    private static final String ENGINE_INIT_FAILED_MSG;
    private static final String INITIAL_CALIBRATION_MSG;
    private static final String TERMINATE_VM_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE;
    private static final String TARGET_APP_NOT_RESPONDING_MSG;
    private static final String TARGET_APP_NOT_RESPONDING_DIALOG_TITLE;
    private static final String MODIFYING_INSTRUMENTATION_MSG;
    static final ErrorManager profilerErrorManager;
    private static final String GLOBAL_FILTERS_FILENAME = "filters";
    private static final String DEFINED_FILTERSETS_FILENAME = "filtersets";
    private static final String DEFAULT_FILE_SUFFIX = "-default";
    private static boolean initialized;
    AppStatusHandler.AsyncDialog waitDialog = null;
    boolean shouldDisplayDialog = true;
    private final ProfilerIDESettings ideSettings = ProfilerIDESettings.getInstance();
    private final ProfilingMonitor monitor = new ProfilingMonitor();
    private final TargetAppRunner targetAppRunner;
    private DefinedFilterSets definedFilterSets;
    private FileObject profiledSingleFile;
    private GlobalFilters globalFilters;
    private final Object setupLock = new Object();
    private ProfilingSettings lastProfilingSettings;
    private Lookup.Provider profiledProject = null;
    private SessionSettings lastSessionSettings;
    private StringBuilder logMsgs = new StringBuilder();
    private ThreadsDataManager threadsManager;
    private VMTelemetryDataManager vmTelemetryManager;
    private VMTelemetryModels vmTelemetryModels;
    private boolean calibrating = false;
    private boolean silent;
    private boolean threadsMonitoringEnabled = false;
    private boolean waitDialogOpen = false;
    private int lastMode = 1;
    private int profilingMode = 1;
    private int profilingState = 1;

    public NetBeansProfiler() {
        boolean initFailed = false;
        ProfilerEngineSettings sharedSettings = new ProfilerEngineSettings();
        try {
            String libsDir = this.getLibsDir();
            if (libsDir == null) {
                throw new IOException(CANNOT_FIND_LIBS_MSG);
            }
            sharedSettings.initialize(libsDir);
            sharedSettings.setSeparateConsole(System.getProperty("org.netbeans.profiler.separateConsole") != null);
            sharedSettings.setTargetWindowRemains(System.getProperty("org.netbeans.profiler.targetWindowRemains") != null);
        }
        catch (RuntimeException e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)e.getMessage());
            initFailed = true;
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(ENGINE_INIT_FAILED_MSG, e.getLocalizedMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            initFailed = true;
        }
        this.targetAppRunner = new TargetAppRunner(sharedSettings, (AppStatusHandler)new IDEAppStatusHandler(), this.getProfilingPointsManager());
        this.targetAppRunner.addProfilingEventListener(new ProfilingEventListener(){

            public void targetAppStarted() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void targetAppStopped() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(16);
            }

            public void targetAppSuspended() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(8);
            }

            public void targetAppResumed() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void attachedToTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void detachedFromTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }

            public void targetVMTerminated() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }
        });
        if (!initFailed) {
            initialized = true;
        }
    }

    public static NetBeansProfiler getDefaultNB() {
        return (NetBeansProfiler)NetBeansProfiler.getDefault();
    }

    public static boolean isInitialized() {
        NetBeansProfiler.getDefaultNB();
        return initialized;
    }

    public int getAgentState(String host, int port, int agentId) {
        if (this.profilingState == 4 && port == this.targetAppRunner.getProfilerEngineSettings().getPortNo()) {
            if (this.targetAppRunner.getProfilerClient().getCurrentAgentId() == agentId) {
                return 3;
            }
            return 4;
        }
        Properties agentProps = this.getAgentProperties(port);
        if (agentProps == null) {
            return 0;
        }
        try {
            int id = Integer.parseInt(agentProps.getProperty("agent.id"));
            if (id == agentId) {
                String dynamic = agentProps.getProperty("dynamic");
                if (dynamic == null || "false".equals(dynamic)) {
                    return 2;
                }
                return 1;
            }
            return 4;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public SessionSettings getCurrentSessionSettings() {
        return this.lastSessionSettings;
    }

    public synchronized DefinedFilterSets getDefinedFilterSets() {
        if (this.definedFilterSets == null) {
            this.loadGlobalFilters();
        }
        return this.definedFilterSets;
    }

    public synchronized GlobalFilters getGlobalFilters() {
        if (this.globalFilters == null) {
            this.loadGlobalFilters();
        }
        return this.globalFilters;
    }

    public GlobalProfilingSettings getGlobalProfilingSettings() {
        return this.ideSettings;
    }

    public ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    public abstract String getLibsDir();

    public int getPlatformArchitecture(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformArchitecture();
    }

    public String getPlatformJDKVersion(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformJDKVersion();
    }

    public String getPlatformJavaFile(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformJavaFile();
    }

    public int getProfilingMode() {
        return this.profilingMode;
    }

    public int getProfilingState() {
        return this.profilingState;
    }

    public TargetAppRunner getTargetAppRunner() {
        return this.targetAppRunner;
    }

    public ThreadsDataManager getThreadsManager() {
        if (this.threadsManager == null) {
            this.threadsManager = new ThreadsDataManager();
        }
        return this.threadsManager;
    }

    public void setThreadsMonitoringEnabled(boolean enabled) {
        this.getThreadsManager().setThreadsMonitoringEnabled(enabled);
        if (this.threadsMonitoringEnabled == enabled) {
            return;
        }
        this.threadsMonitoringEnabled = enabled;
        this.fireThreadsMonitoringChange();
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public VMTelemetryModels getVMTelemetryModels() {
        if (this.vmTelemetryModels == null) {
            this.vmTelemetryModels = new VMTelemetryModels(this.getVMTelemetryManager());
        }
        return this.vmTelemetryModels;
    }

    public VMTelemetryDataManager getVMTelemetryManager() {
        if (this.vmTelemetryManager == null) {
            this.vmTelemetryManager = new VMTelemetryDataManager();
        }
        return this.vmTelemetryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachToApp(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.profilingMode = 0;
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_StartingSession"));
        ph.setInitialDelay(500);
        ph.start();
        try {
            if (this.getProfilingState() != 1) {
                if (this.lastMode == 0) {
                    this.detachFromApp();
                } else if (this.targetAppRunner.targetJVMIsAlive()) {
                    this.targetAppRunner.terminateTargetJVM();
                }
            }
            this.lastProfilingSettings = profilingSettings;
            this.lastSessionSettings = null;
            this.lastMode = 0;
            ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
            profilingSettings.applySettings(sharedSettings);
            attachSettings.applySettings(sharedSettings);
            this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
            this.printDebugMsg("profiling settings --------------------------------", false);
            this.printDebugMsg(profilingSettings.debug(), false);
            this.printDebugMsg("attach settings -----------------------------------", false);
            this.printDebugMsg(attachSettings.debug(), false);
            this.printDebugMsg("instrumentation filter ----------------------------", false);
            this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
            this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
            this.flushDebugMsgs();
            GestureSubmitter.logAttach(this.getProfiledProject(), attachSettings);
            GestureSubmitter.logConfig(profilingSettings);
            this.changeStateTo(2);
            this.cleanupBeforeProfiling(sharedSettings);
            this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.openWindowsOnProfilingStart();
                }
            });
            if (attachSettings.isDirect()) {
                boolean success = false;
                if (this.prepareInstrumentation(profilingSettings)) {
                    boolean bl = success = this.targetAppRunner.initiateSession(1, false) && this.targetAppRunner.attachToTargetVMOnStartup();
                }
                if (!success) {
                    this.changeStateTo(1);
                    boolean bl = false;
                    return bl;
                }
            } else if (attachSettings.isDynamic16()) {
                String jar = this.getLibsDir() + "/jfluid-server-15.jar";
                String pid = String.valueOf(attachSettings.getPid());
                String options = String.valueOf(attachSettings.getPort());
                boolean success = false;
                try {
                    NetBeansProfiler.loadAgentIntoTargetJVM(jar, options, pid);
                    if (this.prepareInstrumentation(profilingSettings)) {
                        success = this.targetAppRunner.initiateSession(2, false) && this.targetAppRunner.attachToTargetVM();
                    }
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayError((String)ex.getMessage());
                    ProfilerLogger.log((Exception)ex);
                }
                if (!success) {
                    this.changeStateTo(1);
                    boolean bl = false;
                    return bl;
                }
            } else {
                throw new IllegalArgumentException("Invalid settings " + attachSettings);
            }
            boolean bl = this.connectToApp();
            return bl;
        }
        finally {
            ph.finish();
        }
    }

    private static void loadAgentIntoTargetJVM(String jar, String options, String pid) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine virtualMachine = VirtualMachine.attach(pid);
        virtualMachine.loadAgent(jar, options);
    }

    public void checkAndUpdateState() {
        boolean targetVMAlive = this.targetAppRunner.targetJVMIsAlive();
        if (!targetVMAlive) {
            this.changeStateTo(1);
            return;
        }
        boolean running = this.targetAppRunner.targetAppIsRunning();
        if (!running) {
            this.changeStateTo(16);
            return;
        }
        boolean suspended = this.targetAppRunner.targetAppSuspended();
        if (suspended) {
            this.changeStateTo(8);
        }
    }

    public boolean cleanForProfilingOnPort(int port) {
        if (this.isProfilingRunningOnPort(port)) {
            ProfilerLogger.severe((String)(">>> Profiling session already running on port " + port + ", will cause collision when starting another agent on the same port."));
            return false;
        }
        if (!this.shutdownAgent("localhost", port)) {
            ProfilerLogger.severe((String)(">>> Profiler agent already profiling on port " + port + " (communicating with another IDE?), will cause collision when starting another agent on the same port."));
            return false;
        }
        File agentFile = NetBeansProfiler.getInfoFile(port);
        if (agentFile.exists()) {
            boolean fileDeleted = this.waitForDeleteAgentFile(agentFile);
            if (!fileDeleted) {
                ProfilerLogger.severe((String)(">>> Profiler agent identification file cannot be deleted for port " + port + ", will cause failure starting a server for profiling on the same port."));
            }
            return fileDeleted;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectToStartedApp(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_StartingSession"));
        try {
            ph.setInitialDelay(500);
            ph.start();
            if (this.targetAppRunner.targetJVMIsAlive()) {
                this.targetAppRunner.terminateTargetJVM();
            }
            ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
            sessionSettings.applySettings(sharedSettings);
            profilingSettings.applySettings(sharedSettings);
            sharedSettings.setRemoteHost("");
            this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
            this.printDebugMsg("profiling settings -------------------------------", false);
            this.printDebugMsg(profilingSettings.debug(), false);
            this.printDebugMsg("session settings ---------------------------------", false);
            this.printDebugMsg(sessionSettings.debug(), false);
            this.printDebugMsg("instrumentation filter ---------------------------", false);
            this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
            this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
            this.flushDebugMsgs();
            GestureSubmitter.logProfileApp(this.getProfiledProject(), sessionSettings);
            GestureSubmitter.logConfig(profilingSettings);
            if (this.prepareProfilingSession(profilingSettings, sessionSettings)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        if (NetBeansProfiler.this.tryInitiateSession()) {
                            NetBeansProfiler.this.connectToApp();
                        }
                    }
                });
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ph.finish();
        }
    }

    private boolean prepareProfilingSession(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(this.targetAppRunner.getProfilerEngineSettings());
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.openWindowsOnProfilingStart();
            }
        });
        if (!CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable())) {
            ProfilerDialogs.displayError((String)CALIBRATION_MISSING_SHORT_MESSAGE, null, (String)CALIBRATION_MISSING_MESSAGE);
            this.changeStateTo(1);
            return false;
        }
        return this.prepareInstrumentation(profilingSettings);
    }

    private boolean tryInitiateSession() {
        if (!this.targetAppRunner.initiateSession(0, false) || !this.targetAppRunner.connectToStartedVMAndStartTA()) {
            this.changeStateTo(1);
            return false;
        }
        return true;
    }

    private boolean connectToApp() {
        if (this.targetAppRunner.targetAppIsRunning()) {
            this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)this.targetAppRunner.getProfilerEngineSettings().getTargetJDKVersionString()));
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                }
            });
            return true;
        }
        this.changeStateTo(1);
        return false;
    }

    public void detachFromApp() {
        this.setTransitionState();
        if (this.targetAppRunner.getProfilingSessionStatus().currentInstrType != 0) {
            try {
                this.targetAppRunner.getProfilerClient().removeAllInstrumentation(false);
            }
            catch (InstrumentationException e) {
                ProfilerDialogs.displayError((String)e.getMessage());
            }
        }
        this.targetAppRunner.detachFromTargetJVM();
    }

    public void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] rootMethods) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient client = this.targetAppRunner.getProfilerClient();
        if (rootMethods.length == 0) {
            ClientUtils.SourceCodeSelection selection = new ClientUtils.SourceCodeSelection(1);
            rootMethods = new ClientUtils.SourceCodeSelection[]{selection};
        }
        client.initiateRecursiveCPUProfInstrumentation(rootMethods);
    }

    public void log(int severity, String message) {
        switch (severity) {
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 16;
                break;
            }
            case 8: {
                severity = 4096;
                break;
            }
            case 16: {
                severity = 65536;
                break;
            }
            default: {
                severity = 0;
            }
        }
        if (profilerErrorManager.isLoggable(severity)) {
            profilerErrorManager.log(severity, message);
        }
    }

    public void modifyCurrentProfiling(final ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        if (!this.targetAppRunner.targetJVMIsAlive()) {
            return;
        }
        ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
        profilingSettings.applySettings(sharedSettings);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.printDebugMsg("profiling settings --------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("instrumentation filter ----------------------------", false);
        this.printDebugMsg(sharedSettings.getInstrumentationFilter().debug(), false);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.flushDebugMsgs();
        GestureSubmitter.logConfig(profilingSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    AppStatusHandler.AsyncDialog dialog;
                    NetBeansProfiler.this.changeStateTo(128);
                    NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().pauseLiveUpdates();
                    ResultsManager.getDefault().reset();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    NetBeansProfiler.this.waitDialog = NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().getAsyncDialogInstance(MODIFYING_INSTRUMENTATION_MSG, true, false);
                    if (NetBeansProfiler.this.waitDialog != null) {
                        dialog = NetBeansProfiler.this.waitDialog;
                        if (EventQueue.isDispatchThread()) {
                            dialog.display();
                        } else {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    dialog.display();
                                }
                            });
                        }
                    }
                    try {
                        NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                        NetBeansProfiler.this.changeStateTo(4);
                        if (NetBeansProfiler.this.waitDialog == null) break block12;
                        dialog = NetBeansProfiler.this.waitDialog;
                    }
                    catch (Throwable throwable) {
                        if (NetBeansProfiler.this.waitDialog != null) {
                            AppStatusHandler.AsyncDialog dialog2 = NetBeansProfiler.this.waitDialog;
                            if (EventQueue.isDispatchThread()) {
                                dialog2.close();
                            } else {
                                EventQueue.invokeLater(new Runnable(dialog2){
                                    final /* synthetic */ AppStatusHandler.AsyncDialog val$dialog;
                                    {
                                        this.val$dialog = asyncDialog;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$dialog.close();
                                    }
                                });
                            }
                        }
                        NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        dialog.close();
                    } else {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
            }
        });
    }

    public void notifyException(int severity, Exception e) {
        switch (severity) {
            case 1: {
                profilerErrorManager.notify(1, (Throwable)e);
                return;
            }
            case 2: {
                profilerErrorManager.notify(16, (Throwable)e);
                return;
            }
            case 8: {
                profilerErrorManager.notify(4096, (Throwable)e);
                return;
            }
            case 16: {
                profilerErrorManager.notify(65536, (Throwable)e);
                return;
            }
        }
        profilerErrorManager.notify(0, (Throwable)e);
    }

    public void openJavaSource(String className, String methodName, String methodSig) {
    }

    public boolean processesProfilingPoints() {
        return this.getProfilingPointsManager().getSupportedProfilingPoints().length > 0;
    }

    public boolean profileClass(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        if (this.targetAppRunner.targetJVMIsAlive()) {
            this.targetAppRunner.terminateTargetJVM();
        }
        final ProfilerEngineSettings sharedSettings = this.targetAppRunner.getProfilerEngineSettings();
        sessionSettings.applySettings(sharedSettings);
        profilingSettings.applySettings(sharedSettings);
        sharedSettings.setRemoteHost("");
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Profiler.profileClass: profiling settings -------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: session settings ---------------------------------", false);
        this.printDebugMsg(sessionSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Instrumentation filter:\n" + sharedSettings.getInstrumentationFilter().debug(), false);
        this.flushDebugMsgs();
        GestureSubmitter.logProfileClass(this.getProfiledProject(), sessionSettings);
        GestureSubmitter.logConfig(profilingSettings);
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(sharedSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.openWindowsOnProfilingStart();
        final Frame mainWindow = WindowManager.getDefault().getMainWindow();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = mainWindow.getCursor();
                mainWindow.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (!NetBeansProfiler.this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture())) {
                        ProfilerDialogs.displayError((String)CALIBRATION_FAILED_MESSAGE);
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    boolean success = NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    boolean bl = success = success && NetBeansProfiler.this.targetAppRunner.startTargetVM() && NetBeansProfiler.this.targetAppRunner.initiateSession(0, false) && NetBeansProfiler.this.targetAppRunner.connectToStartedVMAndStartTA();
                    if (!success) {
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                        NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)sharedSettings.getTargetJDKVersionString()));
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                            }
                        });
                    } else {
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                }
                finally {
                    mainWindow.setCursor(cursor);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCalibration(boolean checkForSaved, String jvmExecutable, String jdkString, int architecture) {
        this.calibrating = true;
        ProfilerEngineSettings pes = this.targetAppRunner.getProfilerEngineSettings();
        int savedPort = pes.getPortNo();
        InstrumentationFilter savedInstrFilter = pes.getInstrumentationFilter();
        String savedJVMExeFile = pes.getTargetJVMExeFile();
        String savedJDKVersionString = pes.getTargetJDKVersionString();
        int savedArch = pes.getSystemArchitecture();
        String savedCP = pes.getMainClassPath();
        if (jvmExecutable != null) {
            pes.setTargetJVMExeFile(jvmExecutable);
            pes.setTargetJDKVersionString(jdkString);
            pes.setSystemArchitecture(architecture);
        }
        pes.setPortNo(this.ideSettings.getCalibrationPortNo());
        pes.setInstrumentationFilter(new InstrumentationFilter());
        pes.setMainClassPath("");
        boolean result = false;
        if (checkForSaved) {
            result = this.targetAppRunner.readSavedCalibrationData();
            if (!result) {
                ProfilerDialogs.displayInfo((String)INITIAL_CALIBRATION_MSG);
                result = this.targetAppRunner.calibrateInstrumentationCode();
            }
            boolean shouldCalibrate = false;
            this.targetAppRunner.getProfilingSessionStatus().beginTrans(false);
            try {
                shouldCalibrate = Platform.isLinux() && "jdk16".equals(pes.getTargetJDKVersionString()) && this.targetAppRunner.getProfilingSessionStatus().methodEntryExitCallTime[1] > 20000.0;
            }
            finally {
                this.targetAppRunner.getProfilingSessionStatus().endTrans();
            }
            if (shouldCalibrate) {
                result = this.targetAppRunner.calibrateInstrumentationCode();
            }
        } else {
            result = this.targetAppRunner.calibrateInstrumentationCode();
        }
        this.calibrating = false;
        pes.setPortNo(savedPort);
        pes.setInstrumentationFilter(savedInstrFilter);
        pes.setTargetJDKVersionString(savedJDKVersionString);
        pes.setSystemArchitecture(savedArch);
        pes.setTargetJVMExeFile(savedJVMExeFile);
        pes.setMainClassPath(savedCP);
        return result;
    }

    public void setProfiledProject(Lookup.Provider project, FileObject singleFile) {
        this.profiledProject = project;
        this.profiledSingleFile = singleFile;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerControlPanel2.getDefault().setProfiledProject(NetBeansProfiler.this.profiledProject);
            }
        });
    }

    public Lookup.Provider getProfiledProject() {
        return this.profiledProject;
    }

    public FileObject getProfiledSingleFile() {
        return this.profiledSingleFile;
    }

    public void setSilent(boolean value) {
        this.silent = value;
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) {
        this.teardownDispatcher();
        this.setupDispatcher(profilingSettings);
        ClientUtils.SourceCodeSelection[] marks = MarkingEngine.getDefault().getMarkerMethods();
        profilingSettings.setInstrumentationMarkerMethods(marks);
        return this.prepareInstrumentationImpl(profilingSettings);
    }

    private boolean prepareInstrumentationImpl(ProfilingSettings profilingSettings) {
        try {
            return super.prepareInstrumentation(profilingSettings);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (InstrumentationException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (BadLocationException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ClassNotFoundException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
        }
        catch (ClassFormatError e) {
            ProfilerDialogs.displayError((String)e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFilters() {
        BufferedOutputStream bos;
        OutputStream os;
        FileObject fo;
        FileObject folder;
        FileLock lock = null;
        try {
            folder = GlobalStorage.getSettingsFolder((boolean)true);
            fo = folder.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(GLOBAL_FILTERS_FILENAME, "xml");
            }
            lock = fo.lock();
            os = fo.getOutputStream(lock);
            bos = new BufferedOutputStream(os);
            Properties globalFiltersProps = new Properties();
            this.globalFilters.store((Map)globalFiltersProps);
            globalFiltersProps.storeToXML(bos, "");
            bos.close();
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_SAVING_PROFILING_SETTINGS_MESSAGE, e.getMessage()));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        lock = null;
        try {
            folder = GlobalStorage.getSettingsFolder((boolean)true);
            fo = folder.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            if (fo == null) {
                fo = folder.createData(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            lock = fo.lock();
            os = fo.getOutputStream(lock);
            bos = new BufferedOutputStream(os);
            Properties definedFilterSetsProps = new Properties();
            this.definedFilterSets.store((Map)definedFilterSetsProps);
            definedFilterSetsProps.storeToXML(bos, "");
            bos.close();
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_SAVING_FILTER_SETS_MESSAGE, e.getMessage()));
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public void shutdown() {
        this.monitor.stopUpdateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownBlockedAgent(String host, int port, int agentId) {
        int state = this.getAgentState(host, port, agentId);
        if (state == 2) {
            Socket clientSocket = null;
            ObjectOutputStream socketOut = null;
            ObjectInputStream socketIn = null;
            try {
                clientSocket = new Socket(host, port);
                clientSocket.setSoTimeout(100);
                clientSocket.setTcpNoDelay(true);
                socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
                socketIn = new ObjectInputStream(clientSocket.getInputStream());
                WireIO wio = new WireIO(socketOut, socketIn);
                wio.sendSimpleCommand(12);
                Object o = wio.receiveCommandOrResponse();
                if (o instanceof Response && ((Response)o).isOK()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (socketIn != null) {
                        socketIn.close();
                    }
                    if (socketOut != null) {
                        socketOut.close();
                    }
                    if (clientSocket != null) {
                        clientSocket.close();
                    }
                }
                catch (IOException e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }
        return false;
    }

    public void stopApp() {
        this.setTransitionState();
        this.getTargetAppRunner().terminateTargetJVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentProperties(int port) {
        File f = NetBeansProfiler.getInfoFile(port);
        if (!f.exists()) {
            return null;
        }
        BufferedInputStream bis = null;
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            props.load(bis);
            bis.close();
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File getInfoFile(int port) {
        String homeDir = System.getProperty("user.home");
        return new File(homeDir + File.separator + ".nbprofiler" + File.separator + port);
    }

    private boolean isProfilingRunningOnPort(int port) {
        return this.profilingState == 4 && port == this.targetAppRunner.getProfilerEngineSettings().getPortNo();
    }

    private void setTransitionState() {
        this.changeStateTo(128);
    }

    private void changeStateTo(int newState) {
        if (this.profilingState == newState) {
            return;
        }
        int oldProfilingState = this.profilingState;
        this.profilingState = newState;
        this.fireProfilingStateChange(oldProfilingState, this.profilingState);
        if (newState == 1 || newState == 16) {
            this.cleanupAfterProfiling();
        }
    }

    protected void cleanupAfterProfiling() {
        this.teardownDispatcher();
        MarkingEngine.getDefault().deconfigure();
        ClassRepository.cleanup();
    }

    private void cleanupBeforeProfiling(ProfilerEngineSettings sharedSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.getThreadsManager().reset();
                NetBeansProfiler.this.getVMTelemetryManager().reset();
                if (LiveResultsWindow.hasDefault()) {
                    LiveResultsWindow.getDefault().handleCleanupBeforeProfiling();
                }
            }
        });
        ResultsManager.getDefault().reset();
        ClassRepository.clearCache();
        ClassRepository.initClassPaths((String)sharedSettings.getWorkingDir(), (String[])sharedSettings.getVMClassPaths());
    }

    private void closeWaitDialog() {
        if (this.waitDialogOpen) {
            this.waitDialog.close();
            this.waitDialogOpen = false;
        }
    }

    private void displayWaitDialog() {
        this.waitDialogOpen = true;
        this.waitDialog.display();
    }

    private void displayWarningAboutEntireAppProfiling() {
        ProfilerDialogs.displayWarning((String)ENTIRE_APPLICATION_PROFILING_WARNING);
    }

    private void flushDebugMsgs() {
        String msg = this.logMsgs.toString();
        if (LOGGER.isLoggable(Level.CONFIG) && !this.silent) {
            LOGGER.config(msg);
        } else {
            profilerErrorManager.log(msg);
        }
    }

    private void loadGlobalFilters() {
        try {
            FileObject folder = GlobalStorage.getSettingsFolder((boolean)false);
            FileObject configFolder = FileUtil.getConfigFile((String)"NBProfiler/Config");
            FileObject filtersFO = null;
            if (folder != null && folder.isValid()) {
                filtersFO = folder.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            }
            if (filtersFO == null && configFolder != null && configFolder.isValid()) {
                filtersFO = configFolder.getFileObject("filters-default", "xml");
            }
            if (filtersFO != null) {
                InputStream fis = filtersFO.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                Properties globalFiltersProps = new Properties();
                globalFiltersProps.loadFromXML(bis);
                this.globalFilters = new GlobalFilters();
                this.globalFilters.load((Map)globalFiltersProps);
                bis.close();
            }
            FileObject filterSetsFO = null;
            if (folder != null && folder.isValid()) {
                filterSetsFO = folder.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            if (filterSetsFO == null && configFolder != null && configFolder.isValid()) {
                filterSetsFO = configFolder.getFileObject("filtersets-default", "xml");
            }
            if (filterSetsFO != null) {
                InputStream fis = filterSetsFO.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                Properties definedFilterSetsProps = new Properties();
                definedFilterSetsProps.loadFromXML(bis);
                this.definedFilterSets = new DefinedFilterSets();
                this.definedFilterSets.load((Map)definedFilterSetsProps);
                bis.close();
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)MessageFormat.format(ERROR_LOADING_PROFILING_SETTINGS_MESSAGE, e.getMessage()));
        }
    }

    private void openWindowsOnProfilingStart() {
        int telemetryBehavior = this.ideSettings.getTelemetryOverviewBehavior();
        int threadsBehavior = this.ideSettings.getThreadsViewBehavior();
        boolean threadsEnabled = this.lastProfilingSettings.getThreadsMonitoringEnabled();
        int type = this.lastProfilingSettings.getProfilingType();
        if (telemetryBehavior == 1 || telemetryBehavior == 2 && type == 1) {
            TelemetryOverviewPanel.getDefault().open();
            TelemetryOverviewPanel.getDefault().requestVisible();
        }
        if (threadsEnabled && (threadsBehavior == 1 || threadsBehavior == 2 && type == 1)) {
            ThreadsWindow.getDefault().open();
            ThreadsWindow.getDefault().requestVisible();
        }
        if (this.ideSettings.getDisplayLiveResultsCPU() && (type == 8 || type == 16) || this.ideSettings.getDisplayLiveResultsFragment() && type == 32 || this.ideSettings.getDisplayLiveResultsMemory() && (type == 2 || type == 4)) {
            LiveResultsWindow.getDefault().open();
            LiveResultsWindow.getDefault().requestVisible();
        }
        ProfilerControlPanel2 controlPanel2 = ProfilerControlPanel2.getDefault();
        controlPanel2.open();
        controlPanel2.requestActive();
    }

    private void printDebugMsg(String msg) {
        this.printDebugMsg(msg, true);
    }

    private void printDebugMsg(String msg, boolean flush) {
        this.logMsgs.append(msg).append('\n');
        if (flush) {
            this.flushDebugMsgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDispatcher(ProfilingSettings profilingSettings) {
        Object object = this.setupLock;
        synchronized (object) {
            Lookup.Provider project = this.getProfiledProject();
            CCTProvider cctProvider = null;
            Collection cctListeners = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(CPUCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(CPUCCTProvider.Listener.class);
                    break;
                }
                case 2: 
                case 4: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(MemoryCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(MemoryCCTProvider.Listener.class);
                }
            }
            if (cctProvider != null && cctListeners != null && cctListeners.size() > 0) {
                for (CCTProvider.Listener cctListener : cctListeners) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Adding listener " + cctListener.getClass().getName() + " to the provider " + cctProvider.getClass().getName());
                    }
                    cctProvider.addListener(cctListener);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                if (cctProvider == null) {
                    LOGGER.warning("Could not find a CCT provider in lookup!");
                } else if (cctListeners == null || cctListeners.size() == 0) {
                    LOGGER.warning("Could not find listeners in lookup!");
                }
            }
            for (SessionListener sl : Lookup.getDefault().lookupAll(SessionListener.class)) {
                sl.onStartup(profilingSettings, project);
            }
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            CCTResultsFilter filter = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
            if (filter != null) {
                filter.reset();
                filter.setEvaluators(Lookup.getDefault().lookupAll(CCTResultsFilter.EvaluatorProvider.class));
            }
            FlatProfileBuilder fpb = (FlatProfileBuilder)Lookup.getDefault().lookup(FlatProfileBuilder.class);
            TimeCollector tc = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
            fpb.setContext(client, tc, filter);
            Collection listeners = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 64: {
                    listeners = Lookup.getDefault().lookupAll(CPUProfilingResultListener.class);
                    for (CPUProfilingResultListener listener : listeners) {
                        ProfilingResultsDispatcher.getDefault().addListener(listener);
                        listener.startup(this.targetAppRunner.getProfilerClient());
                    }
                    break;
                }
                case 2: 
                case 4: {
                    listeners = Lookup.getDefault().lookupAll(MemoryProfilingResultsListener.class);
                    for (MemoryProfilingResultsListener listener : listeners) {
                        ProfilingResultsDispatcher.getDefault().addListener(listener);
                        listener.startup(this.targetAppRunner.getProfilerClient());
                    }
                    break;
                }
            }
            this.getProfilingPointsManager().init((Object)this.getProfiledProject());
            ProfilingResultsDispatcher.getDefault().startup(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownAgent(String host, int port) {
        Socket clientSocket = null;
        ObjectOutputStream socketOut = null;
        ObjectInputStream socketIn = null;
        try {
            clientSocket = new Socket(host, port);
            clientSocket.setSoTimeout(100);
            clientSocket.setTcpNoDelay(true);
            socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
            socketIn = new ObjectInputStream(clientSocket.getInputStream());
            WireIO wio = new WireIO(socketOut, socketIn);
            wio.sendSimpleCommand(12);
            try {
                Object o = wio.receiveCommandOrResponse();
            }
            catch (Exception e) {
                // empty catch block
            }
            ProfilerLogger.warning((String)(">>> An existing Profiler agent listening on port " + port + " was terminated to allow starting new profiling session on the same port."));
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (socketIn != null) {
                    socketIn.close();
                }
                if (socketOut != null) {
                    socketOut.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownDispatcher() {
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingResultsDispatcher.getDefault().shutdown();
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            client.registerFlatProfileProvider(null);
        }
    }

    private ProfilingPointsProcessor getProfilingPointsManager() {
        return (ProfilingPointsProcessor)Lookup.getDefault().lookup(ProfilingPointsProcessor.class);
    }

    private boolean waitForDeleteAgentFile(File agentFile) {
        if (agentFile.delete()) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (agentFile.delete()) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        if (LOGGER.getLevel() == null || LOGGER.getLevel().intValue() > Level.CONFIG.intValue()) {
            LOGGER.setLevel(Level.CONFIG);
        }
        CALIBRATION_FAILED_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_CalibrationFailedMessage");
        CALIBRATION_MISSING_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstMsg");
        CALIBRATION_MISSING_SHORT_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstShortMsg");
        PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ProgressDialogCaption");
        ENTIRE_APPLICATION_PROFILING_WARNING = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EntireApplicationProfilingWarning");
        DIRECTORY_DOES_NOT_EXIST_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryDoesNotExistMessage");
        DIRECTORY_IS_WRITE_PROTECTED_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryIsWriteProtectedMessage");
        ERROR_LOADING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorLoadingProfilingSettingsMessage");
        ERROR_SAVING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingProfilingSettingsMessage");
        ERROR_SAVING_FILTER_SETS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingFilterSetsMessage");
        CANNOT_FIND_LIBS_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_CannotFindLibsMsg");
        ENGINE_INIT_FAILED_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EngineInitFailedMsg");
        INITIAL_CALIBRATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_InitialCalibrationMsg");
        TERMINATE_VM_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TerminateVMOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitDialogTitle");
        TARGET_APP_NOT_RESPONDING_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingMsg");
        TARGET_APP_NOT_RESPONDING_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingDialogTitle");
        MODIFYING_INSTRUMENTATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ModifyingInstrumentationMsg");
        profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");
        initialized = false;
    }

    private final class IDEAppStatusHandler
    implements AppStatusHandler {
        private IDEAppStatusHandler() {
        }

        public AppStatusHandler.AsyncDialog getAsyncDialogInstance(String message, boolean showProgress, boolean cancelAllowed) {
            return new ProgressPanel(message, showProgress, cancelAllowed);
        }

        public boolean confirmWaitForConnectionReply() {
            return !ProfilerDialogs.displayConfirmation((String)TARGET_APP_NOT_RESPONDING_MSG, (String)TARGET_APP_NOT_RESPONDING_DIALOG_TITLE);
        }

        public void displayError(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - error: " + msg);
            ProfilerDialogs.displayError((String)msg);
        }

        public void displayErrorAndWaitForConfirm(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - errorAndWaitForConfirm: " + msg);
            ProfilerDialogs.displayError((String)msg);
        }

        public void displayErrorWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            ProfilerDialogs.displayError((String)shortMsg, null, (String)detailsMsg);
        }

        public void displayNotification(String msg) {
            StatusDisplayer.getDefault().setStatusText(msg);
        }

        public void displayNotificationAndWaitForConfirm(String msg) {
            ProfilerDialogs.displayInfo((String)msg);
        }

        public void displayNotificationWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            ProfilerDialogs.displayInfo((String)shortMsg, null, (String)detailsMsg);
        }

        public void displayWarning(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warning: " + msg);
            ProfilerDialogs.displayWarning((String)msg);
        }

        public void displayWarningAndWaitForConfirm(String msg) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warningAndWaitForConfirm: " + msg);
            ProfilerDialogs.displayWarning((String)msg);
        }

        public void handleShutdown() {
            if (LiveResultsWindow.hasDefault()) {
                LiveResultsWindow.getDefault().handleShutdown();
            }
            if (NetBeansProfiler.this.getTargetAppRunner().getProfilerClient().getCurrentInstrType() == 0 || !ResultsManager.getDefault().resultsAvailable()) {
                ProfilerDialogs.displayInfoDNSA((String)TERMINATE_VM_ON_EXIT_MSG, null, null, (String)"NetBeansProfiler.handleShutdown.noResults", (boolean)false);
            } else if (ProfilerDialogs.displayConfirmationDNSA((String)TAKE_SNAPSHOT_ON_EXIT_MSG, (String)TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE, null, (String)"NetBeansProfiler.handleShutdown", (boolean)false)) {
                ResultsManager.getDefault().takeSnapshot();
            }
        }

        public void pauseLiveUpdates() {
            LiveResultsWindow.setPaused(true);
        }

        public void resultsAvailable() {
            ResultsManager.getDefault().resultsBecameAvailable();
        }

        public void resumeLiveUpdates() {
            LiveResultsWindow.setPaused(false);
        }

        public void takeSnapshot() {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResultsManager.getDefault().takeSnapshot();
                }
            });
        }
    }

    public static final class ProgressPanel
    implements AppStatusHandler.AsyncDialog {
        private static final int DEFAULT_WIDTH = 350;
        private static final int DEFAULT_HEIGHT = 100;
        private static final RequestProcessor commandQueue = new RequestProcessor("Async dialog command queue", 1);
        private Dialog dialog;
        private final Object dialogStateLock = new Object();
        private final Object dialogInitLock = new Object();
        private DialogState dialogState = DialogState.NOT_OPENED;
        private String message;
        private boolean cancelAllowed;
        private boolean cancelled = false;
        private boolean instantiated;
        private boolean showProgress;

        ProgressPanel(String message, boolean showProgress, boolean cancelAllowed) {
            this.message = message;
            this.showProgress = showProgress;
            this.cancelAllowed = cancelAllowed;
            this.dialogState = DialogState.NOT_OPENED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisplayed() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                return this.dialogState == DialogState.OPEN;
            }
        }

        public boolean cancelPressed() {
            return this.cancelled;
        }

        public synchronized void close() {
            commandQueue.post(new Runnable(){

                @Override
                public void run() {
                    ProgressPanel.this.dialogClose();
                }
            });
        }

        public synchronized void display() {
            commandQueue.post(new Runnable(){

                @Override
                public void run() {
                    ProgressPanel.this.instantiate();
                    ProgressPanel.this.dialogShow();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogClose() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.OPEN) {
                    LOGGER.finest("Closing async dialog");
                    if (this.dialog.isShowing()) {
                        ProgressPanel.dialogCloseImpl(this.dialog);
                    }
                    this.dialogState = DialogState.CLOSED;
                } else if (this.dialogState == DialogState.NOT_OPENED) {
                    LOGGER.fine("Attempting to close async dialog without opening it first");
                    this.dialogState = DialogState.NOT_OPENED_CLOSED;
                }
            }
        }

        private static void dialogCloseImpl(final Dialog dialog) {
            final CountDownLatch latch = new CountDownLatch(1);
            ComponentAdapter listener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    latch.countDown();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    super.componentShown(e);
                }
            };
            dialog.addComponentListener(listener);
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    dialog.setVisible(false);
                }
            });
            try {
                latch.await();
                dialog.removeComponentListener(listener);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogShow() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.NOT_OPENED || this.dialogState == DialogState.CLOSED) {
                    LOGGER.finest("Showing async dialog");
                    Level lvl = LOGGER.getLevel();
                    ProgressPanel.dialogShowImpl(this.dialog);
                    this.dialogState = DialogState.OPEN;
                } else if (this.dialogState == DialogState.NOT_OPENED_CLOSED) {
                    LOGGER.fine("Async dialog has been closed before being opened. Setting to CLOSED");
                    this.dialogState = DialogState.CLOSED;
                }
            }
        }

        private static void dialogShowImpl(final Dialog dialog) {
            final CountDownLatch latch = new CountDownLatch(1);
            ComponentAdapter listener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    super.componentHidden(e);
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    latch.countDown();
                }
            };
            dialog.addComponentListener(listener);
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    dialog.setVisible(true);
                }
            });
            try {
                latch.await();
                dialog.removeComponentListener(listener);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void instantiate() {
            Object object = this.dialogInitLock;
            synchronized (object) {
                Object[] objectArray;
                if (this.instantiated) {
                    return;
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout(10, 10));
                panel.setBorder(new EmptyBorder(15, 15, 15, 15));
                panel.add((Component)new JLabel(this.message), "North");
                Dimension ps = panel.getPreferredSize();
                ps.setSize(Math.max(ps.getWidth(), 350.0), Math.max(ps.getHeight(), this.showProgress ? 100.0 : ps.getHeight()));
                panel.setPreferredSize(ps);
                if (this.showProgress) {
                    JProgressBar progress = new JProgressBar();
                    progress.setIndeterminate(true);
                    panel.add((Component)progress, "South");
                }
                DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
                String string = PROGRESS_DIALOG_CAPTION;
                if (this.cancelAllowed) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = DialogDescriptor.CANCEL_OPTION;
                } else {
                    objectArray = new Object[]{};
                }
                this.dialog = dialogDisplayer.createDialog(new DialogDescriptor((Object)panel, string, true, objectArray, DialogDescriptor.CANCEL_OPTION, 1, null, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgressPanel.this.cancelled = true;
                        Object object = ProgressPanel.this.dialogStateLock;
                        synchronized (object) {
                            assert (ProgressPanel.this.dialogState == DialogState.OPEN);
                            LOGGER.finest("Closing async dialog (cancel)");
                            ProgressPanel.this.dialogState = DialogState.CLOSED;
                        }
                    }
                }));
                this.instantiated = true;
            }
        }

        private static enum DialogState {
            CLOSED,
            NOT_OPENED,
            NOT_OPENED_CLOSED,
            OPEN;

        }
    }
}

