/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.groovy.support.options.SupportOptionsPanelController;
import org.netbeans.modules.groovy.support.spi.GroovyOptionsSubpanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SupportPanel
extends JPanel {
    private final SupportOptionsPanelController controller;
    private final Collection<GroovyOptionsSubpanel> subpanels;
    private JButton chooseDocButton;
    private JLabel docLabel;
    private JTextField groovyDocTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel linkLabel;
    private JPanel subpanelWrapper;

    SupportPanel(SupportOptionsPanelController controller, @NonNull Collection<? extends GroovyOptionsSubpanel> subpanels) {
        this.controller = controller;
        this.subpanels = new ArrayList<GroovyOptionsSubpanel>(subpanels);
        this.initComponents();
        int y = 1;
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 1;
            constr.gridy = y++;
            constr.weightx = 1.0;
            constr.fill = 2;
            constr.insets = new Insets(0, 0, 8, 0);
            this.subpanelWrapper.add(subpanel.getComponent(), constr);
        }
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = y;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        this.subpanelWrapper.add((Component)new JLabel(), constr);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.linkLabel = new JLabel();
        this.docLabel = new JLabel();
        this.groovyDocTextField = new JTextField();
        this.chooseDocButton = new JButton();
        this.subpanelWrapper = new JPanel();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.linkLabel, (String)"<html><a href=\"http://groovy.codehaus.org\">http://groovy.codehaus.org</a></html>");
        this.linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SupportPanel.this.linkLabelMousePressed(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SupportPanel.this.linkLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SupportPanel.this.linkLabelMouseEntered(evt);
            }
        });
        this.docLabel.setLabelFor(this.groovyDocTextField);
        Mnemonics.setLocalizedText((JLabel)this.docLabel, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.docLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDocButton, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.text"));
        this.chooseDocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportPanel.this.chooseDocButtonActionPerformed(evt);
            }
        });
        this.subpanelWrapper.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linkLabel, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.groovyDocTextField, -1, 450, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseDocButton)).addGroup(layout.createSequentialGroup().addComponent(this.docLabel).addContainerGap()).addComponent(this.subpanelWrapper, -1, 555, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 16, -2).addComponent(this.linkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.docLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chooseDocButton).addComponent(this.groovyDocTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subpanelWrapper, -1, 69, Short.MAX_VALUE)));
        this.groovyDocTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleName"));
        this.groovyDocTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleDescription"));
        this.chooseDocButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleName"));
        this.chooseDocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleDescription"));
    }

    private void linkLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://groovy.codehaus.org"));
        }
        catch (MalformedURLException murle) {
            Exceptions.printStackTrace((Throwable)murle);
        }
    }

    private void linkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void linkLabelMouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void chooseDocButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.groovyDocTextField.getText());
        chooser.setFileSelectionMode(1);
        int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory"));
        if (r == 0) {
            File file = chooser.getSelectedFile();
            if (!new File(new File(file, "groovy-jdk"), "index.html").isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SupportPanel.class, (String)"LBL_Not_groovy_doc"), 2));
                return;
            }
            this.groovyDocTextField.setText(file.getAbsolutePath());
        }
    }

    void load() {
        GroovySettings groovyOption = GroovySettings.getInstance();
        String text = groovyOption.getGroovyDoc();
        if (text == null) {
            text = "";
        }
        this.groovyDocTextField.setText(text);
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            subpanel.load();
        }
    }

    void store() {
        GroovySettings groovyOption = GroovySettings.getInstance();
        groovyOption.setGroovyDoc(this.groovyDocTextField.getText().trim());
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            subpanel.store();
        }
    }

    boolean valid() {
        String groovyDoc = this.groovyDocTextField.getText().trim();
        if ("".equals(groovyDoc)) {
            return false;
        }
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            if (subpanel.valid()) continue;
            return false;
        }
        return true;
    }
}

