/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.groovy.support.debug.Context;
import org.netbeans.modules.groovy.support.debug.GroovyLineBreakpoint;

public class GroovyBreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(propertyName.equals("condition") || propertyName.equals("url") || propertyName.equals("lineNumber") || propertyName.equals("enabled"))) {
            return;
        }
        GroovyLineBreakpoint b = (GroovyLineBreakpoint)((Object)e.getSource());
        this.annotate(b);
    }

    public void breakpointAdded(Breakpoint b) {
        if (b instanceof GroovyLineBreakpoint) {
            ((GroovyLineBreakpoint)b).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((GroovyLineBreakpoint)b);
        }
    }

    public void breakpointRemoved(Breakpoint b) {
        if (b instanceof GroovyLineBreakpoint) {
            ((GroovyLineBreakpoint)b).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((GroovyLineBreakpoint)b);
        }
    }

    public GroovyLineBreakpoint findBreakpoint(String url, int lineNumber) {
        for (GroovyLineBreakpoint lb : this.breakpointToAnnotation.keySet()) {
            Object annotation;
            int ln;
            if (!lb.getURL().equals(url) || (ln = Context.getLineNumber(annotation = this.breakpointToAnnotation.get((Object)lb), null)) != lineNumber) continue;
            return lb;
        }
        return null;
    }

    private void annotate(GroovyLineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        if (annotation != null) {
            Context.removeAnnotation(annotation);
        }
        if (b.isHidden()) {
            return;
        }
        annotation = Context.annotate(b);
        if (annotation == null) {
            return;
        }
        this.breakpointToAnnotation.put(b, annotation);
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object timeStamp = null;
        if (de != null) {
            timeStamp = de.lookupFirst(null, JPDADebugger.class);
        }
        this.update(b, timeStamp);
    }

    public void updateGroovyLineBreakpoints() {
        for (GroovyLineBreakpoint lb : this.breakpointToAnnotation.keySet()) {
            this.update(lb, null);
        }
    }

    private void update(GroovyLineBreakpoint b, Object timeStamp) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        if (annotation == null) {
            return;
        }
        int ln = Context.getLineNumber(annotation, timeStamp);
        this.listen = false;
        b.setLineNumber(ln);
        this.listen = true;
    }

    private void removeAnnotation(GroovyLineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.remove((Object)b);
        if (annotation != null) {
            Context.removeAnnotation(annotation);
        }
    }
}

