/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class IOManager {
    private final String title;
    private InputOutput debuggerIO = null;
    private OutputWriter debuggerOut;
    private OutputWriter debuggerErr;
    private boolean closed = false;
    private Hashtable<String, Line> lines = new Hashtable();
    private Listener listener = new Listener();
    private final LinkedList<Text> buffer = new LinkedList();
    private RequestProcessor.Task task;

    public IOManager(String title) {
        this.title = title;
        this.init();
    }

    private boolean init() {
        if (IOManager.openDebuggerConsole()) {
            this.debuggerIO = IOProvider.getDefault().getIO(this.title, true);
            this.debuggerIO.setFocusTaken(false);
            this.debuggerIO.setErrSeparated(false);
            this.debuggerOut = this.debuggerIO.getOut();
            this.debuggerErr = this.debuggerIO.getErr();
            return true;
        }
        return false;
    }

    private static boolean openDebuggerConsole() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        return p.getBoolean("OpenDebuggerConsole", true);
    }

    public void println(String text, Line line) {
        this.println(text, line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String text, Line line, boolean important) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (!IOManager.openDebuggerConsole()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.debuggerIO == null) {
                this.init();
            }
        }
        object = this.buffer;
        synchronized (object) {
            this.buffer.addLast(new Text(text, line, important));
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Output", 1).post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList output;
                        LinkedList linkedList = IOManager.this.buffer;
                        synchronized (linkedList) {
                            output = new ArrayList(IOManager.this.buffer);
                            IOManager.this.buffer.clear();
                        }
                        int k = output.size();
                        for (int i = 0; i < k; ++i) {
                            Text t = (Text)output.get(i);
                            try {
                                Listener listener;
                                if (t.line != null) {
                                    listener = IOManager.this.listener;
                                    IOManager.this.lines.put(t.text, t.line);
                                } else {
                                    listener = null;
                                }
                                if (t.important) {
                                    if (listener != null) {
                                        IOManager.this.debuggerErr.println(t.text, (OutputListener)listener, t.important);
                                    } else {
                                        IOManager.this.debuggerErr.println(t.text);
                                    }
                                    IOManager.this.debuggerIO.select();
                                    IOManager.this.debuggerErr.flush();
                                } else {
                                    if (listener != null) {
                                        IOManager.this.debuggerOut.println(t.text, (OutputListener)listener, t.important);
                                    } else {
                                        IOManager.this.debuggerOut.println(t.text);
                                    }
                                    IOManager.this.debuggerOut.flush();
                                }
                                StatusDisplayer.getDefault().setStatusText(t.text);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            if (!IOManager.this.closed) continue;
                            IOManager.this.debuggerOut.close();
                            IOManager.this.debuggerErr.close();
                        }
                    }
                }, 50, 1);
            } else if (this.buffer.size() > 25) {
                this.task.run();
            } else {
                this.task.schedule(50);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStream() {
        LinkedList<Text> linkedList = this.buffer;
        synchronized (linkedList) {
            this.closed = true;
            if (this.task != null) {
                this.task.schedule(50);
            }
        }
    }

    void close() {
        if (this.debuggerIO != null) {
            this.debuggerIO.closeInputOutput();
        }
    }

    public static final class Line {
        private String url;
        private int lineNumber;
        private JPDADebugger debugger;

        public Line(String url, int lineNumber, JPDADebugger debugger) {
            this.url = url;
            this.lineNumber = lineNumber;
        }

        public void show() {
            EditorContextBridge.getContext().showSource(this.url, this.lineNumber, (Object)this.debugger);
        }
    }

    private static class Text {
        private String text;
        private Line line;
        private boolean important;

        private Text(String text, Line line, boolean important) {
            this.text = text;
            this.line = line;
            this.important = important;
        }
    }

    private class Listener
    implements OutputListener {
        private Listener() {
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            String t = ev.getLine();
            Line l = (Line)IOManager.this.lines.get(t);
            if (l == null) {
                return;
            }
            l.show();
        }

        public void outputLineCleared(OutputEvent ev) {
            IOManager.this.lines = new Hashtable();
        }
    }
}

