/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.impl.probes.ProbePresenter;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderButton;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ScrollBar;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.VerticalTimelineLayout;
import org.openide.util.NbBundle;

final class ProbesPanel
extends JPanel {
    private final ListPanel listPanel;
    private final JViewport viewport;
    private final HeaderButton increaseB;
    private final HeaderButton decreaseB;
    private final HeaderButton resetB;

    ProbesPanel(final TimelineSupport support) {
        final TimelineChart chart = support.getChart();
        this.listPanel = new ListPanel(new VerticalTimelineLayout(chart)){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = Utils.checkedInt((double)chart.getChartContext().getViewHeight());
                return d;
            }

            @Override
            protected void updateSelection() {
                int count = this.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    ((ProbePresenter)this.getComponent(i)).setSelected(chart.isRowSelected(chart.getRow(i)));
                }
            }
        };
        this.viewport = new JViewport(){

            @Override
            public String getToolTipText(MouseEvent event) {
                Point p = event.getPoint();
                p.y += this.getViewPosition().y;
                return ProbesPanel.this.listPanel.getToolTipText(p);
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.viewport);
        this.viewport.setOpaque(true);
        this.viewport.setBackground(new Color(247, 247, 247));
        this.viewport.setView(this.listPanel);
        this.viewport.setViewPosition(new Point(0, 0));
        final ViewportUpdater updater = new ViewportUpdater(this.viewport);
        chart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
                if (lastOffsetY != offsetY) {
                    SwingUtilities.invokeLater(updater.forPoint(new Point(0, Utils.checkedInt((double)offsetY))));
                }
            }
        });
        JPanel bottomPanel = new JPanel(new GridLayout(1, 3));
        bottomPanel.setPreferredSize(new Dimension(100, new ScrollBar((int)0).getPreferredSize().height));
        bottomPanel.setOpaque(false);
        this.increaseB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Increment")){

            @Override
            protected void performAction(ActionEvent e) {
                chart.increaseRowHeights((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.increaseB.setToolTipText(NbBundle.getMessage(ProbesPanel.class, (String)"TOOLTIP_IncreaseRowsHeight"));
        bottomPanel.add(this.increaseB);
        this.decreaseB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Decrement")){

            @Override
            protected void performAction(ActionEvent e) {
                chart.decreaseRowHeights((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.decreaseB.setToolTipText(NbBundle.getMessage(ProbesPanel.class, (String)"TOOLTIP_DecreaseRowsHeight"));
        bottomPanel.add(this.decreaseB);
        this.resetB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Reset")){

            @Override
            protected void performAction(ActionEvent e) {
                chart.resetRowHeights();
            }
        };
        this.resetB.setToolTipText(NbBundle.getMessage(ProbesPanel.class, (String)"TOOLTIP_ResetRowsHeight"));
        bottomPanel.add(this.resetB);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)new HeaderLabel(NbBundle.getMessage(ProbesPanel.class, (String)"LBL_Probes")), "North");
        this.add((Component)this.viewport, "Center");
        this.add((Component)bottomPanel, "South");
        chart.addRowListener(new TimelineChart.RowListener(){

            @Override
            public void rowsAdded(List<TimelineChart.Row> rows) {
                for (TimelineChart.Row row : rows) {
                    TracerProbe probe = support.getProbe(row);
                    ProbesPanel.this.listPanel.add((Component)new ProbePresenter(probe, support.getDescriptor(probe)), row.getIndex());
                }
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
                ProbesPanel.this.refreshButtons(true);
            }

            @Override
            public void rowsRemoved(List<TimelineChart.Row> rows) {
                for (TimelineChart.Row row : rows) {
                    ProbesPanel.this.listPanel.remove(row.getIndex());
                }
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
                ProbesPanel.this.refreshButtons(chart.hasRows());
            }

            @Override
            public void rowsResized(List<TimelineChart.Row> rows) {
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
            }
        });
        this.refreshButtons(chart.hasRows());
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.viewport.setCursor(cursor);
    }

    Component getMouseTarget() {
        return this.viewport;
    }

    void updateSelection() {
        this.listPanel.updateSelection();
    }

    private void refreshButtons(boolean enabled) {
        this.increaseB.setEnabled(enabled);
        this.decreaseB.setEnabled(enabled);
        this.resetB.setEnabled(enabled);
    }

    private static class ListPanel
    extends JPanel {
        ListPanel(LayoutManager layout) {
            super(layout);
            this.setOpaque(false);
        }

        protected void updateSelection() {
        }

        String getToolTipText(Point p) {
            String tooltip = null;
            Component c = this.getComponentAt(p);
            if (c instanceof JComponent) {
                tooltip = (String)((JComponent)c).getClientProperty("ToolTipHelper");
            }
            return tooltip;
        }

        private void sync() {
            this.doLayout();
            this.repaint();
        }
    }

    private static class ViewportUpdater
    implements Runnable {
        private final JViewport viewport;
        private Point point;

        ViewportUpdater(JViewport viewport) {
            this.viewport = viewport;
        }

        Runnable forPoint(Point point) {
            this.point = point;
            return this;
        }

        @Override
        public void run() {
            this.viewport.setViewPosition(this.point);
        }
    }
}

