/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.impl.TimelineView;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class TracerView {
    private final TracerModel model;
    private final TracerController controller;
    private TimelineView timelineView;

    TracerView(TracerModel model, TracerController controller) {
        this.model = model;
        this.controller = controller;
    }

    protected JComponent createComponent() {
        final JPanel component = new JPanel(new BorderLayout());
        this.timelineView = new TimelineView(this.model);
        final JPanel container = new JPanel(null){

            @Override
            public void doLayout() {
                Component[] components;
                for (Component component : components = this.getComponents()) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getComponent(this.getComponentCount() - 1).getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMaximumSize();
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        JPanel glass = new JPanel(null);
        glass.setOpaque(false);
        glass.setCursor(Cursor.getPredefinedCursor(3));
        glass.addMouseListener(new MouseAdapter(){});
        glass.addMouseMotionListener(new MouseMotionAdapter(){});
        glass.addKeyListener(new KeyAdapter(){});
        container.add(glass);
        container.add(this.timelineView.getView());
        component.add((Component)container, "North");
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerView.this.initProbes();
                TracerView.this.initTimeline();
                TracerView.this.initData(component, container);
                TracerView.this.initListeners(component);
            }
        });
        return component;
    }

    private void initProbes() {
        List<TracerPackage> packages = TracerSupportImpl.getInstance().getPackages(this.model.getSnapshot());
        for (TracerPackage p : packages) {
            this.model.addDescriptors(p, p.getProbeDescriptors());
        }
    }

    private void initTimeline() {
        TimelineSupport support = this.model.getTimelineSupport();
        long start = this.model.firstTimestamp();
        if (start == -1L) {
            return;
        }
        long end = this.model.lastTimestamp();
        if (end == -1L) {
            return;
        }
        support.dataLoadingStarted(end - start);
    }

    private void initData(final JPanel component, final JPanel container) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel progress = new JLabel(NbBundle.getMessage(TracerView.class, (String)"MSG_LoadingSnapshot"), 0);
                progress.setCursor(Cursor.getPredefinedCursor(3));
                TracerView.addContents(component, progress);
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        TracerView.this.controller.performSession();
                        TracerView.this.controller.performAfterSession(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport support = TracerView.this.model.getTimelineSupport();
                                support.dataLoadingFinished();
                                support.selectAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TracerView.this.timelineView.updateActions();
                                    }
                                });
                                component.remove(container);
                                component.add(container.getComponent(1), "North");
                                component.revalidate();
                                component.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private void initListeners(final JPanel component) {
        final TimelineSupport support = this.model.getTimelineSupport();
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void indexSelectionChanged() {
                final int startIndex = Math.min(support.getStartIndex(), support.getEndIndex());
                final int endIndex = Math.max(support.getStartIndex(), support.getEndIndex());
                JLabel progress = new JLabel(NbBundle.getMessage(TracerView.class, (String)"MSG_ProcessingSelection"), 0);
                TracerView.addContents(component, progress);
                TracerView.this.controller.performAfterSession(new Runnable(){

                    @Override
                    public void run() {
                        if (startIndex == endIndex) {
                            TracerView.this.displayThreadDump(component, startIndex);
                        } else {
                            TracerView.this.displaySnapshot(component, startIndex, endIndex);
                        }
                    }
                });
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
            }
        });
    }

    private void displaySnapshot(final JPanel p, int s1, int s2) {
        LoadedSnapshot ls = null;
        try {
            ls = this.model.getSnapshot().getCPUSnapshot(s1, s2);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        final LoadedSnapshot lsF = ls;
        if (lsF != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow w = new SnapshotResultsWindow(lsF, 1, false);
                    JPanel c = new JPanel(new BorderLayout(0, 3));
                    c.setBorder(BorderFactory.createEmptyBorder(8, 5, 5, 5));
                    c.add((Component)new JSeparator(), "North");
                    c.add((Component)w, "Center");
                    TracerView.addContents(p, c);
                }
            });
        }
    }

    private void displayThreadDump(final JPanel p, int s) {
        String td = null;
        try {
            td = this.model.getSnapshot().getThreadDump(s);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        final String tdF = td;
        if (tdF != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLTextArea a = new HTMLTextArea(tdF){

                        protected void showURL(URL url) {
                            if (url == null) {
                                return;
                            }
                            String urls = url.toString();
                            TracerView.this.showURL(urls);
                        }
                    };
                    a.setCaretPosition(0);
                    JScrollPane sp = new JScrollPane((Component)a);
                    JPanel c = new JPanel(new BorderLayout(0, 6));
                    c.setBorder(BorderFactory.createEmptyBorder(8, 5, 5, 5));
                    c.add((Component)new JSeparator(), "North");
                    c.add((Component)sp, "Center");
                    TracerView.addContents(p, c);
                }
            });
        }
    }

    private static void addContents(JComponent container, JComponent contents) {
        BorderLayout layout = (BorderLayout)container.getLayout();
        Component oldContents = layout.getLayoutComponent("Center");
        if (oldContents != null) {
            container.remove(oldContents);
        }
        container.add((Component)contents, "Center");
        container.revalidate();
        container.repaint();
    }

    void showURL(String urls) {
        if (urls.startsWith("file:/stackframe/")) {
            urls = urls.substring("file:/stackframe/".length());
            String[] parts = urls.split("\\|");
            String className = parts[0];
            String method = parts[1];
            int linenumber = Integer.parseInt(parts[2]);
            GoToSource.openSource(null, (String)className, (String)method, (int)linenumber);
        }
    }
}

