/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VisibilityHandler;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelinePanel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.NbBundle;

final class TimelineView {
    private final TracerModel model;
    private TimelinePanel panel;
    private JButton selectAllButton;
    private JButton clearTimestampSelectionButton;
    private JLabel selectionLabel;
    private VisibilityHandler viewHandler;
    private static final Format df = new SimpleDateFormat(TimeAxisUtils.TIME_MSEC);

    TimelineView(TracerModel model) {
        this.model = model;
    }

    void reset() {
        if (this.panel != null) {
            this.panel.reset();
        }
    }

    void resetSelection() {
        if (this.panel != null) {
            this.panel.resetSelection();
        }
    }

    void updateActions() {
        if (this.panel != null) {
            this.panel.updateActions();
        }
    }

    Action zoomInAction() {
        if (this.panel != null) {
            return this.panel.zoomInAction();
        }
        return null;
    }

    Action zoomOutAction() {
        if (this.panel != null) {
            return this.panel.zoomOutAction();
        }
        return null;
    }

    Action toggleViewAction() {
        if (this.panel != null) {
            return this.panel.toggleViewAction();
        }
        return null;
    }

    AbstractButton mouseZoom() {
        if (this.panel != null) {
            return this.panel.mouseZoom();
        }
        return null;
    }

    AbstractButton mouseHScroll() {
        if (this.panel != null) {
            return this.panel.mouseHScroll();
        }
        return null;
    }

    AbstractButton mouseVScroll() {
        if (this.panel != null) {
            return this.panel.mouseVScroll();
        }
        return null;
    }

    void registerViewListener(VisibilityHandler viewHandler) {
        if (this.panel != null) {
            viewHandler.handle(this.panel);
        } else {
            this.viewHandler = viewHandler;
        }
    }

    boolean isShowing() {
        return this.panel != null && this.panel.isShowing();
    }

    JComponent getView() {
        final TimelineSupport support = this.model.getTimelineSupport();
        this.panel = new TimelinePanel(support);
        if (this.viewHandler != null) {
            this.viewHandler.handle(this.panel);
            this.viewHandler = null;
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setBorderPainted(false);
        toolbar.add(this.panel.zoomInAction());
        toolbar.add(this.panel.zoomOutAction());
        toolbar.add(this.panel.toggleViewAction());
        toolbar.addSeparator();
        ButtonGroup bg = new ButtonGroup();
        AbstractButton mz = this.panel.mouseZoom();
        bg.add(mz);
        toolbar.add(mz);
        AbstractButton mh = this.panel.mouseHScroll();
        bg.add(mh);
        toolbar.add(mh);
        toolbar.addSeparator();
        this.selectAllButton = new JButton(Icons.getIcon((String)"TracerIcons.SelectAll")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        support.selectAll();
                    }
                });
            }
        };
        this.selectAllButton.setToolTipText(NbBundle.getMessage(TimelineView.class, (String)"TOOLTIP_SelectAll"));
        toolbar.add(this.selectAllButton);
        this.clearTimestampSelectionButton = new JButton(Icons.getIcon((String)"TracerIcons.MarkClear")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        support.resetSelectedTimestamps();
                    }
                });
            }
        };
        this.clearTimestampSelectionButton.setToolTipText(NbBundle.getMessage(TimelineView.class, (String)"TOOLTIP_ClearMarks"));
        toolbar.add(this.clearTimestampSelectionButton);
        toolbar.addSeparator();
        this.selectionLabel = new JLabel();
        toolbar.add(this.selectionLabel);
        JPanel container = new JPanel(new BorderLayout());
        JPanel toolbarContainer = new JPanel(new BorderLayout());
        toolbarContainer.add((Component)toolbar, "Center");
        toolbarContainer.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
        container.add((Component)toolbarContainer, "North");
        container.add((Component)this.panel, "Center");
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void indexSelectionChanged() {
                TimelineView.this.updateSelectionToolbar();
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
                TimelineView.this.updateSelectionToolbar();
            }
        });
        this.updateSelectionToolbar();
        return container;
    }

    private void updateSelectionToolbar() {
        TimelineSupport support = this.model.getTimelineSupport();
        this.selectAllButton.setEnabled(!support.isSelectAll());
        this.clearTimestampSelectionButton.setEnabled(support.isTimestampSelection(false));
        int startIndex = support.getStartIndex();
        int endIndex = support.getEndIndex();
        String selection = " " + NbBundle.getMessage(TimelineView.class, (String)"LBL_Selection") + " ";
        if (startIndex == -1) {
            selection = selection + NbBundle.getMessage(TimelineView.class, (String)"LBL_None");
        } else if (startIndex == endIndex) {
            selection = selection + df.format(support.getTimestamp(startIndex)) + ", " + NbBundle.getMessage(TimelineView.class, (String)"LBL_SingleSample", (Object)startIndex);
        } else {
            long startTime = support.getTimestamp(startIndex);
            long endTime = support.getTimestamp(endIndex);
            selection = selection + NbBundle.getMessage(TimelineView.class, (String)"LBL_TwoTimes", (Object)df.format(startTime), (Object)df.format(endTime));
            selection = selection + " (" + (endTime - startTime) + " ms)";
            selection = selection + ", " + NbBundle.getMessage(TimelineView.class, (String)"LBL_TwoSamples", (Object)startIndex, (Object)endIndex);
        }
        if (support.isSelectAll()) {
            selection = selection + ", " + NbBundle.getMessage(TimelineView.class, (String)"LBL_EntireSnapshot");
        }
        this.selectionLabel.setText(selection);
    }
}

