/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.openide.util.Exceptions;

public class FileInfoProvider {
    private static final short ACCESS_MASK = 511;
    private static final short USR_R = 256;
    private static final short USR_W = 128;
    private static final short USR_X = 64;
    private static final short GRP_R = 32;
    private static final short GRP_W = 16;
    private static final short GRP_X = 8;
    private static final short ALL_R = 4;
    private static final short ALL_W = 2;
    private static final short ALL_X = 1;

    public static Future<StatInfo> stat(ExecutionEnvironment env, String absPath) {
        return SftpSupport.getInstance(env).stat(absPath, new PrintWriter(System.err));
    }

    public static Future<StatInfo> stat(ExecutionEnvironment env, String absPath, Writer error) {
        return SftpSupport.getInstance(env).stat(absPath, error);
    }

    public static Future<StatInfo[]> ls(ExecutionEnvironment env, String absPath) {
        return FileInfoProvider.ls(env, absPath, new PrintWriter(System.err));
    }

    public static Future<StatInfo[]> ls(ExecutionEnvironment env, String absPath, Writer error) {
        return SftpSupport.getInstance(env).ls(absPath, error);
    }

    private static short stringToAcces(String accessString) {
        if (accessString.length() < 9) {
            throw new IllegalArgumentException("wrong access string: " + accessString);
        }
        short result = 0;
        result = (short)(result | (accessString.charAt(0) == 'r' ? 256 : 0));
        result = (short)(result | (accessString.charAt(1) == 'w' ? 128 : 0));
        result = (short)(result | (accessString.charAt(2) == 'x' ? 64 : 0));
        result = (short)(result | (accessString.charAt(3) == 'r' ? 32 : 0));
        result = (short)(result | (accessString.charAt(4) == 'w' ? 16 : 0));
        result = (short)(result | (accessString.charAt(5) == 'x' ? 8 : 0));
        result = (short)(result | (accessString.charAt(6) == 'r' ? 4 : 0));
        result = (short)(result | (accessString.charAt(7) == 'w' ? 2 : 0));
        result = (short)(result | (accessString.charAt(8) == 'x' ? 1 : 0));
        return result;
    }

    private static String accessToString(int access) {
        char[] accessChars = new char[]{(access & 0x100) == 0 ? (char)'-' : 'r', (access & 0x80) == 0 ? (char)'-' : 'w', (access & 0x40) == 0 ? (char)'-' : 'x', (access & 0x20) == 0 ? (char)'-' : 'r', (access & 0x10) == 0 ? (char)'-' : 'w', (access & 8) == 0 ? (char)'-' : 'x', (access & 4) == 0 ? (char)'-' : 'r', (access & 2) == 0 ? (char)'-' : 'w', (access & 1) == 0 ? (char)'-' : 'x'};
        return new String(accessChars);
    }

    private static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace(" ", "\\ ");
            return text;
        }
    }

    private static String unescape(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace("\\ ", " ");
            return text;
        }
    }

    public static final class StatInfo {
        private static final int S_IFMT = 61440;
        private static final int S_IFIFO = 4096;
        private static final char S_IFIFO_C = 'p';
        private static final int S_IFCHR = 8192;
        private static final char S_IFCHR_C = 'c';
        private static final int S_IFMPC = 12288;
        private static final char S_IFMPC_C = 'm';
        private static final int S_IFDIR = 16384;
        private static final char S_IFDIR_C = 'd';
        private static final int S_IFNAM = 20480;
        private static final char S_IFNAM_C = 'N';
        private static final int S_IFBLK = 24576;
        private static final char S_IFBLK_C = 'b';
        private static final int S_IFMPB = 28672;
        private static final char S_IFMPB_C = 'M';
        private static final int S_IFREG = 32768;
        private static final char S_IFREG_C = '-';
        private static final int S_IFCMP = 36864;
        private static final char S_IFCMP_C = 'n';
        private static final int S_IFLNK = 40960;
        private static final char S_IFLNK_C = 'l';
        private static final int S_IFSHAD = 45056;
        private static final char S_IFSHAD_C = 'S';
        private static final int S_IFSOCK = 49152;
        private static final char S_IFSOCK_C = 's';
        private static final int S_IFDOOR = 53248;
        private static final char S_IFDOOR_C = 'D';
        private static final int S_IFPORT = 57344;
        private static final char S_IFPORT_C = 'P';
        private static final char S_UNDEF_C = 'u';
        private final String name;
        private final int gid;
        private final int uid;
        private final long size;
        private final String linkTarget;
        private final int access;
        private final Date lastModified;

        StatInfo(String name, int uid, int gid, long size, boolean directory, boolean link, String linkTarget, int access, Date lastModified) {
            this.name = name;
            this.gid = gid;
            this.uid = uid;
            this.size = size;
            if (directory) {
                access = access & 0xFFFF0FFF | 0x4000;
            }
            if (link) {
                access = access & 0xFFFF0FFF | 0xA000;
            }
            this.access = access;
            this.linkTarget = linkTarget;
            this.lastModified = lastModified;
            assert (directory == this.isDirectory());
            assert (link == this.isLink());
        }

        public int getAccess() {
            return this.access & 0x1FF;
        }

        public String getAccessAsString() {
            return FileInfoProvider.accessToString(this.getAccess());
        }

        public long getSize() {
            return this.size;
        }

        public int getGropupId() {
            return this.gid;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public String getName() {
            return this.name;
        }

        public int getUserId() {
            return this.uid;
        }

        public boolean isDirectory() {
            return (this.access & 0xF000) == 16384;
        }

        public boolean isLink() {
            return (this.access & 0xF000) == 40960;
        }

        public boolean isPlainFile() {
            return (this.access & 0xF000) == 32768;
        }

        public FileType getFileType() {
            return FileType.fromInt(this.access & 0xF000);
        }

        public String toExternalForm() {
            StringBuilder sb = new StringBuilder();
            sb.append(FileInfoProvider.escape(this.name)).append(' ');
            sb.append(FileInfoProvider.accessToString(this.getAccess())).append(' ');
            sb.append(this.getFileType().toChar()).append(' ');
            sb.append(this.gid).append(' ');
            sb.append(this.uid).append(' ');
            sb.append(this.lastModified.getTime()).append(' ');
            sb.append(this.size).append(' ');
            if (this.linkTarget != null) {
                sb.append(FileInfoProvider.escape(this.linkTarget)).append(' ');
            }
            return sb.toString();
        }

        public static StatInfo fromExternalForm(String externalForm) {
            int next;
            String[] parts = externalForm.split(" +");
            String name = FileInfoProvider.unescape(parts[0]);
            int acc = FileInfoProvider.stringToAcces(parts[1]);
            boolean dir = false;
            boolean link = false;
            if (parts[2].length() > 1) {
                dir = Boolean.parseBoolean(parts[2]);
                link = Boolean.parseBoolean(parts[3]);
                acc = dir ? (acc += 16384) : (link ? (acc += 40960) : (acc += 32768));
                next = 4;
            } else {
                FileType fromChar = FileType.fromChar(parts[2].charAt(0));
                acc += fromChar.fileType;
                switch (fromChar) {
                    case Directory: {
                        dir = true;
                        break;
                    }
                    case SymbolicLink: {
                        link = true;
                    }
                }
                assert (fromChar != FileType.Undefined);
                next = 3;
            }
            int gid = Integer.parseInt(parts[next]);
            int uid = Integer.parseInt(parts[next + 1]);
            long time = Long.parseLong(parts[next + 2]);
            long size = Long.parseLong(parts[next + 3]);
            String linkTarget = parts.length < next + 5 ? null : FileInfoProvider.unescape(parts[next + 4]);
            return new StatInfo(name, uid, gid, size, dir, link, linkTarget, acc, new Date(time));
        }

        private boolean can(ExecutionEnvironment env, short all_mask, short grp_mask, short usr_mask) {
            if (HostInfoUtils.isHostInfoAvailable(env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
                    if (this.uid == hostInfo.getUserId()) {
                        return (this.getAccess() & usr_mask) > 0;
                    }
                    boolean isGroupClass = false;
                    for (int currGid : hostInfo.getAllGroupIDs()) {
                        if (this.gid != currGid) continue;
                        isGroupClass = true;
                        break;
                    }
                    if (isGroupClass) {
                        return (this.getAccess() & grp_mask) > 0;
                    }
                    return (this.getAccess() & all_mask) > 0;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException ex) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canRead(ExecutionEnvironment env) {
            return this.can(env, (short)4, (short)32, (short)256);
        }

        public boolean canWrite(ExecutionEnvironment env) {
            return this.can(env, (short)2, (short)16, (short)128);
        }

        public boolean canExecute(ExecutionEnvironment env) {
            return this.can(env, (short)1, (short)8, (short)64);
        }

        public String toString() {
            return this.name + ' ' + this.uid + ' ' + this.gid + ' ' + FileInfoProvider.accessToString(this.getAccess()) + ' ' + this.isDirectory() + ' ' + this.lastModified + ' ' + (this.isLink() ? " -> " + this.linkTarget : "");
        }

        public static enum FileType {
            NamedPipe('p', 4096),
            CharacterSpecial('c', 8192),
            MultiplexedCharacterSpecial('m', 12288),
            Directory('d', 16384),
            SpecialNamed('N', 20480),
            BlockSpecial('b', 24576),
            MultiplexedBlockSpecial('M', 28672),
            Regular('-', 32768),
            NetworkSpecial('n', 36864),
            SymbolicLink('l', 40960),
            Shadow('S', 45056),
            Socket('s', 49152),
            Door('D', 53248),
            EventPort('P', 57344),
            Undefined('u', 0);

            private final char letter;
            private final int fileType;

            private FileType(char letter, int fileType) {
                this.letter = letter;
                this.fileType = fileType;
            }

            public char toChar() {
                return this.letter;
            }

            public int toInt() {
                return this.letter;
            }

            public static FileType fromChar(char letter) {
                for (FileType type : FileType.values()) {
                    if (type.letter != letter) continue;
                    return type;
                }
                return Undefined;
            }

            public static FileType fromInt(int fileType) {
                for (FileType type : FileType.values()) {
                    if (type.fileType != fileType) continue;
                    return type;
                }
                return Undefined;
            }
        }
    }
}

