/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

abstract class MoveTreeCommand
extends GitCommand {
    private final File source;
    private final File target;
    private final boolean after;
    private final ProgressMonitor monitor;
    private final boolean keepSourceTree;
    private final FileListener listener;

    protected MoveTreeCommand(Repository repository, File source, File target, boolean after, boolean keepSourceTree, ProgressMonitor monitor, FileListener listener) {
        super(repository, monitor);
        this.source = source;
        this.target = target;
        this.monitor = monitor;
        this.listener = listener;
        this.after = after;
        this.keepSourceTree = keepSourceTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        if (!this.keepSourceTree && !this.after) {
            this.rename();
        }
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.lockDirCache();
            try {
                DirCacheBuilder builder = cache.builder();
                TreeWalk treeWalk = new TreeWalk(repository);
                PathFilter sourceFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), this.source));
                PathFilter targetFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), this.target));
                treeWalk.setFilter(PathFilterGroup.create(Arrays.asList(sourceFilter, targetFilter)));
                treeWalk.setRecursive(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    File file = new File(repository.getWorkTree().getAbsolutePath() + File.separator + path);
                    DirCacheEntry e = ((DirCacheBuildIterator)treeWalk.getTree(0, DirCacheBuildIterator.class)).getDirCacheEntry();
                    if (e == null) continue;
                    if (targetFilter.include(treeWalk)) {
                        this.monitor.notifyWarning(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Warning_IndexEntryExists", (Object)path));
                        continue;
                    }
                    String newPath = this.getRelativePath(file, this.source, this.target);
                    DirCacheEntry copied = new DirCacheEntry(newPath);
                    copied.copyMetaData(e);
                    File newFile = new File(repository.getWorkTree().getAbsolutePath() + File.separator + newPath);
                    this.listener.notifyFile(newFile, treeWalk.getPathString());
                    builder.add(copied);
                    if (!this.keepSourceTree) continue;
                    builder.add(e);
                }
                if (!this.monitor.isCanceled()) {
                    builder.commit();
                }
            }
            finally {
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String relPathToTarget;
            File workTree = this.getRepository().getWorkTree();
            String relPathToSource = Utils.getRelativePath(workTree, this.source);
            if (relPathToSource.startsWith((relPathToTarget = Utils.getRelativePath(workTree, this.target)) + "/")) {
                this.monitor.preparationsFailed(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Error_SourceFolderUnderTarget", (Object[])new Object[]{relPathToSource, relPathToTarget}));
                throw new GitException(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Error_SourceFolderUnderTarget", (Object[])new Object[]{relPathToSource, relPathToTarget}));
            }
            if (relPathToTarget.startsWith(relPathToSource + "/")) {
                this.monitor.preparationsFailed(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Error_TargetFolderUnderSource", (Object[])new Object[]{relPathToTarget, relPathToSource}));
                throw new GitException(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Error_TargetFolderUnderSource", (Object[])new Object[]{relPathToTarget, relPathToSource}));
            }
        }
        return retval;
    }

    private void rename() throws GitException {
        File parentFile = this.target.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new GitException(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Exception_CannotCreateFolder", (Object)parentFile.getAbsolutePath()));
        }
        if (!this.source.renameTo(this.target)) {
            throw new GitException(NbBundle.getMessage(MoveTreeCommand.class, (String)"MSG_Exception_CannotRenameTo", (Object)this.target.getAbsolutePath()));
        }
    }

    private String getRelativePath(File file, File ancestor, File target) {
        String relativePathToAncestor = Utils.getRelativePath(ancestor, file);
        StringBuilder relativePathToSource = new StringBuilder(Utils.getRelativePath(this.getRepository().getWorkTree(), target));
        if (!relativePathToAncestor.isEmpty()) {
            if (relativePathToSource.length() > 0) {
                relativePathToSource.append("/");
            }
            relativePathToSource.append(relativePathToAncestor);
        }
        return relativePathToSource.toString();
    }
}

