/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.OrRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.jgit.JGitRevisionInfo;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;

public class LogCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final RevisionInfoListener listener;
    private final List<GitRevisionInfo> revisions;
    private final String revision;
    private final SearchCriteria criteria;

    public LogCommand(Repository repository, SearchCriteria criteria, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = criteria;
        this.revision = null;
        this.revisions = new LinkedList<GitRevisionInfo>();
    }

    public LogCommand(Repository repository, String revision, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = null;
        this.revision = revision;
        this.revisions = new LinkedList<GitRevisionInfo>();
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        if (this.revision != null) {
            RevCommit commit = Utils.findCommit(repository, this.revision);
            this.addRevision(new JGitRevisionInfo(commit, repository));
        } else {
            RevWalk walk = new RevWalk(repository);
            RevWalk fullWalk = new RevWalk(repository);
            try {
                String revisionFrom = this.criteria.getRevisionFrom();
                String revisionTo = this.criteria.getRevisionTo();
                if (revisionTo != null && revisionFrom != null) {
                    for (RevCommit uninteresting : Utils.findCommit(repository, revisionFrom).getParents()) {
                        walk.markUninteresting(walk.parseCommit((AnyObjectId)uninteresting));
                    }
                    walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, revisionTo)));
                } else if (revisionTo != null) {
                    walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, revisionTo)));
                } else if (revisionFrom != null) {
                    for (RevCommit uninteresting : Utils.findCommit(repository, revisionFrom).getParents()) {
                        walk.markUninteresting(walk.parseCommit((AnyObjectId)uninteresting));
                    }
                    walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, "HEAD")));
                } else {
                    ListBranchCommand branchCommand = new ListBranchCommand(repository, false, ProgressMonitor.NULL_PROGRESS_MONITOR);
                    branchCommand.execute();
                    for (Map.Entry<String, GitBranch> e : branchCommand.getBranches().entrySet()) {
                        walk.markStart(walk.lookupCommit((AnyObjectId)Utils.findCommit(repository, e.getValue().getId())));
                    }
                }
                this.applyCriteria(walk, this.criteria);
                walk.sort(RevSort.TOPO);
                walk.sort(RevSort.COMMIT_TIME_DESC, true);
                Iterator it = walk.iterator();
                for (int remaining = this.criteria.getLimit(); it.hasNext() && !this.monitor.isCanceled() && remaining != 0; --remaining) {
                    RevCommit commit = (RevCommit)it.next();
                    this.addRevision(new JGitRevisionInfo(fullWalk.parseCommit((AnyObjectId)commit), repository));
                }
            }
            catch (MissingObjectException ex) {
                throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
            finally {
                walk.release();
                fullWalk.release();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git log --name-status ");
        if (this.criteria != null && this.criteria.isFollow() && this.criteria.getFiles() != null && this.criteria.getFiles().length == 1) {
            sb.append("--follow ");
        }
        if (this.revision != null) {
            sb.append("--no-walk ").append(this.revision);
        } else if (this.criteria.getRevisionTo() != null && this.criteria.getRevisionFrom() != null) {
            sb.append(this.criteria.getRevisionFrom()).append("..").append(this.criteria.getRevisionTo());
        } else if (this.criteria.getRevisionTo() != null) {
            sb.append(this.criteria.getRevisionTo());
        } else if (this.criteria.getRevisionFrom() != null) {
            sb.append(this.criteria.getRevisionFrom()).append("..");
        }
        return sb.toString();
    }

    public GitRevisionInfo[] getRevisions() {
        return this.revisions.toArray(new GitRevisionInfo[this.revisions.size()]);
    }

    private void addRevision(JGitRevisionInfo info) {
        this.revisions.add(info);
        this.listener.notifyRevisionInfo(info);
    }

    private void applyCriteria(RevWalk walk, SearchCriteria criteria) {
        String message;
        Collection<PathFilter> pathFilters;
        File[] files = criteria.getFiles();
        if (files.length > 0 && !(pathFilters = Utils.getPathFilters(this.getRepository().getWorkTree(), files)).isEmpty()) {
            if (criteria.isFollow() && pathFilters.size() == 1) {
                walk.setTreeFilter((TreeFilter)FollowFilter.create((String)pathFilters.iterator().next().getPath()));
            } else {
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilterGroup.create(pathFilters)));
            }
        }
        RevFilter filter = criteria.isIncludeMerges() ? RevFilter.ALL : RevFilter.NO_MERGES;
        String username = criteria.getUsername();
        if (username != null && !(username = username.trim()).isEmpty()) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)OrRevFilter.create((RevFilter)CommitterRevFilter.create((String)username), (RevFilter)AuthorRevFilter.create((String)username)));
        }
        if ((message = criteria.getMessage()) != null && !(message = message.trim()).isEmpty()) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)MessageRevFilter.create((String)message));
        }
        Date from = criteria.getFrom();
        Date to = criteria.getTo();
        if (from != null && to != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.between((Date)from, (Date)to));
        } else if (from != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.after((Date)from));
        } else if (to != null) {
            filter = AndRevFilter.create((RevFilter)filter, (RevFilter)CommitTimeRevFilter.before((Date)to));
        }
        walk.setRevFilter(filter);
    }
}

