/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.JGitRevisionInfo;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ExportCommitCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final OutputStream out;
    private final FileListener listener;
    private final String revisionStr;
    private static final char NL = '\n';

    public ExportCommitCommand(Repository repository, String revisionStr, OutputStream out, ProgressMonitor monitor, FileListener listener) {
        super(repository, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.out = out;
        this.revisionStr = revisionStr;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        String workTreePath = repository.getWorkTree().getAbsolutePath();
        RevCommit commit = Utils.findCommit(repository, this.revisionStr);
        if (commit.getParentCount() > 1) {
            throw new GitException("Unable to export a merge commit");
        }
        DiffFormatter formatter = null;
        try {
            List diffEntries;
            this.out.write(Constants.encode((String)this.formatCommitInfo(commit)));
            formatter = new DiffFormatter(this.out);
            formatter.setRepository(repository);
            if (commit.getParentCount() > 0) {
                formatter.setDetectRenames(true);
                diffEntries = formatter.scan((AnyObjectId)commit.getParent(0), (AnyObjectId)commit);
            } else {
                TreeWalk walk = new TreeWalk(repository);
                walk.reset();
                walk.setRecursive(true);
                walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                walk.addTree((AnyObjectId)commit.getTree());
                walk.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.ANY_DIFF));
                diffEntries = DiffEntry.scan((TreeWalk)walk);
            }
            for (DiffEntry ent : diffEntries) {
                if (this.monitor.isCanceled()) break;
                this.listener.notifyFile(new File(workTreePath + File.separator + ent.getNewPath()), ent.getNewPath());
                formatter.format(ent);
            }
            formatter.flush();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (formatter != null) {
                formatter.release();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git format-patch --no-stat -1 " + this.revisionStr;
    }

    private String formatCommitInfo(RevCommit commit) {
        JGitRevisionInfo info = new JGitRevisionInfo(commit, this.getRepository());
        StringBuilder sb = new StringBuilder();
        sb.append("From ").append(info.getRevision()).append(" ").append("Mon Sep 17 00:00:00 2001").append('\n');
        if (info.getAuthor() != null) {
            sb.append("From: ").append(info.getAuthor().toString()).append('\n');
        } else if (info.getCommitter() != null) {
            sb.append("From: ").append(info.getAuthor().toString()).append('\n');
        }
        sb.append("Date: ").append(DateFormat.getDateTimeInstance().format(new Date(info.getCommitTime()))).append('\n');
        sb.append('\n').append(info.getFullMessage()).append('\n').append('\n');
        return sb.toString();
    }
}

