/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public class CatCommand
extends GitCommand {
    private final String revision;
    private final File file;
    private final OutputStream os;
    private final ProgressMonitor monitor;
    private String relativePath;
    private boolean found;
    private final boolean fromRevision;
    private final int stage;

    public CatCommand(Repository repository, File file, String revision, OutputStream out, ProgressMonitor monitor) {
        super(repository, monitor);
        this.file = file;
        this.revision = revision;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = true;
        this.stage = 0;
    }

    public CatCommand(Repository repository, File file, int stage, OutputStream out, ProgressMonitor monitor) {
        super(repository, monitor);
        this.file = file;
        this.revision = null;
        this.os = out;
        this.monitor = monitor;
        this.fromRevision = false;
        this.stage = stage;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            this.relativePath = Utils.getRelativePath(this.getRepository().getWorkTree(), this.file);
            if (this.relativePath.isEmpty()) {
                String message = NbBundle.getMessage(CatCommand.class, (String)"MSG_Error_CannotCatRoot", (Object)this.file);
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    @Override
    protected void run() throws GitException {
        if (this.fromRevision) {
            this.catFromRevision();
        } else {
            this.catIndexEntry();
        }
    }

    private void catFromRevision() throws GitException.MissingObjectException, GitException {
        Repository repository = this.getRepository();
        try {
            RevCommit commit = Utils.findCommit(repository, this.revision);
            TreeWalk walk = new TreeWalk(repository);
            walk.reset();
            walk.addTree((AnyObjectId)commit.getTree());
            walk.setFilter((TreeFilter)PathFilter.create((String)this.relativePath));
            walk.setRecursive(true);
            this.found = false;
            while (!this.found && walk.next() && !this.monitor.isCanceled()) {
                if (!this.relativePath.equals(walk.getPathString())) continue;
                ObjectLoader loader = repository.getObjectDatabase().open((AnyObjectId)walk.getObjectId(0));
                loader.copyTo(this.os);
                this.os.close();
                this.found = true;
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    private void catIndexEntry() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.readDirCache();
            int pos = cache.findEntry(this.relativePath);
            DirCacheEntry entry = null;
            if (pos >= 0) {
                DirCacheEntry e = cache.getEntry(pos);
                do {
                    if (this.stage != e.getStage()) continue;
                    entry = e;
                } while (entry == null && ++pos < cache.getEntryCount() && this.relativePath.equals((e = cache.getEntry(pos)).getPathString()));
            }
            this.found = false;
            if (entry != null) {
                this.found = true;
                ObjectLoader loader = repository.getObjectDatabase().open((AnyObjectId)entry.getObjectId());
                loader.copyTo(this.os);
                this.os.close();
                this.found = true;
            }
        }
        catch (NoWorkTreeException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git show " + this.revision + " " + this.file;
    }

    public boolean foundInRevision() {
        return this.found;
    }
}

