/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LinkButton
extends JButton
implements MouseListener {
    private static final Font BUTTON_FONT = LinkButton.getButtonFont();
    private static final Color LINK_IN_FOCUS_COLOR = new Color(16748032);
    private static final Color LINK_COLOR = new Color(1461115);
    private static final Color MOUSE_OVER_LINK_COLOR = new Color(16748032);
    private static final Color VISITED_LINK_COLOR = new Color(5607890);
    private static final Stroke LINK_IN_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
    private boolean underline = false;

    public LinkButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public LinkButton(Action a) {
        super(a);
        this.init();
    }

    public LinkButton(String text) {
        super(text);
        this.init();
    }

    public LinkButton(Icon icon) {
        super(icon);
        this.init();
    }

    public LinkButton() {
        this.init();
    }

    private void init() {
        this.setForeground(LINK_COLOR);
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(LINK_IN_FOCUS_COLOR);
            this.repaint();
            this.onMouseEntered(e);
            this.setForeground(MOUSE_OVER_LINK_COLOR);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            this.setForeground(this.isVisited() ? VISITED_LINK_COLOR : LINK_COLOR);
            this.repaint();
            this.onMouseExited(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = LinkButton.prepareGraphics(g);
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(LINK_IN_FOCUS_COLOR);
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled()) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    private static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            g2.addRenderingHints(rhints);
        }
        return g2;
    }

    private static Font getButtonFont() {
        Font defaultFont = UIManager.getFont("Button.font");
        if (defaultFont != null) {
            return defaultFont;
        }
        return new Font(null, 0, 12);
    }
}

