/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;

public class TplHtmlEmbeddingProvider
extends EmbeddingProvider {
    private static final String MIME_TYPE_HTML = "text/html";
    private static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), TplTopTokenId.language());
        TokenSequence sequence = th.tokenSequence(TplTopTokenId.language());
        if (sequence == null) {
            Logger.getLogger("TplHtmlEmbeddingProvider").warning("TokenHierarchy.tokenSequence(TplTopTokenId.language()) == null for static immutable TPL TokenHierarchy!\nFile = '" + snapshot.getSource().getFileObject().getPath() + "' ;snapshot mimepath='" + snapshot.getMimePath() + "'");
            return Collections.emptyList();
        }
        sequence.moveStart();
        boolean lastEmbeddingIsVirtual = false;
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == TplTopTokenId.T_HTML) {
                embeddings.add(snapshot.create(sequence.offset(), t.length(), MIME_TYPE_HTML));
                lastEmbeddingIsVirtual = false;
                continue;
            }
            if (lastEmbeddingIsVirtual) continue;
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, MIME_TYPE_HTML));
            lastEmbeddingIsVirtual = true;
        }
        if (embeddings.isEmpty()) {
            return Collections.singletonList(snapshot.create((CharSequence)"", MIME_TYPE_HTML));
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 140;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection create(Snapshot snapshot) {
            return Collections.singletonList(new TplHtmlEmbeddingProvider());
        }
    }
}

