/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty;

import java.util.EnumSet;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.smarty.SmartyPhpFrameworkProvider;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.modules.php.smarty.ui.customizer.SmartyCustomizerPanel;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleCustomizerExtender;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SmartyPhpModuleCustomizerExtender
extends PhpModuleCustomizerExtender {
    public static final String CUSTOM_OPEN_DELIMITER = "custom-open-delimiter";
    public static final String CUSTOM_CLOSE_DELIMITER = "custom-close-delimiter";
    private final PhpModule phpModule;
    private final String customOpenDelimiter;
    private final String customCloseDelimiter;
    private SmartyCustomizerPanel component;

    SmartyPhpModuleCustomizerExtender(PhpModule phpModule) {
        this.phpModule = phpModule;
        this.customOpenDelimiter = SmartyPhpModuleCustomizerExtender.getCustomOpenDelimiter(phpModule);
        this.customCloseDelimiter = SmartyPhpModuleCustomizerExtender.getCustomCloseDelimiter(phpModule);
    }

    public static String getCustomOpenDelimiter(PhpModule phpModule) {
        return SmartyPhpModuleCustomizerExtender.getPreferences(phpModule).get(CUSTOM_OPEN_DELIMITER, "");
    }

    public static String getCustomCloseDelimiter(PhpModule phpModule) {
        return SmartyPhpModuleCustomizerExtender.getPreferences(phpModule).get(CUSTOM_CLOSE_DELIMITER, "");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SmartyPhpModuleCustomizerExtender.class, (String)"LBL_Smarty");
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public String getErrorMessage() {
        return null;
    }

    public EnumSet<PhpModule.Change> save(PhpModule phpModule) {
        if (!this.getPanel().getCustomOpenDelimiterTextField().equals(this.customOpenDelimiter) || !this.getPanel().getCustomCloseDelimiterTextField().equals(this.customCloseDelimiter)) {
            this.getPreferences().put(CUSTOM_OPEN_DELIMITER, this.getPanel().getCustomOpenDelimiterTextField());
            this.getPreferences().put(CUSTOM_CLOSE_DELIMITER, this.getPanel().getCustomCloseDelimiterTextField());
            LexerUtils.relexerOpenedTpls();
        }
        return null;
    }

    private SmartyCustomizerPanel getPanel() {
        if (this.component == null) {
            this.component = new SmartyCustomizerPanel();
            this.component.setCustomOpenDelimiterText(this.customOpenDelimiter);
            this.component.setCustomCloseDelimiterText(this.customCloseDelimiter);
        }
        return this.component;
    }

    private Preferences getPreferences() {
        return SmartyPhpModuleCustomizerExtender.getPreferences(this.phpModule);
    }

    private static Preferences getPreferences(PhpModule module) {
        return module.getPreferences(SmartyPhpFrameworkProvider.class, true);
    }
}

