/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.wizard.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class NameIconLocationPanel
extends BasicWizardIterator.Panel {
    private static final Map<String, Object> PURE_TEMPLATES_FILTER = new HashMap<String, Object>(2);
    private static final String TEMPLATES_DIR = "Templates";
    private static final String DEFAULT_CATEGORY_PATH = "Templates/Other";
    private static final RequestProcessor RP = new RequestProcessor(NameIconLocationPanel.class);
    private boolean categoriesLoaded;
    private boolean firstTime = true;
    private DataModel data;
    private static final String ENTER_LABEL;
    private static final String NONE_LABEL;
    private JComboBox category;
    private JLabel categoryTxt;
    private JTextField classNamePrefix;
    private JLabel classNamePrefixTxt;
    private JTextArea createdFiles;
    private JScrollPane createdFilesSP;
    private JLabel createdFilesTxt;
    private JTextField displayName;
    private JLabel displayNameTxt;
    private JTextField icon;
    private JButton iconButton;
    private JLabel iconTxt;
    private JTextArea modifiedFiles;
    private JScrollPane modifiedFilesSP;
    private JLabel modifiedFilesTxt;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JTextField project;
    private JLabel projectTxt;

    public NameIconLocationPanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NameIconLocationPanel.getMessage("LBL_WizardWizardTitle"));
        UIUtil.DocumentAdapter updateListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameIconLocationPanel.this.updateData();
            }
        };
        this.classNamePrefix.getDocument().addDocumentListener(updateListener);
        this.displayName.getDocument().addDocumentListener(updateListener);
        this.icon.getDocument().addDocumentListener(updateListener);
        Component editorComp = this.packageName.getEditor().getEditorComponent();
        if (editorComp instanceof JTextComponent) {
            ((JTextComponent)editorComp).getDocument().addDocumentListener(updateListener);
        }
        if (this.category.getEditor().getEditorComponent() instanceof JTextField) {
            JTextComponent txt = (JTextComponent)this.category.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener(updateListener);
        }
    }

    @Override
    protected String getPanelName() {
        return NameIconLocationPanel.getMessage("LBL_NameIconLocation_Title");
    }

    private String getCategoryPath() {
        String path = UIUtil.getSFSPath(this.category, TEMPLATES_DIR);
        return path == null ? DEFAULT_CATEGORY_PATH : path;
    }

    @Override
    protected void storeToDataModel() {
        this.data.setClassNamePrefix(this.getClassNamePrefix());
        this.data.setPackageName(this.packageName.getEditor().getItem().toString());
        if (this.data.isFileTemplateType()) {
            this.data.setDisplayName(this.displayName.getText());
            if (this.icon.getText().trim().length() > 0) {
                this.data.setIcon(this.icon.getText().equals(NONE_LABEL) ? null : this.icon.getText());
            }
            this.data.setCategory(this.getCategoryPath());
        }
    }

    @Override
    protected void readFromDataModel() {
        boolean isFileTemplate = this.data.isFileTemplateType();
        this.displayName.setVisible(isFileTemplate);
        this.displayNameTxt.setVisible(isFileTemplate);
        this.category.setVisible(isFileTemplate);
        this.categoryTxt.setVisible(isFileTemplate);
        this.icon.setVisible(isFileTemplate);
        this.iconButton.setVisible(isFileTemplate);
        this.iconTxt.setVisible(isFileTemplate);
        if (isFileTemplate && !this.categoriesLoaded) {
            this.category.setModel(UIUtil.createComboWaitModel());
            RP.post(new Runnable(){

                @Override
                public void run() {
                    final ComboBoxModel model = UIUtil.createLayerPresenterComboModel(NameIconLocationPanel.this.data.getProject(), NameIconLocationPanel.TEMPLATES_DIR, PURE_TEMPLATES_FILTER);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NameIconLocationPanel.this.category.setModel(model);
                        }
                    });
                }
            });
            this.categoriesLoaded = true;
        }
        if (this.firstTime) {
            if (this.data.getPackageName() != null) {
                this.packageName.setSelectedItem(this.data.getPackageName());
            }
            this.firstTime = false;
            this.markInvalid();
        } else {
            this.updateData();
        }
    }

    private void updateData() {
        this.storeToDataModel();
        if (this.checkValidity()) {
            CreatedModifiedFiles files = this.data.getCreatedModifiedFiles();
            this.createdFiles.setText(UIUtil.generateTextAreaContent(files.getCreatedPaths()));
            this.modifiedFiles.setText(UIUtil.generateTextAreaContent(files.getModifiedPaths()));
        }
    }

    private boolean checkValidity() {
        boolean valid = false;
        String pName = this.packageName.getEditor().getItem().toString().trim();
        if (!Utilities.isJavaIdentifier((String)this.getClassNamePrefix())) {
            this.setError(NameIconLocationPanel.getMessage("MSG_ClassNameMustBeValidJavaIdentifier"));
        } else if (this.data.isFileTemplateType() && (this.getDisplayName().equals("") || this.getDisplayName().equals(ENTER_LABEL))) {
            this.setError(NameIconLocationPanel.getMessage("MSG_DisplayNameMustBeEntered"));
        } else if (pName.length() == 0 || !UIUtil.isValidPackageName(pName)) {
            this.setError(NameIconLocationPanel.getMessage("ERR_Package_Invalid"));
        } else if (this.data.getCreatedModifiedFiles().getInvalidPaths().length > 0) {
            String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
            this.setError(NbBundle.getMessage(NameIconLocationPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)invalid[0]));
        } else if (!Util.isValidSFSPath(this.getCategoryPath())) {
            this.setError(NameIconLocationPanel.getMessage("ERR_Category_Invalid"));
        } else {
            File iconFile;
            String path = this.icon.getText().trim();
            File file = iconFile = path.length() == 0 ? null : new File(path);
            if (this.icon.isVisible() && (iconFile == null || !iconFile.exists())) {
                this.setWarning(UIUtil.getNoIconSelectedWarning(16, 16));
            } else if (this.icon.isVisible() && !UIUtil.isValidIcon(iconFile, 16, 16)) {
                this.setWarning(UIUtil.getIconDimensionWarning(iconFile, 16, 16));
            } else {
                this.markValid();
            }
            valid = true;
        }
        return valid;
    }

    private String getDisplayName() {
        return this.displayName.getText().trim();
    }

    private String getClassNamePrefix() {
        return this.classNamePrefix.getText().trim();
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(NameIconLocationPanel.class);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_NameIconLocationPanel"));
        this.classNamePrefix.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_ClassNamePrefix"));
        this.displayName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_DisplayName"));
        this.category.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_Category"));
        this.icon.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_Icon"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_IconBrowse"));
        this.project.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_ProjectName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_PackageName"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_CreatedFiles"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_LBL_ModifiedFiles"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(NameIconLocationPanel.class, (String)key);
    }

    private void initComponents() {
        this.classNamePrefixTxt = new JLabel();
        this.classNamePrefix = new JTextField();
        this.displayNameTxt = new JLabel();
        this.displayName = new JTextField();
        this.categoryTxt = new JLabel();
        this.category = new JComboBox();
        this.iconTxt = new JLabel();
        this.icon = new JTextField();
        this.iconButton = new JButton();
        this.projectTxt = new JLabel();
        this.project = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.packageNameTxt = new JLabel();
        this.packageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFilesTxt = new JLabel();
        this.modifiedFilesTxt = new JLabel();
        this.createdFilesSP = new JScrollPane();
        this.createdFiles = new JTextArea();
        this.modifiedFilesSP = new JScrollPane();
        this.modifiedFiles = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.classNamePrefixTxt.setLabelFor(this.classNamePrefix);
        Mnemonics.setLocalizedText((JLabel)this.classNamePrefixTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ClassNamePrefix"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.classNamePrefixTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.classNamePrefix, gridBagConstraints);
        this.displayNameTxt.setLabelFor(this.displayName);
        Mnemonics.setLocalizedText((JLabel)this.displayNameTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.displayNameTxt, gridBagConstraints);
        this.displayName.setText(NbBundle.getMessage(NameIconLocationPanel.class, (String)"CTL_EnterLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.displayName, gridBagConstraints);
        this.categoryTxt.setLabelFor(this.category);
        Mnemonics.setLocalizedText((JLabel)this.categoryTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_Category"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 12);
        this.add((Component)this.categoryTxt, gridBagConstraints);
        this.category.setEditable(true);
        this.category.setPrototypeDisplayValue("Refactor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.category, gridBagConstraints);
        this.iconTxt.setLabelFor(this.icon);
        Mnemonics.setLocalizedText((JLabel)this.iconTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.iconTxt, gridBagConstraints);
        this.icon.setEditable(false);
        this.icon.setText(NbBundle.getMessage(NameIconLocationPanel.class, (String)"CTL_None"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.icon, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_Icon_Browse"));
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameIconLocationPanel.this.iconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(18, 12, 0, 0);
        this.add((Component)this.iconButton, gridBagConstraints);
        this.projectTxt.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectTxt, gridBagConstraints);
        this.project.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.project, gridBagConstraints);
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 36, 12);
        this.add((Component)this.packageNameTxt, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 36, 0);
        this.add((Component)this.packageName, gridBagConstraints);
        this.createdFilesTxt.setLabelFor(this.createdFiles);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.createdFilesTxt, gridBagConstraints);
        this.modifiedFilesTxt.setLabelFor(this.modifiedFiles);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFilesTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.modifiedFilesTxt, gridBagConstraints);
        this.createdFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFiles.setColumns(20);
        this.createdFiles.setEditable(false);
        this.createdFiles.setRows(5);
        this.createdFiles.setBorder(null);
        this.createdFilesSP.setViewportView(this.createdFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.createdFilesSP, gridBagConstraints);
        this.modifiedFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFiles.setColumns(20);
        this.modifiedFiles.setEditable(false);
        this.modifiedFiles.setRows(5);
        this.modifiedFiles.setToolTipText("modifiedFilesValue");
        this.modifiedFiles.setBorder(null);
        this.modifiedFilesSP.setViewportView(this.modifiedFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.modifiedFilesSP, gridBagConstraints);
    }

    private void iconButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = UIUtil.getIconFileChooser(this.icon.getText());
        int ret = chooser.showDialog(this, NameIconLocationPanel.getMessage("LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            this.icon.setText(file.getAbsolutePath());
        }
    }

    static {
        PURE_TEMPLATES_FILTER.put("template", true);
        PURE_TEMPLATES_FILTER.put("simple", false);
        ENTER_LABEL = NameIconLocationPanel.getMessage("CTL_EnterLabel");
        NONE_LABEL = NameIconLocationPanel.getMessage("CTL_None");
    }
}

