/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.layer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.layer.Bundle;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class LayerPanel
extends BasicWizardIterator.Panel {
    private final BasicWizardIterator.BasicDataModel data;
    private final CreatedModifiedFiles cmf;
    private JTextArea createdFiles;
    private JLabel createdFilesLabel;
    private JTextField project;
    private JLabel projectLabel;

    LayerPanel(WizardDescriptor wiz, BasicWizardIterator.BasicDataModel data, CreatedModifiedFiles cmf) {
        super(wiz);
        this.data = data;
        this.cmf = cmf;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", Bundle.panel_title());
    }

    @Override
    protected String getPanelName() {
        return Bundle.panel_name();
    }

    @Override
    protected void storeToDataModel() {
    }

    @Override
    protected void readFromDataModel() {
        this.createdFiles.setText(UIUtil.generateTextAreaContent(this.cmf.getCreatedPaths()));
        if (LayerHandle.forProject(this.data.getProject()).getLayerFile() != null) {
            this.setError(Bundle.already_layer());
        } else {
            this.markValid();
        }
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx("apisupport_about_xml_layers");
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.project = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFilesLabel = new JLabel();
        this.createdFiles = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(LayerPanel.class, (String)"LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.project.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.project, gridBagConstraints);
        this.createdFilesLabel.setLabelFor(this.createdFiles);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesLabel, (String)NbBundle.getMessage(LayerPanel.class, (String)"LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFilesLabel, gridBagConstraints);
        this.createdFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFiles.setColumns(20);
        this.createdFiles.setEditable(false);
        this.createdFiles.setRows(5);
        this.createdFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LayerPanel.class, (String)"ACN_LayerPanel", (Object[])new Object[0]));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LayerPanel.class, (String)"ACD_LayerPanel", (Object[])new Object[0]));
    }
}

