/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryImplementation;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibraryManager;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibrarySupport;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

class JaxRsStackSupportImpl
implements JaxRsStackSupportImplementation {
    private static final String API = "api";
    private static final String JAX_RS = "jax-rs";
    private static final String JERSEY = "jersey";
    private static final String JSON = "json";
    private static final String JETTISON = "jettison";
    private static final String ROME = "rome";
    private final WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl;

    JaxRsStackSupportImpl(WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl) {
        this.platformImpl = platformImpl;
    }

    public boolean addJsr311Api(Project project) {
        FileObject core;
        if (this.hasJee6Profile() && (core = this.getJarFile("com.sun.jersey.core_")) != null) {
            try {
                return this.addJars(project, Collections.singleton(core.getURL()));
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
                return false;
            }
        }
        return this.addJsr311ServerLibraryApi(project);
    }

    public boolean extendsJerseyProjectClasspath(Project project) {
        if (this.hasJee6Profile()) {
            try {
                List<URL> urls = this.getJerseyJars();
                return this.addJars(project, urls);
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
                return false;
            }
        }
        return this.extendsJerseyServerLibraries(project);
    }

    public void removeJaxRsLibraries(Project project) {
        if (this.hasJee6Profile()) {
            try {
                List<URL> urls = this.getJerseyJars();
                FileObject core = this.getJarFile("com.sun.jersey.core_");
                if (core != null) {
                    urls.add(core.getURL());
                }
                this.removeLibraries(project, urls);
            }
            catch (FileStateInvalidException e) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.WARNING, "Exception during extending a project classpath", e);
            }
        }
    }

    private boolean extendsJerseyServerLibraries(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Collection<ServerLibrary> serverLibraries = this.getServerJerseyLibraries();
        if (provider != null && serverLibraries.size() > 0) {
            try {
                for (ServerLibrary serverLibrary : serverLibraries) {
                    provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)serverLibrary.getName(), (Version)serverLibrary.getSpecificationVersion(), (Version)serverLibrary.getImplementationVersion()));
                }
                Preferences prefs = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
                prefs.put(BrokenServerLibrarySupport.OFFER_LIBRARY_DEPLOYMENT, Boolean.TRUE.toString());
                return true;
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, "Exception during extending a project classpath", ex);
                return false;
            }
        }
        return false;
    }

    private boolean hasJee6Profile() {
        Set<Profile> profiles = this.platformImpl.getSupportedProfiles();
        return profiles.contains(Profile.JAVA_EE_6_FULL) || profiles.contains(Profile.JAVA_EE_6_WEB);
    }

    private List<URL> getJerseyJars() throws FileStateInvalidException {
        FileObject jettison;
        FileObject jacksonXc;
        FileObject jacksonMapper;
        FileObject jacksonJaxRs;
        FileObject asl;
        FileObject server;
        FileObject multipart;
        FileObject json;
        FileObject client = this.getJarFile("com.sun.jersey.client_");
        LinkedList<URL> urls = new LinkedList<URL>();
        if (client != null) {
            urls.add(client.getURL());
        }
        if ((json = this.getJarFile("com.sun.jersey.json_")) != null) {
            urls.add(json.getURL());
        }
        if ((multipart = this.getJarFile("com.sun.jersey.multipart_")) != null) {
            urls.add(multipart.getURL());
        }
        if ((server = this.getJarFile("com.sun.jersey.server_")) != null) {
            urls.add(server.getURL());
        }
        if ((asl = this.getJarFile("org.codehaus.jackson.core.asl_")) != null) {
            urls.add(asl.getURL());
        }
        if ((jacksonJaxRs = this.getJarFile("org.codehaus.jackson.jaxrs_")) != null) {
            urls.add(jacksonJaxRs.getURL());
        }
        if ((jacksonMapper = this.getJarFile("org.codehaus.jackson.mapper.asl_")) != null) {
            urls.add(jacksonMapper.getURL());
        }
        if ((jacksonXc = this.getJarFile("org.codehaus.jackson.xc_")) != null) {
            urls.add(jacksonXc.getURL());
        }
        if ((jettison = this.getJarFile("org.codehaus.jettison_")) != null) {
            urls.add(jettison.getURL());
        }
        return urls;
    }

    private boolean addJsr311ServerLibraryApi(Project project) {
        WLServerLibrarySupport support = this.getLibrarySupport();
        Set<WLServerLibrarySupport.WLServerLibrary> libraries = support.getDeployedLibraries();
        for (WLServerLibrarySupport.WLServerLibrary library : libraries) {
            String title = library.getImplementationTitle();
            if (title == null || !title.toLowerCase(Locale.ENGLISH).contains(JAX_RS) || !title.toLowerCase(Locale.ENGLISH).contains(API)) continue;
            ServerLibrary apiLib = ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)library);
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            try {
                provider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)apiLib.getName(), (Version)apiLib.getSpecificationVersion(), (Version)apiLib.getImplementationVersion()));
            }
            catch (ConfigurationException ex) {
                Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                return false;
            }
            return true;
        }
        return false;
    }

    private Collection<ServerLibrary> getServerJerseyLibraries() {
        WLServerLibraryManager manager = this.getLibraryManager();
        LinkedList<ServerLibrary> libraries = new LinkedList<ServerLibrary>();
        libraries.addAll(this.findJerseyLibraries(manager.getDeployableLibraries()));
        libraries.addAll(this.findJerseyLibraries(manager.getDeployedLibraries()));
        return libraries;
    }

    private Collection<ServerLibrary> findJerseyLibraries(Collection<ServerLibrary> collection) {
        ArrayList<ServerLibrary> result = new ArrayList<ServerLibrary>(collection.size());
        for (ServerLibrary library : collection) {
            String title = library.getImplementationTitle();
            if (title == null || !(title = title.toLowerCase(Locale.ENGLISH)).contains(JERSEY) && !title.contains(JSON) && !title.contains(ROME) && !title.contains(JETTISON)) continue;
            result.add(library);
        }
        return result;
    }

    private WLServerLibraryManager getLibraryManager() {
        return new WLServerLibraryManager(this.platformImpl.getDeploymentManager());
    }

    private WLServerLibrarySupport getLibrarySupport() {
        return new WLServerLibrarySupport(this.platformImpl.getDeploymentManager());
    }

    private FileObject getModulesFolder() {
        File middlewareHome = this.platformImpl.getMiddlewareHome();
        FileObject middlware = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)middlewareHome));
        if (middlware == null) {
            return null;
        }
        FileObject modules = middlware.getFileObject("modules");
        return modules;
    }

    private FileObject getJarFile(String startName) {
        FileObject[] children;
        FileObject modulesFolder = this.getModulesFolder();
        if (modulesFolder == null) {
            return null;
        }
        for (FileObject child : children = modulesFolder.getChildren()) {
            if (!child.getName().startsWith(startName) || !child.hasExt("jar")) continue;
            return child;
        }
        return null;
    }

    private boolean addJars(Project project, Collection<URL> jars) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : jars) {
            if (!FileUtil.isArchiveFile((URL)url)) continue;
            urls.add(FileUtil.getArchiveRoot((URL)url));
        }
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length < 1) {
            return false;
        }
        FileObject sourceRoot = sourceGroups[0].getRootFolder();
        try {
            ProjectClassPathModifier.addRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)"classpath/compile");
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void removeLibraries(Project project, Collection<URL> urls) {
        if (urls.size() > 0) {
            String[] classPathTypes;
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroups == null || sourceGroups.length < 1) {
                return;
            }
            FileObject sourceRoot = sourceGroups[0].getRootFolder();
            for (String type : classPathTypes = new String[]{"classpath/compile", "classpath/execute"}) {
                try {
                    ProjectClassPathModifier.removeRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)type);
                }
                catch (UnsupportedOperationException ex) {
                    Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, ex);
                }
                catch (IOException e) {
                    Logger.getLogger(JaxRsStackSupportImpl.class.getName()).log(Level.INFO, null, e);
                }
            }
        }
    }
}

