/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLSharedState;
import org.openide.util.NbBundle;

public class WLDeploymentFactory
implements DeploymentFactory {
    public static final String SERVER_ID = "WebLogic9";
    public static final String URI_PREFIX = "deployer:WebLogic:http://";
    public static final int DEFAULT_PORT = 7001;
    public static final Version VERSION_10 = Version.fromJsr277NotationWithFallback((String)"10");
    public static final Version VERSION_11 = Version.fromJsr277NotationWithFallback((String)"11");
    private static final Logger LOGGER = Logger.getLogger(WLDeploymentFactory.class.getName());
    private static WLDeploymentFactory instance;
    private static Map<InstanceProperties, WLDeploymentManager> managerCache;
    private static Map<InstanceProperties, WLSharedState> stateCache;
    private static Map<InstanceProperties, WLClassLoader> classLoaderCache;

    public static synchronized WLDeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WLDeploymentFactory();
        }
        return instance;
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        InstanceProperties props;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDeploymentManager, uri: {0} username: {1} password: {2}", new Object[]{uri, username, password});
        }
        if ((props = InstanceProperties.getInstanceProperties((String)uri)) == null) {
            throw new DeploymentManagerCreationException("Could not create deployment manager for " + uri);
        }
        Class<WLDeploymentFactory> clazz = WLDeploymentFactory.class;
        synchronized (WLDeploymentFactory.class) {
            WLDeploymentManager dm = managerCache.get(props);
            if (dm != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return dm;
            }
            WLSharedState shared = WLDeploymentFactory.getSharedState(props);
            String[] parts = uri.split(":");
            String host = parts[3].substring(2);
            String port = parts[4] != null ? parts[4].trim() : parts[4];
            dm = new WLDeploymentManager(uri, host, port, false, shared);
            managerCache.put(props, dm);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return dm;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "getDisconnectedDeploymentManager, uri: {0}", uri);
        }
        WLDeploymentManager dm = (WLDeploymentManager)this.getDeploymentManager(uri, null, null);
        return dm;
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_productVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WLDeploymentFactory.class, (String)"TXT_displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WLClassLoader getClassLoader(WLDeploymentManager manager) {
        Class<WLDeploymentFactory> clazz = WLDeploymentFactory.class;
        synchronized (WLDeploymentFactory.class) {
            InstanceProperties props = manager.getInstanceProperties();
            WLClassLoader classLoader = classLoaderCache.get(props);
            if (classLoader != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return classLoader;
            }
            for (Map.Entry<InstanceProperties, WLClassLoader> entry : classLoaderCache.entrySet()) {
                String serverRootCached = entry.getKey().getProperty("serverRoot");
                String serverRootFresh = props.getProperty("serverRoot");
                if (!(serverRootCached == null ? serverRootFresh == null : serverRootCached.equals(serverRootFresh))) continue;
                classLoader = entry.getValue();
                break;
            }
            if (classLoader == null) {
                classLoader = this.createClassLoader(manager);
            }
            classLoaderCache.put(props, classLoader);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return classLoader;
        }
    }

    private static synchronized WLSharedState getSharedState(InstanceProperties props) {
        WLSharedState mutableState = stateCache.get(props);
        if (mutableState == null) {
            mutableState = new WLSharedState(props);
            stateCache.put(props, mutableState);
        }
        mutableState.configure();
        return mutableState;
    }

    private WLClassLoader createClassLoader(WLDeploymentManager manager) {
        LOGGER.log(Level.FINE, "Creating classloader for {0}", manager.getUri());
        try {
            File[] classpath = WLPluginProperties.getClassPath(manager);
            URL[] urls = new URL[classpath.length];
            for (int i = 0; i < classpath.length; ++i) {
                urls[i] = classpath[i].toURI().toURL();
            }
            WLClassLoader classLoader = new WLClassLoader(urls, WLDeploymentManager.class.getClassLoader());
            LOGGER.log(Level.FINE, "Classloader for {0} created successfully", manager.getUri());
            return classLoader;
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, null, e);
            return new WLClassLoader(new URL[0], WLDeploymentManager.class.getClassLoader());
        }
    }

    static {
        managerCache = new WeakHashMap<InstanceProperties, WLDeploymentManager>();
        stateCache = new WeakHashMap<InstanceProperties, WLSharedState>();
        classLoaderCache = new WeakHashMap<InstanceProperties, WLClassLoader>();
    }

    private static class WLClassLoader
    extends URLClassLoader {
        public WLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = super.findClass(name);
            if (LOGGER.isLoggable(Level.FINEST)) {
                String filename = name.replace('.', '/');
                int index = filename.indexOf(36);
                if (index > 0) {
                    filename = filename.substring(0, index);
                }
                filename = filename + ".class";
                URL url = this.getResource(filename);
                LOGGER.log(Level.FINEST, "WebLogic classloader asked for {0}", name);
                if (url != null) {
                    LOGGER.log(Level.FINEST, "WebLogic classloader found {0} at {1}", new Object[]{name, url});
                }
            }
            return clazz;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.indexOf("jndi.properties") != -1 || name.indexOf("i18n_user.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }
    }
}

