/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmVisibilityQuery;
import org.netbeans.modules.cnd.gotodeclaration.type.CppTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.type.TracingTypeDescriptor;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.NbBundle;

public class CppTypeProvider
implements TypeProvider {
    private boolean isCancelled = false;
    private static final boolean PROCESS_LIBRARIES = true;
    private static final boolean TRACE = Boolean.getBoolean("cnd.type.provider.trace");

    public CppTypeProvider() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.ctor\n", new Object[0]);
        }
    }

    public String name() {
        return "C/C++";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CppTypeProvider.class, (String)"TYPE_PROVIDER_DISPLAY_NAME");
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result res) {
        this.isCancelled = false;
        Project project = context.getProject();
        String text = context.getText();
        SearchType type = context.getSearchType();
        if (TRACE) {
            System.err.printf("CppTypeProvider.getTypeNames(%s, %s, %s)\n", project, text, type);
        }
        CsmSelect.CsmFilter filter = CsmSelect.CLASSIFIER_KIND_FILTER;
        NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)text, (SearchType)type);
        if (project == null) {
            Collection csmProjects = CsmModelAccessor.getModel().projects();
            if (!csmProjects.isEmpty()) {
                HashSet<TypeDescriptor> result = new HashSet<TypeDescriptor>();
                for (CsmProject csmProject : csmProjects) {
                    this.processProject(csmProject, result, filter, matcher);
                }
                for (CsmProject csmProject : csmProjects) {
                    if (this.isCancelled) break;
                    HashSet<CsmProject> processedLibs = new HashSet<CsmProject>();
                    this.processProjectLibs(csmProject, result, filter, processedLibs, matcher);
                }
                res.addResult(new ArrayList<TypeDescriptor>(result));
            }
        } else {
            HashSet<TypeDescriptor> result = new HashSet<TypeDescriptor>();
            CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
            this.processProject(csmProject, result, filter, matcher);
            this.processProjectLibs(csmProject, result, filter, new HashSet<CsmProject>(), matcher);
            res.addResult(new ArrayList<TypeDescriptor>(result));
        }
    }

    public void cancel() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cancel\n", new Object[0]);
        }
        this.isCancelled = true;
    }

    public void cleanup() {
        if (TRACE) {
            System.err.printf("CppTypeProvider.cleanup\n", new Object[0]);
        }
    }

    private static TypeDescriptor createTypeDescriptor(CsmClassifier classifier) {
        CppTypeDescriptor descriptor = new CppTypeDescriptor(classifier);
        return TRACE ? new TracingTypeDescriptor(descriptor) : descriptor;
    }

    private void processProjectLibs(CsmProject project, Set<TypeDescriptor> result, CsmSelect.CsmFilter filter, Set<CsmProject> processedLibs, NameMatcher matcher) {
        for (CsmProject lib : project.getLibraries()) {
            if (this.isCancelled) {
                return;
            }
            if (!lib.isArtificial() || processedLibs.contains(lib)) continue;
            processedLibs.add(lib);
            this.processProject(lib, result, filter, matcher);
        }
    }

    private void processProject(CsmProject project, Set<TypeDescriptor> result, CsmSelect.CsmFilter filter, NameMatcher matcher) {
        if (TRACE) {
            System.err.printf("processProject %s\n", project.getName());
        }
        this.processNamespace(project.getGlobalNamespace(), result, filter, matcher);
    }

    private void processNamespace(CsmNamespace nsp, Set<TypeDescriptor> result, CsmSelect.CsmFilter filter, NameMatcher matcher) {
        if (TRACE) {
            System.err.printf("processNamespace %s\n", nsp.getQualifiedName());
        }
        Iterator iter = CsmSelect.getDeclarations((CsmNamespace)nsp, (CsmSelect.CsmFilter)filter);
        while (iter.hasNext()) {
            if (this.isCancelled) {
                return;
            }
            CsmDeclaration declaration = (CsmDeclaration)iter.next();
            this.processDeclaration(declaration, result, matcher);
        }
        for (CsmNamespace child : nsp.getNestedNamespaces()) {
            if (this.isCancelled) {
                return;
            }
            this.processNamespace(child, result, filter, matcher);
        }
    }

    private void processDeclaration(CsmDeclaration decl, Set<TypeDescriptor> result, NameMatcher matcher) {
        switch (decl.getKind()) {
            case CLASS: 
            case UNION: 
            case STRUCT: {
                if (this.isCancelled) break;
                CsmClass cls = (CsmClass)decl;
                if (CsmClassifierResolver.getDefault().isForwardClass((CsmObject)cls)) break;
                if (matcher.accept(((Object)decl.getName()).toString()) && CsmVisibilityQuery.isVisible((CsmObject)cls)) {
                    result.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)cls));
                }
                for (CsmMember member : cls.getMembers()) {
                    if (this.isCancelled || !matcher.accept(((Object)member.getName()).toString())) continue;
                    this.processDeclaration((CsmDeclaration)member, result, matcher);
                }
                break;
            }
            case ENUM: 
            case TYPEDEF: {
                if (this.isCancelled || !matcher.accept(((Object)decl.getName()).toString()) || !CsmVisibilityQuery.isVisible((CsmObject)decl)) break;
                result.add(CppTypeProvider.createTypeDescriptor((CsmClassifier)decl));
            }
        }
    }
}

