/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpdoc.PhpDocumentorProvider;
import org.netbeans.modules.php.phpdoc.ui.PhpDocPreferences;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PhpDocPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 5643218762231L;
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private JButton targetButton;
    private JLabel targetLabel;
    private JTextField targetTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;

    PhpDocPanel(ProjectCustomizer.Category category, PhpModule phpModule) {
        assert (category != null);
        assert (phpModule != null);
        this.category = category;
        this.phpModule = phpModule;
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpDocPanel.this.storeData();
            }
        });
        this.initComponents();
        this.targetTextField.setText(PhpDocPreferences.getPhpDocTarget(phpModule, false));
        this.titleTextField.setText(PhpDocPreferences.getPhpDocTitle(phpModule));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.targetTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.titleTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.validateData();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PhpDocPanel.class);
    }

    private String getPhpDocTarget() {
        return this.targetTextField.getText().trim();
    }

    private String getPhpDocTitle() {
        return this.titleTextField.getText().trim();
    }

    void validateData() {
        String error;
        String phpDocTarget = this.getPhpDocTarget();
        if (StringUtils.hasText((String)phpDocTarget) && (error = FileUtils.validateDirectory((String)this.getPhpDocTarget())) != null) {
            this.category.setErrorMessage(error);
            this.category.setValid(false);
            return;
        }
        if (!StringUtils.hasText((String)this.getPhpDocTitle())) {
            this.category.setErrorMessage(NbBundle.getMessage(PhpDocPanel.class, (String)"MSG_InvalidTitle"));
            this.category.setValid(false);
            return;
        }
        String warning = null;
        if (!StringUtils.hasText((String)phpDocTarget)) {
            warning = NbBundle.getMessage(PhpDocPanel.class, (String)"MSG_NbWillAskForDir");
        }
        this.category.setErrorMessage(warning);
        this.category.setValid(true);
    }

    void storeData() {
        PhpDocPreferences.setPhpDocTarget(this.phpModule, this.getPhpDocTarget());
        PhpDocPreferences.setPhpDocTitle(this.phpModule, this.getPhpDocTitle());
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetTextField = new JTextField();
        this.targetButton = new JButton();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.targetLabel.setLabelFor(this.targetTextField);
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.targetButton, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.targetButton.text"));
        this.targetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocPanel.this.targetButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setLabelFor(this.titleTextField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(PhpDocPanel.class, (String)"PhpDocPanel.titleLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetLabel).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.targetTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetButton)).addComponent(this.titleTextField, -1, 112, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetLabel).addComponent(this.targetTextField, -2, -1, -2).addComponent(this.targetButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void targetButtonActionPerformed(ActionEvent evt) {
        File phpDocTarget = new FileChooserBuilder(PhpDocumentorProvider.class.getName() + ".phpdoc.dir" + this.phpModule.getName()).setTitle(NbBundle.getMessage(PhpDocPanel.class, (String)"LBL_SelectDocFolder")).setDirectoriesOnly(true).setFileHiding(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.phpModule.getSourceDirectory())).showOpenDialog();
        if (phpDocTarget != null) {
            phpDocTarget = FileUtil.normalizeFile((File)phpDocTarget);
            this.targetTextField.setText(phpDocTarget.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            PhpDocPanel.this.validateData();
        }
    }
}

