/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.NewTestCUnitPanelGUI;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.simpleunit.utils.MakefileUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

final class NewTestCppUnitPanelGUI
extends CndPanelGUI
implements ActionListener {
    private final String baseTestName;
    private String sourceExt;
    private String headerExt;
    private final MIMEExtensions sourceExtensions = MIMEExtensions.get((String)"text/x-c++");
    private final MIMEExtensions headerExtensions = MIMEExtensions.get((String)"text/x-h");
    protected static final String NEW_TEST_PREFIX = NewTestCppUnitPanelGUI.getMessage("LBL_NewTest_NewTestPrefix");
    protected static final String DEFAULT_TESTS_FOLDER = "tests";
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JLabel classNameLbl;
    private JTextField classNameTextField;
    private JTextArea createdFilesArea;
    private JLabel createdFilesLabel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox headerExtComboBox;
    private JLabel headerExtLabel;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextArea modifiedFilesArea;
    private JLabel modifiedFilesLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel runnerLabel;
    private JTextField runnerTextField;
    private JComboBox sourceExtComboBox;
    private JLabel sourceExtLabel;
    private JSeparator targetSeparator;
    private JLabel testLabel;
    private JTextField testTextField;

    NewTestCppUnitPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, String baseTestName) {
        super(project, folders);
        this.baseTestName = baseTestName;
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.classNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)this));
        this.runnerTextField.getDocument().addDocumentListener((DocumentListener)((Object)this));
        this.folderTextField.getDocument().addDocumentListener((DocumentListener)((Object)this));
        this.setName(NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        String baseName;
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = NewTestCppUnitPanelGUI.getPreselectedGroup((SourceGroup[])this.folders, (FileObject)preselectedFolder);
        this.locationComboBox.setSelectedItem(preselectedGroup);
        String relPreselectedFolder = NewTestCppUnitPanelGUI.getRelativeNativeName((FileObject)preselectedGroup.getRootFolder(), (FileObject)preselectedFolder);
        this.folderTextField.setText(relPreselectedFolder);
        if (this.folderTextField.getText().isEmpty()) {
            this.folderTextField.setText(DEFAULT_TESTS_FOLDER);
        }
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.sourceExt = this.sourceExtensions.getDefaultExtension();
        this.sourceExtComboBox.setSelectedItem(this.sourceExt);
        this.headerExt = this.headerExtensions.getDefaultExtension();
        this.headerExtComboBox.setSelectedItem(this.headerExt);
        if (template != null) {
            if (documentName == null) {
                FileObject currentFolder;
                documentName = baseName = this.baseTestName == null ? NewTestCppUnitPanelGUI.getMessage("NewClassSuggestedName") : NewTestCppUnitPanelGUI.getMessage("TestClassSuggestedName", this.baseTestName).replaceAll(" ", "_").toLowerCase();
                FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder().getFileObject(DEFAULT_TESTS_FOLDER);
                if (currentFolder != null) {
                    documentName = documentName + NewTestCppUnitPanelGUI.generateUniqueSuffix((FileObject)currentFolder, (String)NewTestCppUnitPanelGUI.getFileName(documentName), (String[])new String[]{this.sourceExt, this.headerExt});
                }
            }
            this.classNameTextField.setText(documentName);
        }
        if (template != null) {
            FileObject currentFolder;
            String runnerName = baseName = this.baseTestName == null ? NewTestCppUnitPanelGUI.getMessage("NewRunnerSuggestedName") : NewTestCppUnitPanelGUI.getMessage("TestRunnerSuggestedName", this.baseTestName).replaceAll(" ", "_").toLowerCase();
            FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder().getFileObject(DEFAULT_TESTS_FOLDER);
            if (currentFolder != null) {
                runnerName = runnerName + NewTestCppUnitPanelGUI.generateUniqueSuffix((FileObject)currentFolder, (String)NewTestCppUnitPanelGUI.getFileName(runnerName), (String[])new String[]{this.sourceExt, this.headerExt});
            }
            this.runnerTextField.setText(runnerName);
        }
        if (template != null) {
            String baseName2;
            String testName = baseName2 = this.baseTestName == null ? NEW_TEST_PREFIX + displayName : NewTestCppUnitPanelGUI.getMessage("TestSuggestedName", this.baseTestName);
            Folder testsRoot = NewTestCppUnitPanelGUI.getTestsRootFolder(this.project);
            if (testsRoot != null) {
                int index = 0;
                while (true) {
                    boolean exist = false;
                    for (Folder folder : testsRoot.getFolders()) {
                        if (!folder.getDisplayName().equals(testName)) continue;
                        exist = true;
                    }
                    if (!exist) break;
                    testName = baseName2 + " " + ++index;
                }
            }
            this.testTextField.setText(testName);
            this.testTextField.selectAll();
        }
        if (MakefileUtils.hasTestTargets((Project)this.project)) {
            this.modifiedFilesLabel.setVisible(false);
            this.modifiedFilesArea.setVisible(false);
        } else {
            this.modifiedFilesLabel.setVisible(true);
            this.modifiedFilesArea.setVisible(true);
            this.modifiedFilesArea.setText(FileUtil.getFileDisplayName((FileObject)MakefileUtils.getMakefile((Project)this.project)));
        }
    }

    void setControlsEnabled(boolean enable) {
        this.testTextField.setEnabled(enable);
        this.projectTextField.setEnabled(enable);
        this.locationComboBox.setEnabled(enable);
        this.folderTextField.setEnabled(enable);
        this.browseButton.setEnabled(enable);
        this.classNameTextField.setEnabled(enable);
        this.sourceExtComboBox.setEnabled(enable);
        this.headerExtComboBox.setEnabled(enable);
        this.runnerTextField.setEnabled(enable);
        this.createdFilesArea.setEnabled(enable);
        this.modifiedFilesArea.setEnabled(enable);
    }

    private static Folder getTestsRootFolder(Project project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        return testRootFolder;
    }

    public SourceGroup getTargetGroup() {
        Object selectedItem = this.locationComboBox.getSelectedItem();
        if (selectedItem == null && (selectedItem = this.locationComboBox.getItemAt(this.locationComboBox.getSelectedIndex())) == null) {
            selectedItem = this.locationComboBox.getItemAt(0);
        }
        return (SourceGroup)selectedItem;
    }

    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String documentName = this.getSourceFileName();
        if (documentName.length() == 0 || documentName.charAt(documentName.length() - 1) == '.') {
            return null;
        }
        return documentName;
    }

    private String createdFileName(JTextField field) {
        FileObject root = this.getTargetGroup().getRootFolder();
        String folderName = field.getText().trim();
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/");
        return createdFileName.replace('/', File.separatorChar);
    }

    protected void updateCreatedFile() {
        String sourceFileName = this.createdFileName(this.folderTextField) + this.getSourceFileName();
        String headerFileName = this.createdFileName(this.folderTextField) + this.getHeaderFileName();
        String runnerFileName = this.createdFileName(this.folderTextField) + this.getRunnerFileName();
        String allTogether = sourceFileName + '\n' + headerFileName + '\n' + runnerFileName;
        if (!allTogether.equals(this.createdFilesArea.getText())) {
            this.createdFilesArea.setText(allTogether);
            this.changeSupport.fireChange();
        }
    }

    public String getTestName() {
        String documentName = this.testTextField.getText().trim();
        if (documentName.length() == 0) {
            return null;
        }
        return documentName;
    }

    public String getSourceFileName() {
        return NewTestCppUnitPanelGUI.getFileName(this.getClassName()) + "." + this.sourceExt;
    }

    private DefaultComboBoxModel getSourceExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.sourceExtensions.getValues()));
    }

    private DefaultComboBoxModel getExtensionsCBModel() {
        return new DefaultComboBoxModel(new Vector(this.sourceExtensions.getValues()));
    }

    public String getHeaderFileName() {
        return NewTestCppUnitPanelGUI.getFileName(this.getClassName()) + "." + this.headerExt;
    }

    public String getHeaderFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getHeaderName() {
        String documentName = this.getHeaderFileName();
        if (documentName.length() == 0 || documentName.charAt(documentName.length() - 1) == '.') {
            return null;
        }
        return documentName;
    }

    public String getRunnerFileName() {
        return this.runnerTextField.getText().trim() + "." + this.sourceExt;
    }

    private DefaultComboBoxModel getHeaderExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.headerExtensions.getValues()));
    }

    private static String getFileName(String className) {
        return className;
    }

    public String getClassName() {
        return this.classNameTextField.getText().trim();
    }

    public String getHeaderExt() {
        return this.headerExt;
    }

    private void initComponents() {
        this.testLabel = new JLabel();
        this.testTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.classNameLbl = new JLabel();
        this.classNameTextField = new JTextField();
        this.sourceExtLabel = new JLabel();
        this.sourceExtComboBox = new JComboBox();
        this.headerExtLabel = new JLabel();
        this.headerExtComboBox = new JComboBox();
        this.runnerLabel = new JLabel();
        this.runnerTextField = new JTextField();
        this.createdFilesLabel = new JLabel();
        this.createdFilesArea = new JTextArea();
        this.modifiedFilesLabel = new JLabel();
        this.modifiedFilesArea = new JTextArea();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.testLabel.setLabelFor(this.testTextField);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Test_Name_Label"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        this.projectTextField.setEditable(false);
        this.projectTextField.setFocusable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        this.folderLabel.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        this.classNameLbl.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.classNameLbl, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_TestClassName_Label"));
        this.sourceExtLabel.setLabelFor(this.sourceExtComboBox);
        Mnemonics.setLocalizedText((JLabel)this.sourceExtLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Extension_Label"));
        this.sourceExtComboBox.setModel(this.getSourceExtensionsModel());
        this.sourceExtComboBox.setMinimumSize(new Dimension(100, 25));
        this.sourceExtComboBox.setPreferredSize(new Dimension(100, 25));
        this.sourceExtComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTestCppUnitPanelGUI.this.sourceExtComboBoxActionPerformed(evt);
            }
        });
        this.headerExtLabel.setLabelFor(this.headerExtComboBox);
        Mnemonics.setLocalizedText((JLabel)this.headerExtLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_HeaderChooser_Extension_Label"));
        this.headerExtComboBox.setModel(this.getHeaderExtensionsModel());
        this.headerExtComboBox.setMinimumSize(new Dimension(100, 25));
        this.headerExtComboBox.setPreferredSize(new Dimension(100, 25));
        this.headerExtComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTestCppUnitPanelGUI.this.headerExtComboBoxActionPerformed(evt);
            }
        });
        this.runnerLabel.setLabelFor(this.runnerTextField);
        Mnemonics.setLocalizedText((JLabel)this.runnerLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_Test_Runner_File_Name_Label"));
        this.createdFilesLabel.setLabelFor(this.createdFilesArea);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_CreatedFiles_Label"));
        this.createdFilesArea.setColumns(20);
        this.createdFilesArea.setEditable(false);
        this.createdFilesArea.setRows(3);
        this.createdFilesArea.setFocusable(false);
        this.createdFilesArea.setOpaque(false);
        this.modifiedFilesLabel.setLabelFor(this.modifiedFilesArea);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFilesLabel, (String)NbBundle.getMessage(NewTestCppUnitPanelGUI.class, (String)"LBL_TargetChooser_ModifiedFiles_Label"));
        this.modifiedFilesArea.setColumns(20);
        this.modifiedFilesArea.setEditable(false);
        this.modifiedFilesArea.setRows(1);
        this.modifiedFilesArea.setFocusable(false);
        this.modifiedFilesArea.setOpaque(false);
        this.bottomPanelContainer.setFocusable(false);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.targetSeparator, GroupLayout.Alignment.TRAILING, -1, 502, Short.MAX_VALUE).addComponent(this.bottomPanelContainer, -1, 502, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testLabel).addComponent(this.projectLabel).addComponent(this.locationLabel).addComponent(this.folderLabel).addComponent(this.classNameLbl).addComponent(this.sourceExtLabel).addComponent(this.runnerLabel).addComponent(this.createdFilesLabel).addComponent(this.modifiedFilesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modifiedFilesArea, 0, 345, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.sourceExtComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.headerExtLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerExtComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.folderTextField, -1, 269, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addGap(1, 1, 1)).addComponent(this.projectTextField, -1, 345, Short.MAX_VALUE).addComponent(this.locationComboBox, 0, 345, Short.MAX_VALUE).addComponent(this.classNameTextField, -1, 345, Short.MAX_VALUE).addComponent(this.testTextField, -1, 345, Short.MAX_VALUE).addComponent(this.runnerTextField, -1, 345, Short.MAX_VALUE).addComponent(this.createdFilesArea, 0, 345, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testLabel).addComponent(this.testTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.folderTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classNameTextField, -2, -1, -2).addComponent(this.classNameLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceExtLabel).addComponent(this.sourceExtComboBox, -2, -1, -2).addComponent(this.headerExtLabel).addComponent(this.headerExtComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runnerLabel).addComponent(this.runnerTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFilesLabel).addComponent(this.createdFilesArea, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modifiedFilesArea, -2, -1, -2).addComponent(this.modifiedFilesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanelContainer, -1, 71, Short.MAX_VALUE)));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestCppUnitPanelGUI.class).getString("AD_projectTextField"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestCppUnitPanelGUI.class).getString("AD_locationComboBox"));
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestCppUnitPanelGUI.class).getString("AD_folderTextField"));
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestCppUnitPanelGUI.class).getString("AD_browseButton"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewTestCppUnitPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void sourceExtComboBoxActionPerformed(ActionEvent evt) {
        this.sourceExt = (String)this.sourceExtComboBox.getSelectedItem();
        this.updateCreatedFile();
    }

    private void headerExtComboBoxActionPerformed(ActionEvent evt) {
        this.headerExt = (String)this.headerExtComboBox.getSelectedItem();
        this.updateCreatedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            SourceGroup group = this.getTargetGroup();
            FileObject fo = BrowseFolders.showDialog((SourceGroup[])new SourceGroup[]{group}, (Project)this.project, (String)this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFile();
        }
    }

    protected static String getMessage(String name) {
        return NbBundle.getMessage(NewTestCUnitPanelGUI.class, (String)name);
    }

    protected static String getMessage(String name, String param) {
        return NbBundle.getMessage(NewTestCUnitPanelGUI.class, (String)name, (Object)param);
    }
}

