/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.spi;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.ImageUtilities;

public abstract class IconsProvider {
    public abstract Image getImage(String var1);

    public abstract String getResource(String var1);

    public static abstract class Basic
    extends IconsProvider {
        private Map<String, String> images;

        @Override
        public final Image getImage(String key) {
            String resource = this.getResource(key);
            if (resource == null) {
                return this.getDynamicImage(key);
            }
            return ImageUtilities.loadImage((String)resource, (boolean)true);
        }

        @Override
        public final String getResource(String key) {
            return this.getImageCache().get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> getImageCache() {
            Basic basic = this;
            synchronized (basic) {
                if (this.images == null) {
                    final String packagePrefix = this.getClass().getPackage().getName().replace('.', '/') + "/";
                    this.images = new HashMap<String, String>(){

                        @Override
                        public String put(String key, String value) {
                            return super.put(key, packagePrefix + value);
                        }
                    };
                    this.initStaticImages(this.images);
                }
            }
            return this.images;
        }

        protected void initStaticImages(Map<String, String> cache) {
        }

        protected Image getDynamicImage(String key) {
            return null;
        }
    }
}

