/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.project.ui.FileChooser;
import org.netbeans.modules.j2ee.common.project.ui.ProjectImportLocationWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ProjectImportLocationPanel
extends JPanel
implements HelpCtx.Provider {
    private final ProjectImportLocationWizardPanel wizard;
    private WizardDescriptor wizardDescriptor;
    private String currentLibrariesLocation;
    private String nameFormatter;
    private String lastModuleLocation = null;
    private Object j2eeModuleType;
    private boolean allowAlternativeBuildXml;
    private JButton browseLibraries;
    private JButton jButtonPrjLocation;
    private JButton jButtonSrcLocation;
    private JLabel jLabelPrjLocation;
    private JLabel jLabelPrjLocationDesc;
    private JLabel jLabelPrjName;
    private JLabel jLabelSrcLocation;
    private JLabel jLabelSrcLocationDesc;
    private JSeparator jSeparator1;
    private JLabel librariesLabel;
    private JTextField librariesLocation;
    public JTextField moduleLocationTextField;
    public JTextField projectLocationTextField;
    public JTextField projectNameTextField;
    private JCheckBox setAsMainCheckBox;
    private JCheckBox sharableProject;

    public ProjectImportLocationPanel(Object j2eeModuleType, String name, String title, ProjectImportLocationWizardPanel wizard, String nameFormatter, String importLabel, boolean allowAlternativeBuildXml) {
        this.wizard = wizard;
        this.j2eeModuleType = j2eeModuleType;
        this.nameFormatter = nameFormatter;
        this.allowAlternativeBuildXml = allowAlternativeBuildXml;
        this.initComponents();
        this.setAsMainCheckBox.setSelected(UserProjectSettings.getDefault().getSetAsMainProject(j2eeModuleType));
        this.jLabelSrcLocationDesc.setText(importLabel);
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.librariesLocation.setText(this.currentLibrariesLocation);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACS_NWP1_NamePanel_A11YDesc"));
        this.setName(name);
        this.putClientProperty("NewProjectWizard_Title", title);
        this.moduleLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.locationDataChanged(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.locationDataChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.locationDataChanged(e);
            }
        });
        this.projectLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.fireChanges();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.fireChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectImportLocationPanel.this.fireChanges();
            }
        });
        this.sharableProjectActionPerformed(null);
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        String projectName = (String)settings.getProperty("name");
        if (projectName == null && settings.getProperty("projdir") != null) {
            int baseCount = 1;
            while ((projectName = this.validFreeProjectName(projectLocation, this.nameFormatter, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectNameTextField.setText(projectName == null ? "" : projectName);
        this.projectNameTextField.selectAll();
    }

    void store(WizardDescriptor settings) {
        File srcRoot = null;
        String srcPath = this.moduleLocationTextField.getText();
        if (srcPath.length() > 0) {
            srcRoot = FileUtil.normalizeFile((File)new File(srcPath));
        }
        if (srcRoot != null) {
            UserProjectSettings.getDefault().setLastUsedImportLocation(srcRoot);
        }
        settings.putProperty("sourceRoot", (Object)srcRoot);
        settings.putProperty("name", (Object)this.projectNameTextField.getText().trim());
        String projectLocation = this.projectLocationTextField.getText().trim();
        if (projectLocation.length() >= 0) {
            settings.putProperty("projdir", (Object)new File(projectLocation));
        }
        settings.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        settings.putProperty("sharedLibraries", this.sharableProject.isSelected() ? this.librariesLocation.getText() : null);
        UserProjectSettings.getDefault().setSetAsMainProject(this.setAsMainCheckBox.isSelected(), this.j2eeModuleType);
    }

    boolean valid(WizardDescriptor settings) {
        String sourceLocationPath = this.moduleLocationTextField.getText().trim();
        if (sourceLocationPath.length() == 0) {
            this.setErrorMessage("MSG_ProvideExistingSourcesLocation");
            return false;
        }
        File f = new File(sourceLocationPath);
        if (!f.isDirectory() || !f.canRead()) {
            String format = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_IllegalSources");
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(format, sourceLocationPath));
            return false;
        }
        String projectLocationPath = this.projectLocationTextField.getText().trim();
        f = new File(projectLocationPath);
        String projectName = this.projectNameTextField.getText().trim();
        f = new File(f, projectName);
        if ((f = ProjectLocationPanel.getCanonicalFile(f)) == null || !projectName.equals(f.getName())) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_ProvideProjectName"));
            return false;
        }
        if (projectLocationPath.length() == 0) {
            this.setErrorMessage("MSG_ProvideProjectFolder");
            return false;
        }
        File projectLocation = new File(projectLocationPath);
        if (projectLocation.exists() && !projectLocation.canWrite()) {
            this.setErrorMessage("MSG_ProjectLocationRO");
            return false;
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocationPath));
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            assert (destFO != null) : "No FileObject for " + destFolder;
            boolean clear = false;
            try {
                clear = ProjectManager.getDefault().findProject(destFO) == null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!clear) {
                this.setErrorMessage("MSG_ProjectFolderHasDeletedProject");
                return false;
            }
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_BuildFolder");
                } else if ("build.xml".equals(childName) && !this.allowAlternativeBuildXml) {
                    file = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_BuildXML");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_DistFolder");
                } else if ("manifest.mf".equals(childName)) {
                    file = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"TXT_Manifest");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_ProjectFolderInvalid");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(format, file));
                return false;
            }
        }
        if (this.j2eeModuleType == J2eeModule.CLIENT && FileSearchUtility.guessJavaRoots(FileUtil.toFileObject((File)destFolder)) == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"MSG_NoAppClientModule"));
            return false;
        }
        if (this.sharableProject.isSelected()) {
            String location = this.librariesLocation.getText();
            if (new File(location).isAbsolute()) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharability.absolutePathWarning.text")));
            } else {
                File libLoc = PropertyUtils.resolveFile((File)projectLocation, (String)location);
                if (!CollocationQuery.areCollocated((File)projectLocation, (File)libLoc)) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharability.relativePathWarning.text")));
                }
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setErrorMessage(String messageId) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", messageId == null ? null : NbBundle.getMessage(ProjectImportLocationPanel.class, (String)messageId));
    }

    private void initComponents() {
        this.jLabelSrcLocationDesc = new JLabel();
        this.jLabelSrcLocation = new JLabel();
        this.moduleLocationTextField = new JTextField();
        this.jButtonSrcLocation = new JButton();
        this.jLabelPrjLocationDesc = new JLabel();
        this.jLabelPrjName = new JLabel();
        this.projectNameTextField = new JTextField();
        this.jLabelPrjLocation = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.jButtonPrjLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.sharableProject = new JCheckBox();
        this.librariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.browseLibraries = new JButton();
        this.setAsMainCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabelSrcLocationDesc, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationSrcDesc"));
        this.jLabelSrcLocation.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_ImportLocation_LabelMnemonic").charAt(0));
        this.jLabelSrcLocation.setHorizontalAlignment(2);
        this.jLabelSrcLocation.setLabelFor(this.moduleLocationTextField);
        this.jLabelSrcLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationSrc_Label"));
        this.jButtonSrcLocation.setMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_BrowseLocation_MNE").charAt(0));
        this.jButtonSrcLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonSrcLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectImportLocationPanel.this.jButtonSrcLocationActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjLocationDesc, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_LocationPrjDesc"));
        this.jLabelPrjName.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.jLabelPrjName.setHorizontalAlignment(2);
        this.jLabelPrjName.setLabelFor(this.projectNameTextField);
        this.jLabelPrjName.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.jLabelPrjLocation.setDisplayedMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_LabelMnemonic").charAt(0));
        this.jLabelPrjLocation.setHorizontalAlignment(2);
        this.jLabelPrjLocation.setLabelFor(this.projectLocationTextField);
        this.jLabelPrjLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_Label"));
        this.jButtonPrjLocation.setMnemonic(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_BrowseProjectFolder_MNE").charAt(0));
        this.jButtonPrjLocation.setText(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseProjectLocation_Button"));
        this.jButtonPrjLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectImportLocationPanel.this.jButtonPrjLocationActionPerformed(evt);
            }
        });
        this.sharableProject.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.sharableProject, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ProjectLocationPanel.sharableProject.text"));
        this.sharableProject.setMargin(new Insets(2, 0, 2, 2));
        this.sharableProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectImportLocationPanel.this.sharableProjectActionPerformed(evt);
            }
        });
        this.librariesLabel.setLabelFor(this.librariesLocation);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ProjectLocationPanel.librariesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraries, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"PanelSharabilityVisual.browseLibraries.text"));
        this.browseLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectImportLocationPanel.this.browseLibrariesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(2, 0, 2, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSrcLocation).addComponent(this.jLabelPrjLocation).addComponent(this.jLabelPrjName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING, -1, 415, Short.MAX_VALUE).addComponent(this.moduleLocationTextField, GroupLayout.Alignment.TRAILING, -1, 415, Short.MAX_VALUE).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING, -1, 415, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSrcLocation, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonPrjLocation, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.jLabelPrjLocationDesc, -2, -1, -2).addContainerGap()).addComponent(this.jSeparator1, -1, 639, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.sharableProject).addContainerGap(304, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.librariesLocation, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseLibraries)).addGroup(layout.createSequentialGroup().addComponent(this.setAsMainCheckBox).addContainerGap()).addComponent(this.jLabelSrcLocationDesc, -1, 639, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelSrcLocationDesc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSrcLocation).addComponent(this.jButtonSrcLocation).addComponent(this.moduleLocationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPrjLocationDesc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPrjName).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPrjLocation).addComponent(this.jButtonPrjLocation).addComponent(this.projectLocationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sharableProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.browseLibraries).addComponent(this.librariesLocation, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.setAsMainCheckBox).addGap(52, 52, 52)));
        this.jLabelSrcLocationDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jLabelSrcLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.moduleLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jButtonSrcLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jLabelPrjLocationDesc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jLabelPrjName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jLabelPrjLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jButtonPrjLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jSeparator1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.jSeparator1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.sharableProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.librariesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.librariesLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.browseLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"ACSD_ProjectImportLocationPanel_NA"));
    }

    private void jButtonPrjLocationActionPerformed(ActionEvent evt) {
        FileChooser chooser = FileChooser.createDirectoryChooser("ImportLocationVisual.Project", this.projectLocationTextField.getText());
        chooser.setDialogTitle(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseProjectFolder"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
    }

    private void jButtonSrcLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbBundle.getMessage(ProjectImportLocationPanel.class, (String)"LBL_IW_BrowseExistingSource"));
        if (this.moduleLocationTextField.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            File existingSourcesFile;
            File currentDirectory = null;
            FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
            if (existingSourcesFO != null && (existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO)) != null && existingSourcesFile.isDirectory()) {
                currentDirectory = existingSourcesFile;
            }
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            } else {
                File lastUsedImportLoc = UserProjectSettings.getDefault().getLastUsedImportLocation();
                if (lastUsedImportLoc != null) {
                    chooser.setCurrentDirectory(lastUsedImportLoc.getParentFile());
                } else {
                    chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
                }
            }
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.moduleLocationTextField.setText(projectDir.getAbsolutePath());
        }
    }

    private void sharableProjectActionPerformed(ActionEvent evt) {
        this.librariesLocation.setEnabled(this.sharableProject.isSelected());
        this.browseLibraries.setEnabled(this.sharableProject.isSelected());
        this.librariesLabel.setEnabled(this.sharableProject.isSelected());
        if (this.sharableProject.isSelected()) {
            this.librariesLocation.setText(this.currentLibrariesLocation);
        } else {
            this.librariesLocation.setText("");
        }
        this.wizard.fireChangeEvent();
    }

    private void browseLibrariesActionPerformed(ActionEvent evt) {
        File f = new File(this.projectLocationTextField.getText());
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.librariesLocation.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.sharableProject.isSelected()) {
                this.librariesLocation.setText(this.currentLibrariesLocation);
            }
        }
    }

    private String computeProjectName() {
        if (this.getProjectLocation() == null) {
            return "";
        }
        FileObject fo = FileUtil.toFileObject((File)this.getProjectLocation());
        if (fo != null) {
            return fo.getName();
        }
        return "";
    }

    private String computeProjectFolder() {
        File f = this.getProjectLocation();
        if (f == null) {
            return "";
        }
        return f.getAbsolutePath();
    }

    private void locationDataChanged(DocumentEvent de) {
        if (this.lastModuleLocation == null || !this.lastModuleLocation.equals(this.moduleLocationTextField.getText())) {
            this.lastModuleLocation = this.moduleLocationTextField.getText();
            this.projectNameTextField.setText(this.computeProjectName());
            this.projectLocationTextField.setText(this.computeProjectFolder());
        }
        this.fireChanges();
    }

    private void fireChanges() {
        this.wizard.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectImportLocationPanel.class, this.j2eeModuleType));
    }

    static String generateHelpID(Class clazz, J2eeModule.Type moduleType) {
        if (J2eeModule.Type.CAR.equals(moduleType)) {
            return clazz.getName() + "_APPCLIENT";
        }
        if (J2eeModule.Type.EJB.equals(moduleType)) {
            return clazz.getName() + "_EJB";
        }
        if (J2eeModule.Type.EAR.equals(moduleType)) {
            return clazz.getName() + "_EAR";
        }
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            return clazz.getName() + "_WAR";
        }
        throw new AssertionError((Object)("Unknown module type: " + moduleType));
    }

    @Deprecated
    static String generateHelpID(Class clazz, Object moduleType) {
        return ProjectImportLocationPanel.generateHelpID(clazz, J2eeModule.Type.fromJsrType((Object)moduleType));
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    public File getProjectLocation() {
        if (this.moduleLocationTextField.getText().trim().length() == 0) {
            return null;
        }
        return this.getAsFile(this.moduleLocationTextField.getText());
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }
}

