/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.repository.AbstractKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

abstract class ProjectNameBasedKey
extends AbstractKey {
    private final short unitIndex;

    protected ProjectNameBasedKey(CharSequence project) {
        assert (project != null);
        this.unitIndex = (short)KeyUtilities.getUnitId(project);
    }

    protected ProjectNameBasedKey(KeyDataPresentation presentation) {
        this.unitIndex = presentation.getUnitPresentation();
    }

    @Override
    public String toString() {
        return ((Object)this.getProjectName()).toString();
    }

    @Override
    public int hashCode() {
        return this.unitIndex;
    }

    @Override
    public final int getUnitId() {
        return this.unitIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ProjectNameBasedKey other = (ProjectNameBasedKey)obj;
        return this.unitIndex == other.unitIndex;
    }

    protected CharSequence getProjectName() {
        return this.getUnit();
    }

    public void write(RepositoryDataOutput aStream) throws IOException {
        aStream.writeShort((int)this.unitIndex);
    }

    protected ProjectNameBasedKey(RepositoryDataInput aStream) throws IOException {
        this.unitIndex = aStream.readShort();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public CharSequence getAt(int level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getUnit() {
        return KeyUtilities.getUnitName(this.unitIndex);
    }

    public final short getUnitPresentation() {
        return this.unitIndex;
    }
}

