/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmObjectFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

class NamespaceKey
extends ProjectNameBasedKey {
    private final CharSequence fqn;
    private final int hashCode;

    NamespaceKey(CsmNamespace ns) {
        super(NamespaceKey.getProjectName(ns));
        this.fqn = ns.getQualifiedName();
        this.hashCode = this._hashCode();
    }

    NamespaceKey(KeyDataPresentation presentation) {
        super(presentation);
        this.fqn = presentation.getNamePresentation();
        this.hashCode = this._hashCode();
    }

    private static CharSequence getProjectName(CsmNamespace ns) {
        ProjectBase prj = (ProjectBase)ns.getProject();
        assert (prj != null) : "no project in namespace";
        return prj == null ? ProjectFileNameBasedKey.NO_PROJECT : prj.getUniqueName();
    }

    @Override
    public String toString() {
        return "NSKey " + this.fqn + " of project " + this.getProjectName();
    }

    public PersistentFactory getPersistentFactory() {
        return CsmObjectFactory.instance();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int _hashCode() {
        int key = super.hashCode();
        key = 74 + key;
        key = 17 * key + this.fqn.hashCode();
        return key;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NamespaceKey other = (NamespaceKey)obj;
        return this.fqn.equals(other.fqn);
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        assert (this.fqn != null);
        PersistentUtils.writeUTF(this.fqn, aStream);
    }

    NamespaceKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.fqn = PersistentUtils.readUTF(aStream, QualifiedNameCache.getManager());
        assert (this.fqn != null);
        this.hashCode = this._hashCode();
    }

    @Override
    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    @Override
    public CharSequence getAt(int level) {
        assert (super.getDepth() == 0 && level < this.getDepth());
        return this.fqn;
    }

    @Override
    public int getSecondaryDepth() {
        return 1;
    }

    @Override
    public int getSecondaryAt(int level) {
        assert (level == 0);
        return 2;
    }

    @Override
    public Key.Behavior getBehavior() {
        return Key.Behavior.LargeAndMutable;
    }

    @Override
    public boolean hasCache() {
        return true;
    }

    @Override
    public short getKindPresentation() {
        return 2;
    }

    @Override
    public final CharSequence getNamePresentation() {
        return this.fqn;
    }
}

