/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTError;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SimpleOffsetableImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTProjectFileBasedWalker;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;

public class APTParseFileWalker
extends APTProjectFileBasedWalker {
    private boolean createMacroAndIncludes = false;
    private final boolean triggerParsingActivity;
    private final EvalCallback evalCallback;

    public APTParseFileWalker(ProjectBase base, APTFile apt, FileImpl file, APTPreprocHandler preprocHandler, boolean triggerParsingActivity, EvalCallback evalCallback, APTFileCacheEntry cacheEntry) {
        super(base, apt, file, preprocHandler, cacheEntry);
        this.evalCallback = evalCallback;
        this.triggerParsingActivity = triggerParsingActivity;
    }

    public void addMacroAndIncludes(boolean create) {
        this.createMacroAndIncludes = create;
    }

    protected boolean needMacroAndIncludes() {
        return this.createMacroAndIncludes;
    }

    public final boolean isTriggerParsingActivity() {
        return this.triggerParsingActivity;
    }

    public TokenStream getFilteredTokenStream(APTLanguageFilter lang) {
        return lang.getFilteredStream(this.getTokenStream());
    }

    public TokenStream getTokenStream() {
        return this.getTokenStream(true);
    }

    public TokenStream getTokenStream(boolean filtered) {
        this.setMode(1);
        TokenStream ts = super.getTokenStream();
        ts = new APTMacroExpandedStream(ts, (APTMacroCallback)this.getMacroMap());
        if (filtered) {
            ts = new APTCommentsFilter(ts);
        }
        return ts;
    }

    protected void onDefine(APT apt) {
        MacroImpl macro;
        super.onDefine(apt);
        if (this.needMacroAndIncludes() && (macro = this.createMacro((APTDefine)apt)) != null) {
            this.getFile().addMacro(macro);
        }
    }

    protected void onErrorNode(APT apt) {
        super.onErrorNode(apt);
        if (this.needMacroAndIncludes()) {
            this.getFile().addError(this.createError((APTError)apt));
            if (this.evalCallback != null) {
                this.evalCallback.onStoppedDirective(apt);
            }
        }
    }

    protected void onPragmaNode(APT apt) {
        super.onPragmaNode(apt);
        if (this.isStopped() && this.evalCallback != null) {
            this.evalCallback.onStoppedDirective(apt);
        }
    }

    @Override
    protected void postInclude(APTInclude apt, FileImpl included, APTIncludeHandler.IncludeState pushIncludeState) {
        if (this.needMacroAndIncludes()) {
            this.getFile().addInclude(this.createInclude(apt, included, pushIncludeState == APTIncludeHandler.IncludeState.Recursive), pushIncludeState != APTIncludeHandler.IncludeState.Success);
        }
    }

    protected boolean hasIncludeActionSideEffects() {
        return this.needMacroAndIncludes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileImpl includeAction(ProjectBase inclFileOwner, CharSequence inclPath, int mode, APTInclude apt, PostIncludeData postIncludeState) throws IOException {
        try {
            FileImpl fileImpl = inclFileOwner.onFileIncluded(this.getStartProject(), inclPath, this.getPreprocHandler(), postIncludeState, mode, this.isTriggerParsingActivity());
            return fileImpl;
        }
        catch (NullPointerException ex) {
            APTUtils.LOG.log(Level.SEVERE, "NPE when processing file", ex);
            DiagnosticExceptoins.register(ex);
        }
        finally {
            this.getIncludeHandler().popInclude();
        }
        return null;
    }

    private ErrorDirectiveImpl createError(APTError error) {
        APTToken token = error.getToken();
        SimpleOffsetableImpl pos = this.getOffsetable(token);
        this.setEndPosition(pos, token);
        return ErrorDirectiveImpl.create(this.getFile(), token.getTextID(), pos);
    }

    private MacroImpl createMacro(APTDefine define) {
        APTToken last;
        List<Object> params = null;
        Collection paramTokens = define.getParams();
        if (paramTokens != null) {
            params = new ArrayList(paramTokens.size());
            for (APTToken elem : paramTokens) {
                if (!APTUtils.isID((Token)elem)) continue;
                params.add(NameCache.getManager().getString(elem.getTextID()));
            }
            if (params.isEmpty()) {
                params = Collections.emptyList();
            }
        }
        int startOffset = define.getToken().getOffset();
        List bodyTokens = define.getBody();
        String body = "";
        if (bodyTokens.isEmpty()) {
            last = define.getName();
        } else {
            last = (APTToken)bodyTokens.get(bodyTokens.size() - 1);
            body = "";
        }
        int endOffset = last != null && !APTUtils.isEOF((Token)last) && last.getEndOffset() > 0 ? last.getEndOffset() : startOffset;
        CsmMacro.Kind kind = define.isValid() ? CsmMacro.Kind.DEFINED : CsmMacro.Kind.INVALID;
        return MacroImpl.create(define.getName().getTextID(), params, body, this.getFile(), startOffset, endOffset, kind);
    }

    private IncludeImpl createInclude(APTInclude apt, FileImpl included, boolean recursive) {
        int startOffset = apt.getToken().getOffset();
        APTToken lastToken = this.getLastToken(apt.getInclude());
        if (lastToken == null || APTUtils.isEOF((Token)lastToken)) {
            lastToken = apt.getToken();
        }
        int endOffset = lastToken != null && !APTUtils.isEOF((Token)lastToken) ? lastToken.getEndOffset() : startOffset;
        IncludeImpl incImpl = IncludeImpl.create(apt.getFileName((APTMacroCallback)this.getMacroMap()), apt.isSystem((APTMacroCallback)this.getMacroMap()), recursive, included, this.getFile(), startOffset, endOffset);
        return incImpl;
    }

    private SimpleOffsetableImpl getOffsetable(APTToken token) {
        return new SimpleOffsetableImpl(token.getLine(), token.getColumn(), token.getOffset());
    }

    private void setEndPosition(SimpleOffsetableImpl offsetable, APTToken token) {
        if (token != null && !APTUtils.isEOF((Token)token)) {
            offsetable.setEndPosition(token.getEndLine(), token.getEndColumn(), token.getEndOffset());
        } else {
            assert (offsetable.getStartPosition() != null);
            offsetable.setEndPosition(offsetable.getStartPosition());
        }
    }

    private APTToken getLastToken(TokenStream ts) {
        try {
            Token last = ts.nextToken();
            Token curr = null;
            while (!APTUtils.isEOF((Token)(curr = ts.nextToken()))) {
                last = curr;
            }
            return (APTToken)last;
        }
        catch (TokenStreamException e) {
            DiagnosticExceptoins.register(e);
            return null;
        }
    }

    protected void onEval(APT apt, boolean result) {
        if (this.evalCallback != null) {
            this.evalCallback.onEval(apt, result);
        }
    }

    public static interface EvalCallback {
        public void onEval(APT var1, boolean var2);

        public void onStoppedDirective(APT var1);
    }
}

