/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;

public final class FriendResolverImpl
extends CsmFriendResolver {
    public boolean isFriend(CsmOffsetableDeclaration friendDecl, CsmClass target) {
        if (friendDecl == null) {
            throw new IllegalArgumentException("friendDecl must not be null");
        }
        CsmClass containingClass = null;
        if (CsmKindUtilities.isMethodDefinition((CsmObject)friendDecl)) {
            CsmFunction decl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)friendDecl));
            containingClass = ((CsmMember)decl).getContainingClass();
        } else if (CsmKindUtilities.isMethodDeclaration((CsmObject)friendDecl)) {
            containingClass = ((CsmMember)friendDecl).getContainingClass();
        }
        for (CsmFriend friend : target.getFriends()) {
            if (CsmKindUtilities.isFriendClass((CsmObject)friend)) {
                CsmFriendClass cls = (CsmFriendClass)friend;
                CsmClass reference = cls.getReferencedClass();
                if (friendDecl.equals(reference)) {
                    return true;
                }
                if (containingClass == null || !containingClass.equals(reference)) continue;
                return true;
            }
            if (!CsmKindUtilities.isFriendMethod((CsmObject)friend)) continue;
            if (friendDecl.equals(friend)) {
                return true;
            }
            CsmFriendFunction fun = (CsmFriendFunction)friend;
            CsmFunction ref = fun.getReferencedFunction();
            if (friendDecl.equals(ref)) {
                return true;
            }
            if (ref == null || !CsmKindUtilities.isFunctionDefinition((CsmObject)ref) || !friendDecl.equals(((CsmFunctionDefinition)ref).getDeclaration())) continue;
            return true;
        }
        return false;
    }

    public Collection<CsmFriend> findFriends(CsmOffsetableDeclaration decl) {
        CsmProject prj = decl.getContainingFile().getProject();
        if (prj instanceof ProjectBase) {
            return ((ProjectBase)prj).findFriendDeclarations(decl);
        }
        return Collections.emptyList();
    }
}

