/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public abstract class OffsetableDeclarationBase<T>
extends OffsetableIdentifiableBase<T>
implements CsmOffsetableDeclaration {
    public static final char UNIQUE_NAME_SEPARATOR = ':';

    protected OffsetableDeclarationBase(CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
    }

    public CharSequence getUniqueName() {
        return CharSequences.create((CharSequence)(Utils.getCsmDeclarationKindkey(this.getKind()) + ':' + this.getUniqueNameWithoutPrefix()));
    }

    public CharSequence getUniqueNameWithoutPrefix() {
        return this.getQualifiedName();
    }

    protected final CsmProject getProject() {
        CsmFile file = this.getContainingFile();
        assert (file != null);
        return file != null ? file.getProject() : null;
    }

    public CharSequence getQualifiedNamePostfix() {
        if (TraceFlags.SET_UNNAMED_QUALIFIED_NAME && this.getName().length() == 0) {
            return this.getOffsetBasedName();
        }
        return this.getName();
    }

    protected CharSequence toStringName() {
        CharSequence name = CsmKindUtilities.isTemplate((CsmObject)this) ? ((CsmTemplate)this).getDisplayName() : this.getName();
        if (this instanceof RawNamable) {
            StringBuilder out = new StringBuilder(name);
            out.append('(');
            boolean first = true;
            for (CharSequence part : ((RawNamable)((Object)this)).getRawName()) {
                if (first) {
                    first = false;
                } else {
                    out.append("::");
                }
                out.append(part);
            }
            out.append(')');
            name = out.toString();
        }
        return name;
    }

    private String getOffsetBasedName() {
        return "[" + this.getContainingFile().getName() + ":" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    @Override
    protected CsmUID<? extends CsmOffsetableDeclaration> createUID() {
        return UIDUtilities.createDeclarationUID(this);
    }

    public boolean isValid() {
        return CsmBaseUtilities.isValid((CsmObject)this.getContainingFileImpl(false));
    }

    protected static TemplateDescriptor createTemplateDescriptor(AST node, CsmFile file, CsmScope scope, StringBuilder classTemplateSuffix, boolean global) {
        boolean _template = false;
        boolean specialization = false;
        switch (node.getType()) {
            case 468: 
            case 473: 
            case 474: 
            case 491: 
            case 493: 
            case 495: 
            case 497: {
                _template = true;
                break;
            }
            case 478: 
            case 481: 
            case 482: 
            case 483: {
                _template = true;
                specialization = true;
            }
        }
        if (_template) {
            AST startTemplateSign;
            AST templateNode;
            boolean templateClass = false;
            List<CsmTemplateParameter> templateParams = null;
            AST templateClassNode = templateNode = node.getFirstChild();
            if (templateNode == null || templateNode.getType() != 115) {
                return null;
            }
            AST qIdToken = AstUtil.findChildOfType(node, 510);
            AST aST = startTemplateSign = qIdToken != null ? AstUtil.findChildOfType(qIdToken, 21) : null;
            if (startTemplateSign != null) {
                AST scopeSign;
                AST endTemplateSign = null;
                for (AST sibling = startTemplateSign.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                    if (sibling.getType() != 23) continue;
                    endTemplateSign = sibling;
                    break;
                }
                if (endTemplateSign != null && (scopeSign = endTemplateSign.getNextSibling()) != null && scopeSign.getType() == 52) {
                    AST templateSiblingNode;
                    if (specialization && classTemplateSuffix != null) {
                        classTemplateSuffix.append(TemplateUtils.getSpecializationSuffix(qIdToken, null));
                    }
                    if ((templateSiblingNode = templateNode.getNextSibling()) != null && templateSiblingNode.getType() == 115) {
                        templateNode = templateSiblingNode;
                        templateClass = true;
                    } else {
                        templateClass = true;
                        _template = false;
                    }
                }
            }
            int inheritedTemplateParametersNumber = 0;
            if (templateClass) {
                templateParams = TemplateUtils.getTemplateParameters(templateClassNode, file, scope, global);
                inheritedTemplateParametersNumber = templateParams.size();
            }
            String templateSuffix = "";
            if (_template) {
                if (specialization) {
                    templateSuffix = qIdToken == null ? "<>" : TemplateUtils.getSpecializationSuffix(qIdToken, null);
                } else {
                    StringBuilder sb = new StringBuilder();
                    TemplateUtils.addSpecializationSuffix(templateNode.getFirstChild(), sb, null);
                    templateSuffix = '<' + sb.toString() + '>';
                }
                if (templateParams != null) {
                    templateParams.addAll(TemplateUtils.getTemplateParameters(templateNode, file, scope, global));
                } else {
                    templateParams = TemplateUtils.getTemplateParameters(templateNode, file, scope, global);
                }
            }
            return new TemplateDescriptor(templateParams, templateSuffix, inheritedTemplateParametersNumber, specialization, global);
        }
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    protected OffsetableDeclarationBase(RepositoryDataInput input) throws IOException {
        super(input);
    }

    @Override
    public String toString() {
        CharSequence name = this.toStringName();
        return "" + this.getKind() + ' ' + name + this.getOffsetString() + this.getPositionString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this.getName().equals(((OffsetableDeclarationBase)obj).getName());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.getName().hashCode();
    }

    protected boolean registerInProject() {
        return false;
    }

    protected static <T> void postObjectCreateRegistration(boolean register, OffsetableDeclarationBase<T> obj) {
        if (register) {
            if (!obj.registerInProject()) {
                RepositoryUtils.put(obj);
            }
        } else {
            Utils.setSelfUID(obj);
        }
    }

    protected static <T> void temporaryRepositoryRegistration(boolean global, OffsetableDeclarationBase<T> obj) {
        if (global) {
            RepositoryUtils.hang(obj);
        } else {
            Utils.setSelfUID(obj);
        }
    }
}

