/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;

class NativeProjectListenerImpl
implements NativeProjectItemsListener {
    private static final boolean TRACE = false;
    private final NativeProject nativeProject;
    private final ProjectBase projectBase;
    private volatile boolean enabledEventsHandling = true;

    public NativeProjectListenerImpl(ModelImpl model, NativeProject nativeProject, ProjectBase project) {
        this.nativeProject = nativeProject;
        this.projectBase = project;
    }

    public void fileAdded(NativeFileItem fileItem) {
        this.itemsAddedImpl(Collections.singletonList(fileItem));
    }

    public void filesAdded(List<NativeFileItem> fileItems) {
        this.itemsAddedImpl(fileItems);
    }

    public void fileRemoved(NativeFileItem fileItem) {
        this.itemsRemovedImpl(Collections.singletonList(fileItem));
    }

    public void filesRemoved(List<NativeFileItem> fileItems) {
        this.itemsRemovedImpl(fileItems);
    }

    public void fileRenamed(String oldPath, NativeFileItem newFileIetm) {
        this.itemRenamedImpl(oldPath, newFileIetm);
    }

    final void enableListening(boolean enable) {
        if (TraceFlags.TIMING) {
            System.err.printf("\n%s ProjectListeners %s...\n", enable ? "enable" : "disable", this.nativeProject.getProjectDisplayName());
        }
        this.enabledEventsHandling = enable;
    }

    public void filePropertiesChanged(NativeFileItem fileItem) {
        if (this.enabledEventsHandling) {
            this.itemsPropertiesChangedImpl(Collections.singletonList(fileItem));
        } else if (TraceFlags.TIMING) {
            System.err.printf("\nskipped filePropertiesChanged(item) %s...\n", this.nativeProject.getProjectDisplayName());
        }
    }

    public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
        if (this.enabledEventsHandling) {
            this.itemsPropertiesChangedImpl(fileItems);
        } else if (TraceFlags.TIMING) {
            System.err.printf("\nskipped filesPropertiesChanged(list) %s...\n", this.nativeProject.getProjectDisplayName());
        }
    }

    public void filesPropertiesChanged() {
        if (this.enabledEventsHandling) {
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : this.nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        list.add(item);
                        break;
                    }
                }
            }
            this.itemsPropertiesChangedImpl(list);
        } else if (TraceFlags.TIMING) {
            System.err.printf("\nskipped filesPropertiesChanged %s...\n", this.nativeProject.getProjectDisplayName());
        }
    }

    public void projectDeleted(NativeProject nativeProject) {
        RepositoryUtils.onProjectDeleted(nativeProject);
    }

    private void itemsAddedImpl(final List<NativeFileItem> items) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeProjectListenerImpl.this.projectBase.onFileAdded(items);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying add items");
        }
    }

    private void itemsRemovedImpl(final List<NativeFileItem> items) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeProjectListenerImpl.this.projectBase.onFileRemoved(items);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying remove items");
        }
    }

    private void itemRenamedImpl(final String oldPath, final NativeFileItem newFileIetm) {
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            @Override
            public void run() {
                try {
                    NativeProjectListenerImpl.this.projectBase.onFileRemoved(oldPath);
                    NativeProjectListenerImpl.this.projectBase.onFileAdded(newFileIetm);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }, "Applying rename item");
    }

    private void itemsPropertiesChangedImpl(final List<NativeFileItem> items) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (NativeProjectListenerImpl.this.projectBase.isValid()) {
                            if (NativeProjectListenerImpl.this.projectBase instanceof ProjectImpl) {
                                LibraryManager.getInstance().onProjectPropertyChanged(NativeProjectListenerImpl.this.projectBase.getUID());
                            }
                            NativeProjectListenerImpl.this.projectBase.onFilePropertyChanged(items);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying property changes");
        }
    }
}

