/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;

public final class DeepReparsingUtils {
    private static final boolean TRACE = false;
    private static final Logger LOG = Logger.getLogger("DeepReparsingUtils");

    private DeepReparsingUtils() {
    }

    static void reparseOnEditingFile(ProjectImpl project, FileImpl fileImpl) {
        project.markAsParsingPreprocStates(fileImpl.getAbsolutePath());
        fileImpl.markReparseNeeded(false);
        ParserQueue.instance().add(fileImpl, Collections.singleton(FileImpl.DUMMY_STATE), ParserQueue.Position.HEAD, false, ParserQueue.FileAction.NOTHING);
    }

    public static void reparseOnChangedFile(FileImpl fileImpl, ProjectBase project) {
        APTDriver.invalidateAPT((APTFileBuffer)fileImpl.getBuffer());
        boolean scheduleParsing = true;
        GraphContainer.ParentFiles top = project.getGraph().getTopParentFiles(fileImpl);
        Set<CsmFile> cuStartFiles = top.getCompilationUnits();
        Set<CsmFile> parents = top.getParentFiles();
        if (cuStartFiles.size() > 0) {
            fileImpl.clearStateCache();
            Set<CsmFile> coherence = project.getGraph().getCoherenceFiles(fileImpl).getCoherenceFiles();
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(coherence, cuStartFiles);
            for (CsmFile file : coherence) {
                if (cuStartFiles.contains(file)) {
                    ((FileImpl)file).clearStateCache();
                    continue;
                }
                if (parents.contains(file)) {
                    ((FileImpl)file).clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(project, file);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(project, file);
            }
            if (scheduleParsing) {
                DeepReparsingUtils.addToReparse(project, cuStartFiles, new HashSet<CsmFile>(0), false);
            }
        } else if (scheduleParsing) {
            ParserQueue.instance().add(fileImpl, project.getPreprocHandlers(fileImpl.getAbsolutePath()), ParserQueue.Position.HEAD);
        }
    }

    static void reparseOnEdit(Collection<FileImpl> toReparse, ProjectBase project, boolean scheduleParsing) {
        HashSet<CsmUID<CsmFile>> topParents = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> parents = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> coherence = new HashSet<CsmUID<CsmFile>>();
        for (FileImpl fileImpl : toReparse) {
            GraphContainer.ParentFiles parentFiles = project.getGraph().getTopParentFiles(fileImpl);
            Set<CsmUID<CsmFile>> units = parentFiles.getCompilationUnitsUids();
            if (units.size() > 0) {
                topParents.addAll(units);
                parents.addAll(parentFiles.getParentFilesUids());
                coherence.addAll(project.getGraph().getCoherenceFiles(fileImpl).getCoherenceFilesUids());
                continue;
            }
            if (!scheduleParsing) continue;
            ParserQueue.instance().add(fileImpl, project.getPreprocHandlers(fileImpl.getAbsolutePath()), ParserQueue.Position.HEAD);
        }
        if (topParents.size() > 0) {
            CsmFile fileImpl;
            HashSet<CsmFile> topParentsImpl = new HashSet<CsmFile>();
            for (CsmUID csmUID : coherence) {
                fileImpl = UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (fileImpl == null) continue;
                DeepReparsingUtils.updateStartFilesWithBestStartFiles(Collections.singleton(fileImpl), topParentsImpl);
            }
            for (CsmUID csmUID : coherence) {
                fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (fileImpl == null) continue;
                if (topParents.contains(csmUID)) {
                    topParentsImpl.add(fileImpl);
                    fileImpl.clearStateCache();
                    continue;
                }
                if (parents.contains(csmUID)) {
                    fileImpl.clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(project, fileImpl);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(project, fileImpl);
            }
            if (scheduleParsing) {
                DeepReparsingUtils.addToReparse(project, topParentsImpl, new HashSet<CsmFile>(0), false);
            }
        }
    }

    private static void gatherCoherenceLibrary(Set<CsmFile> coherenceLibrary) {
        while (true) {
            HashSet<CsmFile> newCoherenceLibrary = new HashSet<CsmFile>();
            for (CsmFile coherence : coherenceLibrary) {
                newCoherenceLibrary.add(coherence);
                ProjectBase coherenceProject = (ProjectBase)coherence.getProject();
                newCoherenceLibrary.addAll(coherenceProject.getGraph().getIncludedFiles(coherence));
            }
            if (newCoherenceLibrary.size() == coherenceLibrary.size()) {
                return;
            }
            coherenceLibrary.addAll(newCoherenceLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reparseOnPropertyChanged(Collection<NativeFileItem> items, ProjectBase project) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(project);
            HashMap<FileImpl, NativeFileItem> pairs = new HashMap<FileImpl, NativeFileItem>();
            HashSet<CsmFile> top = new HashSet<CsmFile>();
            HashSet<CsmFile> coherence = new HashSet<CsmFile>();
            HashSet<CsmFile> coherenceLibrary = new HashSet<CsmFile>();
            for (NativeFileItem item : items) {
                FileImpl file;
                if (!Utils.acceptNativeItem(item) || (file = project.getFile(item.getAbsolutePath(), false)) == null) continue;
                file.clearStateCache();
                pairs.put(file, item);
                top.addAll(project.getGraph().getTopParentFiles(file).getCompilationUnits());
                coherence.addAll(project.getGraph().getIncludedFiles(file));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(coherence, top);
            for (CsmFile parent : coherence) {
                if (top.contains(parent)) continue;
                CsmProject parentPoject = parent.getProject();
                if (project.equals(parentPoject)) {
                    DeepReparsingUtils.invalidateFileAndPreprocState(project, parent);
                    continue;
                }
                coherenceLibrary.add(parent);
            }
            if (!TraceFlags.DEEP_REPARSING_OPTIMISTIC) {
                DeepReparsingUtils.gatherCoherenceLibrary(coherenceLibrary);
                DeepReparsingUtils.invalidateFileAndPreprocState(coherenceLibrary);
            }
            for (CsmFile parent : top) {
                if (parent.getProject() != project) continue;
                FileImpl parentImpl = (FileImpl)parent;
                if (pairs.containsKey(parentImpl)) {
                    NativeFileItem item = (NativeFileItem)pairs.get(parentImpl);
                    DeepReparsingUtils.addToReparse(project, item, parentImpl);
                    continue;
                }
                DeepReparsingUtils.addToReparse(project, parentImpl, true);
            }
        }
        catch (Exception e) {
            DiagnosticExceptoins.register(e);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(project);
        }
    }

    public static void reparseOnAdded(FileObject addedFile, ProjectBase project) {
        DeepReparsingUtils.reparseOnAdded(Collections.singleton(addedFile.getNameExt()), project);
    }

    static void reparseOnAdded(List<NativeFileItem> toReparse, ProjectBase project) {
        HashSet<String> names = new HashSet<String>();
        for (NativeFileItem item : toReparse) {
            names.add(item.getName());
        }
        DeepReparsingUtils.reparseOnAdded(names, project);
    }

    private static void reparseOnAdded(Set<String> names, ProjectBase project) {
        HashSet<CsmFile> resolved = new HashSet<CsmFile>();
        for (CsmFile file : project.getAllFiles()) {
            DeepReparsingUtils.findResolved(names, resolved, file);
        }
        if (resolved.size() > 0) {
            HashSet<CsmFile> top = new HashSet<CsmFile>();
            HashSet<CsmFile> coherence = new HashSet<CsmFile>();
            for (CsmFile file : resolved) {
                top.addAll(project.getGraph().getTopParentFiles(file).getCompilationUnits());
                coherence.add(file);
                coherence.addAll(project.getGraph().getIncludedFiles(file));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(coherence, top);
            DeepReparsingUtils.addToReparse(project, top, coherence, true);
        }
    }

    private static void findResolved(Set<String> names, Set<CsmFile> resolved, CsmFile file) {
        for (CsmInclude incl : file.getIncludes()) {
            String name = ((Object)incl.getIncludeName()).toString();
            int i = Math.max(name.lastIndexOf(92), name.lastIndexOf(47));
            if (i > 0) {
                name = name.substring(i);
            }
            if (!names.contains(name)) continue;
            resolved.add(file);
            break;
        }
    }

    static void reparseOnRemoved(Collection<FileImpl> toReparse, ProjectBase project) {
        CndFileUtils.clearFileExistenceCache();
        HashSet<CsmFile> topParents = new HashSet<CsmFile>();
        HashSet<CsmFile> coherence = new HashSet<CsmFile>();
        for (FileImpl impl : toReparse) {
            if (impl == null) continue;
            topParents.addAll(project.getGraph().getTopParentFiles(impl).getCompilationUnits());
            coherence.addAll(project.getGraph().getCoherenceFiles(impl).getCoherenceFiles());
            project.getGraph().removeFile(impl);
            topParents.remove(impl);
            coherence.remove(impl);
        }
        DeepReparsingUtils.addToReparse(project, topParents, coherence, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToReparse(ProjectBase project, Set<CsmFile> topParents, Set<CsmFile> coherence, boolean invalidateCache) {
        for (CsmFile incl : coherence) {
            if (topParents.contains(incl)) continue;
            DeepReparsingUtils.invalidateFileAndPreprocState(project, incl);
        }
        if (!topParents.isEmpty()) {
            try {
                ParserQueue.instance().onStartAddingProjectFiles(project);
                for (CsmFile parent : topParents) {
                    if (parent.getProject() != project) continue;
                    FileImpl parentImpl = (FileImpl)parent;
                    DeepReparsingUtils.addToReparse(project, parentImpl, invalidateCache);
                }
            }
            catch (Exception e) {
                DiagnosticExceptoins.register(e);
            }
            finally {
                ParserQueue.instance().onEndAddingProjectFiles(project);
            }
        }
    }

    private static void addToReparse(ProjectBase project, FileImpl parentImpl, boolean invalidateCache) {
        project.invalidatePreprocState(parentImpl.getAbsolutePath());
        parentImpl.markReparseNeeded(invalidateCache);
        ParserQueue.instance().add(parentImpl, project.getPreprocHandlers(parentImpl.getAbsolutePath()), ParserQueue.Position.HEAD);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + parentImpl.getAbsolutePath());
        }
    }

    private static void addToReparse(ProjectBase project, NativeFileItem nativeFile, FileImpl file) {
        if (nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
            file.markReparseNeeded(true);
            APTPreprocHandler.State state = project.setChangedFileState(nativeFile);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Add file to reparse " + file.getAbsolutePath());
            }
            ParserQueue.instance().add(file, state, ParserQueue.Position.HEAD);
        } else assert (false);
    }

    private static void invalidateFileAndPreprocState(ProjectBase project, CsmFile parent) {
        if (parent.getProject() == project) {
            FileImpl parentImpl = (FileImpl)parent;
            parentImpl.clearStateCache();
            project.invalidatePreprocState(parentImpl.getAbsolutePath());
            parentImpl.markReparseNeeded(false);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Invalidate file to reparse " + parent.getAbsolutePath());
            }
        }
    }

    private static void invalidateFileAndPreprocState(Set<CsmFile> coherenceLibrary) {
        for (CsmFile parent : coherenceLibrary) {
            CsmProject project = parent.getProject();
            if (!(project instanceof ProjectBase)) continue;
            FileImpl parentImpl = (FileImpl)parent;
            parentImpl.clearStateCache();
            ((ProjectBase)project).invalidatePreprocState(parentImpl.getAbsolutePath());
            parentImpl.markReparseNeeded(false);
            if (!TraceFlags.USE_DEEP_REPARSING_TRACE) continue;
            System.out.println("Invalidate file to reparse " + parent.getAbsolutePath());
        }
    }

    private static void updateStartFilesWithBestStartFiles(Set<CsmFile> coherence, Set<CsmFile> cuStartFiles) {
        for (CsmFile csmFile : coherence) {
            if (cuStartFiles.contains(csmFile)) continue;
            Collection compilationUnits = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0);
            for (CsmCompilationUnit cu : compilationUnits) {
                CsmFile startFile = cu.getStartFile();
                if (startFile == null) continue;
                cuStartFiles.add(startFile);
            }
        }
    }

    private static String toString(Collection<?> files) {
        StringBuilder out = new StringBuilder();
        for (Object elem : files) {
            if (elem instanceof FileImpl) {
                out.append(((FileImpl)elem).getAbsolutePath());
                continue;
            }
            if (elem instanceof NativeFileItem) {
                out.append(((NativeFileItem)elem).getAbsolutePath());
                continue;
            }
            out.append(elem.toString());
        }
        return out.toString();
    }
}

