/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModel;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModelProvider;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class CreateFilesWorker {
    private FileModel lwm;
    private boolean lwmInited;
    private final ProjectBase project;
    private final RequestProcessor PROJECT_FILES_WORKER = new RequestProcessor("Project Files", CndUtils.getNumberCndWorkerThreads());

    CreateFilesWorker(ProjectBase project) {
        this.project = project;
    }

    private synchronized FileModel getLWM() {
        if (!this.lwmInited) {
            FileModelProvider provider = (FileModelProvider)Lookup.getDefault().lookup(FileModelProvider.class);
            if (provider != null) {
                this.lwm = provider.getFileModel(this.project);
            }
            this.lwmInited = true;
        }
        return this.lwm;
    }

    /*
     * WARNING - void declaration
     */
    void createProjectFilesIfNeed(List<NativeFileItem> items, boolean sources, Set<NativeFileItem> removedFiles, ProjectSettingsValidator validator) {
        List<FileImpl> reparseOnEdit = Collections.synchronizedList(new ArrayList());
        List<NativeFileItem> reparseOnPropertyChanged = Collections.synchronizedList(new ArrayList());
        Set<CsmUID> handledFiles = Collections.synchronizedSet(new HashSet(items.size()));
        AtomicBoolean enougth = new AtomicBoolean(false);
        int size = items.size();
        int threads = CndUtils.getNumberCndWorkerThreads() * 3;
        CountDownLatch countDownLatch = new CountDownLatch(threads);
        int chunk = size / threads + 1;
        Iterator<NativeFileItem> it = items.iterator();
        for (int i = 0; i < threads; ++i) {
            void var16_20;
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(chunk);
            boolean bl = false;
            while (var16_20 < chunk && it.hasNext()) {
                list.add(it.next());
                ++var16_20;
            }
            CreateFileRunnable createFileRunnable = new CreateFileRunnable(countDownLatch, list, sources, removedFiles, validator, this.project, handledFiles, reparseOnEdit, reparseOnPropertyChanged, enougth);
            this.PROJECT_FILES_WORKER.post((Runnable)createFileRunnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!enougth.get() && validator != null && !sources) {
            HashSet<CsmUID<CsmFile>> allFilesUID = new HashSet<CsmUID<CsmFile>>(this.project.getHeaderFilesUID());
            allFilesUID.removeAll(handledFiles);
            if (TraceFlags.TRACE_VALIDATION) {
                for (CsmUID csmUID : handledFiles) {
                    System.err.printf("Hanlded %s - %d\n", csmUID, System.identityHashCode(csmUID));
                }
                for (CsmUID csmUID : allFilesUID) {
                    System.err.printf("To handle %s - %d\n", csmUID, System.identityHashCode(csmUID));
                }
            }
            for (CsmUID csmUID : allFilesUID) {
                if (csmUID == null || RepositoryUtils.getRepositoryErrorCount(this.project) > 0) {
                    enougth.set(true);
                    break;
                }
                CsmFile file = UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (file instanceof FileImpl) {
                    FileImpl fileImpl = (FileImpl)file;
                    if (fileImpl.getState() == FileImpl.State.INITIAL || !fileImpl.validate()) {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s file [%d %s] to be parsed, because of state %s\n", new Object[]{fileImpl.getAbsolutePath(), System.identityHashCode(csmUID), fileImpl.getFileType(), fileImpl.getState()});
                        }
                        reparseOnEdit.add(fileImpl);
                        continue;
                    }
                    if (!TraceFlags.TRACE_VALIDATION) continue;
                    System.err.printf("Validation: skip %s file [%d %s], because of state %s\n", new Object[]{fileImpl.getAbsolutePath(), System.identityHashCode(csmUID), fileImpl.getFileType(), fileImpl.getState()});
                    continue;
                }
                enougth.set(true);
                RepositoryUtils.registerRepositoryError(this.project, new Exception("Validation: file was not restored from " + csmUID));
                System.err.printf("Validation: file was not restored from %s\n", csmUID);
                break;
            }
            if (TraceFlags.DEBUG_BROKEN_REPOSITORY) {
                enougth.set(true);
                RepositoryUtils.registerRepositoryError(this.project, new Exception("Validation: INTENTIONAL interrupt"));
            }
        }
        if (!enougth.get()) {
            if (!reparseOnEdit.isEmpty()) {
                DeepReparsingUtils.reparseOnEdit(reparseOnEdit, this.project, true);
            }
            if (!reparseOnPropertyChanged.isEmpty()) {
                DeepReparsingUtils.reparseOnPropertyChanged(reparseOnPropertyChanged, this.project);
            }
        }
    }

    private class CreateFileRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<NativeFileItem> nativeFileItems;
        private final boolean sources;
        private final Set<NativeFileItem> removedFiles;
        private final ProjectSettingsValidator validator;
        private final ProjectBase project;
        private final List<FileImpl> reparseOnEdit;
        private final List<NativeFileItem> reparseOnPropertyChanged;
        private final AtomicBoolean enougth;
        private final Set<CsmUID<CsmFile>> handledFiles;

        private CreateFileRunnable(CountDownLatch countDownLatch, List<NativeFileItem> nativeFileItems, boolean sources, Set<NativeFileItem> removedFiles, ProjectSettingsValidator validator, ProjectBase project, Set<CsmUID<CsmFile>> handledFiles, List<FileImpl> reparseOnEdit, List<NativeFileItem> reparseOnPropertyChanged, AtomicBoolean enougth) {
            this.countDownLatch = countDownLatch;
            this.nativeFileItems = nativeFileItems;
            this.sources = sources;
            this.removedFiles = removedFiles;
            this.validator = validator;
            this.project = project;
            this.reparseOnEdit = reparseOnEdit;
            this.reparseOnPropertyChanged = reparseOnPropertyChanged;
            this.enougth = enougth;
            this.handledFiles = handledFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (NativeFileItem nativeFileItem : this.nativeFileItems) {
                    if (this.createProjectFilesIfNeedRun(nativeFileItem, this.sources, this.removedFiles, this.validator, this.reparseOnEdit, this.reparseOnPropertyChanged, this.enougth)) continue;
                    return;
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }

        private boolean createProjectFilesIfNeedRun(NativeFileItem nativeFileItem, boolean sources, Set<NativeFileItem> removedFiles, ProjectSettingsValidator validator, List<FileImpl> reparseOnEdit, List<NativeFileItem> reparseOnPropertyChanged, AtomicBoolean enougth) {
            if (enougth.get()) {
                return false;
            }
            CsmModelState modelState = ModelImpl.instance().getState();
            if (modelState == CsmModelState.CLOSING || modelState == CsmModelState.OFF) {
                if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("createProjectFilesIfNeedRun: %s file [%s] is interrupted on closing model\n", nativeFileItem.getAbsolutePath(), this.project.getName());
                }
                return false;
            }
            if (this.project.isDisposing()) {
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", this.project.getName());
                }
                return false;
            }
            if (removedFiles.contains(nativeFileItem)) {
                FileImpl file = this.project.getFile(nativeFileItem.getAbsolutePath(), true);
                if (file != null) {
                    this.project.removeFile(nativeFileItem.getAbsolutePath());
                    this.handledFiles.add(UIDCsmConverter.fileToUID(file));
                }
                return true;
            }
            assert (nativeFileItem.getFileObject() != null) : "native file item must have valid File object";
            if (TraceFlags.DEBUG) {
                ModelSupport.trace(nativeFileItem);
            }
            try {
                FileImpl fileImpl = this.project.createIfNeed(nativeFileItem, sources, CreateFilesWorker.this.getLWM(), validator, reparseOnEdit, reparseOnPropertyChanged);
                this.handledFiles.add(UIDCsmConverter.fileToUID(fileImpl));
                if (this.project.isValidating() && RepositoryUtils.getRepositoryErrorCount(this.project) > 0) {
                    enougth.set(true);
                    return false;
                }
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
            return true;
        }
    }
}

