/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.toolbar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.toolbar.Toolbar;
import org.primefaces.component.toolbar.ToolbarGroup;
import org.primefaces.renderkit.CoreRenderer;

public class ToolbarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Toolbar toolbar = (Toolbar)component;
        ResponseWriter writer = context.getResponseWriter();
        String style = toolbar.getStyle();
        String styleClass = toolbar.getStyleClass();
        styleClass = styleClass == null ? Toolbar.CONTAINER_CLASS : Toolbar.CONTAINER_CLASS + " " + styleClass;
        writer.startElement("div", (UIComponent)toolbar);
        writer.writeAttribute("id", (Object)toolbar.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        for (UIComponent child : toolbar.getChildren()) {
            if (!(child instanceof ToolbarGroup)) continue;
            ToolbarGroup group = (ToolbarGroup)child;
            String defaultGroupClass = "ui-toolbar-group-" + group.getAlign();
            String groupClass = group.getStyleClass();
            String groupStyle = group.getStyle();
            groupClass = groupClass == null ? defaultGroupClass : defaultGroupClass + " " + groupClass;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)groupClass, style);
            if (groupStyle != null) {
                writer.writeAttribute("style", (Object)groupStyle, null);
            }
            group.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

