/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.messages.Messages;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Messages uiMessages = (Messages)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        Iterator allMessages = uiMessages.isGlobalOnly() ? facesContext.getMessages(null) : facesContext.getMessages();
        HashMap messages = new HashMap();
        messages.put("info", new ArrayList());
        messages.put("warn", new ArrayList());
        messages.put("error", new ArrayList());
        messages.put("fatal", new ArrayList());
        while (allMessages.hasNext()) {
            FacesMessage message = (FacesMessage)allMessages.next();
            Object severity = message.getSeverity();
            if (message.isRendered() && !uiMessages.isRedisplay()) continue;
            if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                ((List)messages.get("info")).add(message);
                continue;
            }
            if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                ((List)messages.get("warn")).add(message);
                continue;
            }
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                ((List)messages.get("error")).add(message);
                continue;
            }
            if (!severity.equals(FacesMessage.SEVERITY_FATAL)) continue;
            ((List)messages.get("fatal")).add(message);
        }
        writer.startElement("div", (UIComponent)uiMessages);
        writer.writeAttribute("id", (Object)uiMessages.getClientId(facesContext), "id");
        writer.writeAttribute("class", (Object)"ui-messages ui-widget", null);
        for (Object severity : messages.keySet()) {
            List severityMessages = (List)messages.get(severity);
            if (severityMessages.size() <= 0) continue;
            this.encodeSeverityMessages(facesContext, uiMessages, (String)severity, severityMessages);
        }
        writer.endElement("div");
    }

    private void encodeSeverityMessages(FacesContext facesContext, Messages uiMessages, String severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String styleClassPrefix = "ui-messages-" + severity;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(styleClassPrefix + " ui-corner-all"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(styleClassPrefix + "-icon"), null);
        writer.endElement("span");
        writer.startElement("ul", null);
        for (FacesMessage msg : messages) {
            String detail;
            writer.startElement("li", null);
            String summary = msg.getSummary() != null ? msg.getSummary() : "";
            String string = detail = msg.getDetail() != null ? msg.getDetail() : summary;
            if (uiMessages.isShowSummary()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(styleClassPrefix + "-summary"), null);
                writer.write(summary);
                writer.endElement("span");
            }
            if (uiMessages.isShowDetail()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(styleClassPrefix + "-detail"), null);
                writer.write(detail);
                writer.endElement("span");
            }
            writer.endElement("li");
            msg.rendered();
        }
        writer.endElement("ul");
        writer.endElement("div");
    }
}

