/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openidex.search.SearchType;

public final class FindDialogMemory {
    private static final int maxFileNamePatternCount = 10;
    private static final int maxReplExprCount = 10;
    private static FindDialogMemory singleton;
    private SearchType lastSearchType = null;
    private List<String> fileNamePatterns;
    private List<String> replExpressions;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean preserveCase;
    private boolean regularExpression;
    private boolean textPatternSpecified;
    private boolean fileNamePatternSpecified;
    private static Preferences prefs;
    private static final String PREFS_NODE = "FindDialogMemory";
    private static final String PROP_WHOLE_WORDS = "whole_words";
    private static final String PROP_CASE_SENSITIVE = "case_sensitive";
    private static final String PROP_PRESERVE_CASE = "preserve_case";
    private static final String PROP_REGULAR_EXPRESSION = "regular_expression";
    private static final String PROP_FILENAME_PATTERN_SPECIFIED = "filename_specified";
    private static final String PROP_FILENAME_PATTERN_PREFIX = "filename_pattern_";
    private static final String PROP_REPLACE_PATTERN_PREFIX = "replace_pattern_";

    private FindDialogMemory() {
        prefs = NbPreferences.forModule(FindDialogMemory.class).node(PREFS_NODE);
        this.load();
    }

    public static FindDialogMemory getDefault() {
        if (singleton == null) {
            singleton = new FindDialogMemory();
        }
        return singleton;
    }

    private void load() {
        this.wholeWords = prefs.getBoolean(PROP_WHOLE_WORDS, false);
        this.caseSensitive = prefs.getBoolean(PROP_CASE_SENSITIVE, false);
        this.regularExpression = prefs.getBoolean(PROP_REGULAR_EXPRESSION, false);
        this.preserveCase = prefs.getBoolean(PROP_PRESERVE_CASE, false);
        this.fileNamePatternSpecified = prefs.getBoolean(PROP_FILENAME_PATTERN_SPECIFIED, false);
        this.fileNamePatterns = new ArrayList<String>(10);
        this.replExpressions = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            String replacePattern;
            String fileNamePattern = prefs.get(PROP_FILENAME_PATTERN_PREFIX + i, null);
            if (fileNamePattern != null) {
                this.fileNamePatterns.add(fileNamePattern);
            }
            if ((replacePattern = prefs.get(PROP_REPLACE_PATTERN_PREFIX + i, null)) == null) continue;
            this.replExpressions.add(replacePattern);
        }
    }

    public void setLastUsedSearchType(SearchType searchType) {
        this.lastSearchType = searchType;
    }

    public SearchType getLastSearchType() {
        return this.lastSearchType;
    }

    void storeFileNamePattern(String pattern) {
        int index = this.fileNamePatterns.indexOf(pattern);
        if (index != -1) {
            if (index == this.fileNamePatterns.size() - 1) {
                return;
            }
            this.fileNamePatterns.remove(index);
        } else if (this.fileNamePatterns.size() == 10) {
            this.fileNamePatterns.remove(0);
        }
        this.fileNamePatterns.add(pattern);
        for (int i = 0; i < this.fileNamePatterns.size(); ++i) {
            prefs.put(PROP_FILENAME_PATTERN_PREFIX + i, this.fileNamePatterns.get(i));
        }
    }

    List<String> getFileNamePatterns() {
        return this.fileNamePatterns != null ? this.fileNamePatterns : Collections.emptyList();
    }

    void storeReplacementExpression(String expression) {
        int index = this.replExpressions.indexOf(expression);
        if (index != -1) {
            if (index == this.replExpressions.size() - 1) {
                return;
            }
            this.replExpressions.remove(index);
        } else if (this.replExpressions.size() == 10) {
            this.replExpressions.remove(0);
        }
        this.replExpressions.add(expression);
        for (int i = 0; i < this.replExpressions.size(); ++i) {
            prefs.put(PROP_REPLACE_PATTERN_PREFIX + i, this.replExpressions.get(i));
        }
    }

    List<String> getReplacementExpressions() {
        return this.replExpressions != null ? this.replExpressions : Collections.emptyList();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        this.wholeWords = wholeWords;
        prefs.putBoolean(PROP_WHOLE_WORDS, wholeWords);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isPreserveCase() {
        return this.preserveCase;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        prefs.putBoolean(PROP_CASE_SENSITIVE, caseSensitive);
    }

    public void setPreserveCase(boolean preserveCase) {
        this.preserveCase = preserveCase;
        prefs.putBoolean(PROP_PRESERVE_CASE, preserveCase);
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(boolean regularExpression) {
        this.regularExpression = regularExpression;
        prefs.putBoolean(PROP_REGULAR_EXPRESSION, regularExpression);
    }

    boolean isTextPatternSpecified() {
        return this.textPatternSpecified;
    }

    void setTextPatternSpecified(boolean specified) {
        this.textPatternSpecified = specified;
    }

    boolean isFileNamePatternSpecified() {
        return this.fileNamePatternSpecified;
    }

    void setFileNamePatternSpecified(boolean specified) {
        this.fileNamePatternSpecified = specified;
        prefs.putBoolean(PROP_FILENAME_PATTERN_SPECIFIED, specified);
    }
}

