/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.util.LinkedList;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.TokenStreamRecognitionException;
import org.netbeans.modules.cnd.apt.impl.structure.APTBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTEndifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTErrorNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTFileNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfdefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfndefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNextNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTPragmaNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTStreamNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUndefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUnknownNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.openide.filesystems.FileSystem;

public final class APTBuilderImpl {
    private LinkedList<Pair> nodeStack = new LinkedList();

    public APTFile buildAPT(FileSystem fileSystem, CharSequence path, TokenStream ts) {
        if (ts == null) {
            return null;
        }
        APTFileNode aptFile = new APTFileNode(fileSystem, path);
        try {
            this.buildFileAPT(aptFile, ts);
        }
        catch (TokenStreamRecognitionException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on building APT\n {0}", new Object[]{ex});
        }
        catch (TokenStreamException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on converting token stream to text while building APT\n{0}", new Object[]{ex});
            APTUtils.LOG.log(Level.SEVERE, "problem file is {0}", new Object[]{path});
        }
        return aptFile;
    }

    public static APT buildAPTLight(APT apt) {
        assert (apt != null);
        assert (APTBuilderImpl.isRootNode(apt));
        APT outApt = APTBuilderImpl.createLightCopy(apt);
        APT node = APTBuilderImpl.nextRoot(apt);
        APT nodeLight = outApt;
        do {
            APT sibling;
            APT child;
            if ((child = APTBuilderImpl.nextRoot(node.getFirstChild())) != null) {
                APT childLight = APTBuilderImpl.buildAPTLight(child);
                assert (childLight != null);
                assert (APTBuilderImpl.isRootNode(childLight));
                nodeLight.setFirstChild(childLight);
            }
            node = sibling = APTBuilderImpl.nextRoot(node.getNextSibling());
            if (sibling == null) continue;
            APT siblingLight = APTBuilderImpl.createLightCopy(sibling);
            assert (siblingLight != null);
            assert (APTBuilderImpl.isRootNode(siblingLight));
            nodeLight.setNextSibling(siblingLight);
            nodeLight = siblingLight;
        } while (node != null);
        assert (outApt != null);
        assert (APTBuilderImpl.isRootNode(outApt));
        return outApt;
    }

    private void buildFileAPT(APTFileNode aptFile, TokenStream ts) throws TokenStreamException {
        APTToken lastToken = this.nonRecursiveBuild(aptFile, ts);
        assert (APTUtils.isEOF(lastToken));
    }

    private APTToken nonRecursiveBuild(APTFileNode aptFile, TokenStream stream) throws TokenStreamException {
        assert (stream != null);
        Pair root = new Pair(aptFile);
        APTToken nextToken = (APTToken)stream.nextToken();
        while (!APTUtils.isEOF(nextToken)) {
            APTBaseNode activeNode = this.createNode(nextToken);
            nextToken = this.initNode(aptFile, activeNode, (APTToken)stream.nextToken(), stream);
            if (APTUtils.isEndConditionNode(activeNode.getType())) {
                if (!this.nodeStack.isEmpty()) {
                    root = this.nodeStack.removeLast();
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without corresponding #if\n", new Object[]{APTTraceUtils.toFileString(aptFile), nextToken.getLine(), nextToken.getText()});
                }
            }
            root.addChild(activeNode);
            if (!APTUtils.isStartOrSwitchConditionNode(activeNode.getType())) continue;
            this.nodeStack.addLast(root);
            root = new Pair(activeNode);
        }
        for (Pair pair : this.nodeStack) {
            APTToken token = pair.lastChild == null ? pair.active.getToken() : pair.lastChild.getToken();
            APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without closing #endif\n", new Object[]{APTTraceUtils.toFileString(aptFile), token == null ? -1 : token.getLine(), token == null ? Integer.valueOf(-1) : token.getText()});
        }
        return nextToken;
    }

    private APTToken initNode(APTFileNode aptFile, APT node, APTToken nextToken, TokenStream stream) throws TokenStreamException {
        while (!APTUtils.isEOF(nextToken) && node.accept(aptFile, nextToken)) {
            nextToken = (APTToken)stream.nextToken();
        }
        if (APTUtils.isEndDirectiveToken(nextToken.getType())) {
            nextToken = (APTToken)stream.nextToken();
        }
        return nextToken;
    }

    private APTBaseNode createNode(APTToken token) {
        APTTokenBasedNode newNode;
        assert (!APTUtils.isEOF(token));
        int ttype = token.getType();
        switch (ttype) {
            case 101: {
                newNode = new APTIfNode(token);
                break;
            }
            case 99: {
                newNode = new APTIfdefNode(token);
                break;
            }
            case 100: {
                newNode = new APTIfndefNode(token);
                break;
            }
            case 95: {
                newNode = new APTIncludeNode(token);
                break;
            }
            case 96: {
                newNode = new APTIncludeNextNode(token);
                break;
            }
            case 102: {
                newNode = new APTElifNode(token);
                break;
            }
            case 103: {
                newNode = new APTElseNode(token);
                break;
            }
            case 104: {
                newNode = new APTEndifNode(token);
                break;
            }
            case 97: {
                newNode = new APTDefineNode(token);
                break;
            }
            case 98: {
                newNode = new APTUndefineNode(token);
                break;
            }
            case 107: {
                newNode = new APTErrorNode(token);
                break;
            }
            case 105: {
                newNode = new APTPragmaNode(token);
                break;
            }
            case 106: 
            case 108: {
                newNode = new APTUnknownNode(token);
                break;
            }
            default: {
                assert (!APTUtils.isPreprocessorToken(ttype)) : "all preprocessor tokens should be handled above";
                newNode = new APTStreamNode(token);
            }
        }
        assert (newNode != null);
        return newNode;
    }

    public static APT createLightCopy(APT apt) {
        assert (apt != null);
        assert (APTBuilderImpl.isRootNode(apt));
        APTBaseNode light = null;
        switch (apt.getType()) {
            case 2: {
                break;
            }
            case 5: {
                light = new APTDefineNode((APTDefineNode)apt);
                break;
            }
            case 6: {
                light = new APTUndefineNode((APTUndefineNode)apt);
                break;
            }
            case 7: {
                light = new APTIfdefNode((APTIfdefNode)apt);
                break;
            }
            case 8: {
                light = new APTIfndefNode((APTIfndefNode)apt);
                break;
            }
            case 9: {
                light = new APTIfNode((APTIfNode)apt);
                break;
            }
            case 10: {
                light = new APTElifNode((APTElifNode)apt);
                break;
            }
            case 11: {
                light = new APTElseNode((APTElseNode)apt);
                break;
            }
            case 12: {
                light = new APTEndifNode((APTEndifNode)apt);
                break;
            }
            case 3: {
                light = new APTIncludeNode((APTIncludeNode)apt);
                break;
            }
            case 4: {
                light = new APTIncludeNextNode((APTIncludeNextNode)apt);
                break;
            }
            case 15: {
                light = new APTErrorNode((APTErrorNode)apt);
                break;
            }
            case 13: {
                light = new APTPragmaNode((APTPragmaNode)apt);
                break;
            }
            case 1: {
                light = new APTFileNode((APTFileNode)apt);
                break;
            }
        }
        return light;
    }

    private static boolean isRootNode(APT apt) {
        switch (apt.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static APT nextRoot(APT apt) {
        for (APT node = apt; node != null; node = node.getNextSibling()) {
            if (!APTBuilderImpl.isRootNode(node)) continue;
            return node;
        }
        return null;
    }

    private static final class Pair {
        final APTBaseNode active;
        APTBaseNode lastChild;

        Pair(APTBaseNode activeNode) {
            this.active = activeNode;
        }

        void addChild(APTBaseNode newChild) {
            if (this.lastChild == null) {
                this.active.setFirstChild(newChild);
            } else {
                this.lastChild.setNextSibling(newChild);
            }
            this.lastChild = newChild;
        }

        public String toString() {
            return "active:" + this.active + " lastChild:" + this.lastChild;
        }
    }
}

