/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;

public class DetectPanel
extends JPanel {
    private static final int COLS = 30;
    private static final RequestProcessor RP = new RequestProcessor(DetectPanel.class.getName(), 1, false, false);
    private NewJ2SEPlatform primaryPlatform;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String FILE = "file";
    private static final String INNER_SEPARATOR = "!/";
    private static final String PATH_SEPARATOR = ";";
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField javadoc;
    private JTextField jdkName;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField sources;

    public DetectPanel(NewJ2SEPlatform primaryPlatform) {
        this.initComponents();
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.primaryPlatform = primaryPlatform;
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DetectPanel.this.cs.fireChange();
            }
        };
        this.jdkName.getDocument().addDocumentListener(docListener);
        this.javadoc.getDocument().addDocumentListener(docListener);
        this.sources.getDocument().addDocumentListener(docListener);
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.javadoc = new JTextField();
        this.sources = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_JavaDoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.javadoc.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformJavadoc"));
        this.sources.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sources, gridBagConstraints);
        this.sources.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseSources"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectSources(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseJavadoc"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetectPanel.this.selectJavadoc(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.progressLabel.setLabelFor(this.progressPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seplatform/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)bundle.getString("TXT_PlatfromDetectProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
    }

    private void selectJavadoc(ActionEvent evt) {
        String newValue = this.browse(this.javadoc.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"));
        if (newValue != null) {
            this.javadoc.setText(newValue);
        }
    }

    private void selectSources(ActionEvent evt) {
        String newValue = this.browse(this.sources.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"));
        if (newValue != null) {
            this.sources.setText(newValue);
        }
    }

    public final synchronized void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public final synchronized void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public String getPlatformName() {
        return this.jdkName.getText().trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<? extends PathResourceImplementation> getSources(boolean dieOnError) {
        String val = this.sources.getText();
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        if (val.trim().length() <= 0) return result;
        File f = new File(val);
        if (f.exists()) {
            try {
                URL url = f.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)url)) {
                    FileObject fo = URLMapper.findFileObject((URL)(url = FileUtil.getArchiveRoot((URL)url)));
                    if (fo != null && (fo = fo.getFileObject("src")) != null) {
                        url = fo.getURL();
                    }
                    result.add(ClassPathSupport.createResource((URL)url));
                    return result;
                }
                result.add(ClassPathSupport.createResource((URL)url));
                return result;
            }
            catch (IllegalArgumentException mue) {
                if (!dieOnError) return result;
                throw new IllegalStateException();
            }
            catch (MalformedURLException mue) {
                if (!dieOnError) return result;
                throw new IllegalStateException();
            }
            catch (FileStateInvalidException e) {
                if (!dieOnError) return result;
                throw new IllegalStateException();
            }
        } else {
            if (!dieOnError) return result;
            throw new IllegalStateException();
        }
    }

    void setSources(String sources) {
        this.sources.setText(sources == null ? "" : sources);
    }

    List<URL> getJavadoc(boolean dieOnError) {
        String val = this.javadoc.getText();
        ArrayList<URL> result = new ArrayList<URL>();
        StringTokenizer tk = new StringTokenizer(val, PATH_SEPARATOR);
        while (tk.hasMoreTokens()) {
            try {
                String token = tk.nextToken().trim();
                if (token.startsWith(HTTP) || token.startsWith(HTTPS)) {
                    result.add(new URI(token).toURL());
                    continue;
                }
                int index = token.lastIndexOf(INNER_SEPARATOR);
                if (index > 0) {
                    String outherPath = token.substring(0, index);
                    String innerPath = index + 2 == token.length() ? "" : token.substring(index + 2);
                    File f = new File(outherPath);
                    if (f.exists()) {
                        result.add(new URL(FileUtil.getArchiveRoot((URL)f.toURI().toURL()).toExternalForm() + innerPath));
                        continue;
                    }
                    if (!dieOnError) continue;
                    throw new IllegalStateException();
                }
                File f = new File(token);
                URL url = FileUtil.urlForArchiveOrDir((File)f);
                if (url != null) {
                    result.add(url);
                    continue;
                }
                if (!dieOnError) continue;
                throw new IllegalStateException();
            }
            catch (MalformedURLException e) {
                if (!dieOnError) continue;
                throw new IllegalStateException();
            }
            catch (URISyntaxException e) {
                if (!dieOnError) continue;
                throw new IllegalStateException();
            }
        }
        return result;
    }

    void setJavadoc(List<URL> jdoc) {
        StringBuilder result = new StringBuilder();
        for (URL jdocRoot : jdoc) {
            try {
                String userName;
                String relative;
                String extUrl = jdocRoot.toExternalForm();
                URL url = FileUtil.getArchiveFile((URL)jdocRoot);
                if (url == null) {
                    url = jdocRoot;
                    relative = "";
                } else {
                    int index = extUrl.lastIndexOf(INNER_SEPARATOR);
                    relative = index < 0 ? "" : extUrl.substring(index);
                }
                String protocol = url.getProtocol();
                if (FILE.equals(protocol)) {
                    userName = new File(url.toURI()).getAbsolutePath() + relative;
                } else {
                    if (!HTTP.equals(protocol) && !HTTPS.equals(protocol)) continue;
                    userName = extUrl;
                }
                if (result.length() > 0) {
                    result.append(PATH_SEPARATOR);
                }
                result.append(userName);
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.javadoc.setText(result.toString());
    }

    private void updatePlatformName(@NonNull NewJ2SEPlatform platform) {
        assert (platform != null);
        assert (SwingUtilities.isEventDispatchThread());
        Map m = platform.getSystemProperties();
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(DetectPanel.getInitialName(m));
            this.jdkName.selectAll();
        }
    }

    private static String getInitialName(Map<String, String> m) {
        String vmVersion = m.get("java.specification.version");
        StringBuilder result = new StringBuilder(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_Java"));
        if (vmVersion != null) {
            result.append(vmVersion);
        }
        return result.toString();
    }

    private String browse(String oldValue, String title) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        if (Utilities.isMac()) {
            chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
        }
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists() && f.canRead() && (f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar"));
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
            }
        });
        File f = new File(oldValue);
        chooser.setSelectedFile(f);
        chooser.setDialogTitle(title);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    TaskListener,
    ChangeListener {
        private DetectPanel component;
        private RequestProcessor.Task task;
        private final J2SEWizardIterator iterator;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean detected;
        private boolean valid;
        private boolean firstPass = true;
        private WizardDescriptor wiz;
        private ProgressHandle progressHandle;

        WizardPanel(J2SEWizardIterator iterator) {
            this.iterator = iterator;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public Component getComponent() {
            if (this.component == null) {
                final NewJ2SEPlatform primaryPlatform = this.iterator.getPlatform();
                final NewJ2SEPlatform secondaryPlatform = this.iterator.getSecondaryPlatform();
                this.component = new DetectPanel(primaryPlatform);
                this.component.addChangeListener(this);
                this.task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        primaryPlatform.run();
                        if (secondaryPlatform != null) {
                            secondaryPlatform.run();
                        }
                    }
                });
                this.task.addTaskListener((TaskListener)this);
            }
            return this.component;
        }

        void setValid(boolean v) {
            if (v == this.valid) {
                return;
            }
            this.valid = v;
            this.cs.fireChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DetectPanel.class);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(WizardDescriptor settings) {
            this.wiz = settings;
            NewJ2SEPlatform platform = this.iterator.getPlatform();
            String srcPath = null;
            ClassPath src = platform.getSourceFolders();
            if (src.entries().size() > 0) {
                URL folderRoot = ((ClassPath.Entry)src.entries().get(0)).getURL();
                if ("jar".equals(folderRoot.getProtocol())) {
                    folderRoot = FileUtil.getArchiveFile((URL)folderRoot);
                }
                srcPath = new File(URI.create(folderRoot.toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                for (FileObject folder : platform.getInstallFolders()) {
                    File base = FileUtil.toFile((FileObject)folder);
                    if (base == null) continue;
                    File f = new File(base, "src.zip");
                    if (f.canRead()) {
                        srcPath = f.getAbsolutePath();
                        continue;
                    }
                    f = new File(base, "src.jar");
                    if (!f.canRead()) continue;
                    srcPath = f.getAbsolutePath();
                }
                this.firstPass = false;
            }
            this.component.setSources(srcPath);
            this.component.progressPanel.setVisible(true);
            this.component.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_PlatfromDetectProgress"));
            this.component.progressPanel.removeAll();
            this.component.progressPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 2;
            c.weightx = 1.0;
            JComponent pc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.component.progressPanel.getLayout()).setConstraints(pc, c);
            this.component.progressPanel.add(pc);
            this.progressHandle.start();
            this.task.schedule(0);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public void storeSettings(WizardDescriptor settings) {
            if (this.isValid()) {
                String name = this.component.getPlatformName();
                List<? extends PathResourceImplementation> src = this.component.getSources(false);
                List<URL> jdoc = this.component.getJavadoc(false);
                NewJ2SEPlatform platform = this.iterator.getPlatform();
                platform.setDisplayName(name);
                platform.setAntName(WizardPanel.createAntName(name));
                platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                if (!jdoc.isEmpty()) {
                    platform.setJavadocFolders(jdoc);
                }
                if ((platform = this.iterator.getSecondaryPlatform()) != null) {
                    name = NbBundle.getMessage(DetectPanel.class, (String)"FMT_64BIT", (Object)name);
                    platform.setDisplayName(name);
                    platform.setAntName(WizardPanel.createAntName(name));
                    platform.setSourceFolders(ClassPathSupport.createClassPath(src));
                    if (!jdoc.isEmpty()) {
                        platform.setJavadocFolders(jdoc);
                    }
                }
            }
        }

        public void taskFinished(Task task) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewJ2SEPlatform platform = WizardPanel.this.iterator.getPlatform();
                    List<URL> jdoc = platform.getJavadocFolders();
                    if (jdoc.isEmpty()) {
                        jdoc = J2SEPlatformImpl.defaultJavadoc(platform);
                    }
                    WizardPanel.this.component.setJavadoc(jdoc);
                    WizardPanel.this.component.updatePlatformName(platform);
                    assert (WizardPanel.this.progressHandle != null);
                    WizardPanel.this.progressHandle.finish();
                    WizardPanel.this.component.progressPanel.setVisible(false);
                    WizardPanel.this.component.progressLabel.setVisible(false);
                    WizardPanel.this.detected = WizardPanel.this.iterator.getPlatform().isValid();
                    WizardPanel.this.checkValid();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.checkValid();
        }

        private void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            String name = this.component.getPlatformName();
            boolean vld = this.detected;
            if (!vld) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
            }
            if (vld && name.length() == 0) {
                vld = false;
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
            }
            if (vld) {
                for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                    if (!name.equals(platform.getDisplayName())) continue;
                    vld = false;
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                    break;
                }
            }
            if (vld) {
                try {
                    this.component.getSources(true);
                }
                catch (IllegalStateException ise) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_Sources"));
                    vld = false;
                }
            }
            if (vld) {
                try {
                    this.component.getJavadoc(true);
                }
                catch (IllegalStateException ise) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_Javadoc"));
                    vld = false;
                }
            }
            this.setValid(vld);
        }

        private static String createAntName(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException();
            }
            String antName = PropertyUtils.getUsablePropertyName((String)name);
            if (WizardPanel.platformExists(antName)) {
                String baseName = antName;
                int index = 1;
                antName = baseName + Integer.toString(index);
                while (WizardPanel.platformExists(antName)) {
                    antName = baseName + Integer.toString(++index);
                }
            }
            return antName;
        }

        private static boolean platformExists(String antName) {
            JavaPlatformManager mgr = JavaPlatformManager.getDefault();
            JavaPlatform[] platforms = mgr.getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                String val;
                if (!(platforms[i] instanceof J2SEPlatformImpl) || !antName.equals(val = ((J2SEPlatformImpl)platforms[i]).getAntName())) continue;
                return true;
            }
            return false;
        }
    }
}

