/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class DefaultClassPathProvider
implements ClassPathProvider {
    private static final String PACKAGE = "package";
    private static final String JAVA_EXT = "java";
    private static final String CLASS_EXT = "class";
    private static final int TYPE_JAVA = 1;
    private static final int TYPE_CLASS = 2;
    private static final RequestProcessor RP = new RequestProcessor(DefaultClassPathProvider.class);
    private static final Logger LOG = Logger.getLogger(DefaultClassPathProvider.class.getName());
    private Map<FileObject, WeakReference<FileObject>> sourceRootsCache = new WeakHashMap<FileObject, WeakReference<FileObject>>();
    private Map<FileObject, WeakReference<ClassPath>> sourceClasPathsCache = new WeakHashMap<FileObject, WeakReference<ClassPath>>();
    private Reference<ClassPath> compiledClassPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ClassPath findClassPath(FileObject file, String type) {
        Object defaultPlatform;
        if (!file.isValid()) {
            return null;
        }
        if (file.isVirtual()) {
            return null;
        }
        try {
            URL externalURL = URLMapper.findURL((FileObject)file, (int)1);
            if (externalURL == null || !externalURL.equals(file.getURL())) {
                return null;
            }
        }
        catch (FileStateInvalidException fsi) {
            return null;
        }
        if (JAVA_EXT.equalsIgnoreCase(file.getExt()) || file.isFolder()) {
            if ("classpath/boot".equals(type)) {
                defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
                if (defaultPlatform != null) {
                    return defaultPlatform.getBootstrapLibraries();
                }
            } else {
                if ("classpath/compile".equals(type)) {
                    defaultPlatform = this;
                    synchronized (defaultPlatform) {
                        ClassPath cp = null;
                        if (this.compiledClassPath == null || (cp = this.compiledClassPath.get()) == null) {
                            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl());
                            this.compiledClassPath = new WeakReference<ClassPath>(cp);
                        }
                        return cp;
                    }
                }
                if ("classpath/source".equals(type)) {
                    return null;
                }
            }
        } else if (CLASS_EXT.equals(file.getExt())) {
            if ("classpath/boot".equals(type)) {
                defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
                if (defaultPlatform != null) {
                    return defaultPlatform.getBootstrapLibraries();
                }
            } else if ("classpath/execute".equals(type)) {
                ClassPath cp = null;
                Reference foRef = this.sourceRootsCache.get(file);
                FileObject execRoot = null;
                if (foRef == null || (execRoot = (FileObject)foRef.get()) == null) {
                    execRoot = DefaultClassPathProvider.getRootForFile(file, 2);
                    if (execRoot == null || !execRoot.isFolder()) {
                        return null;
                    }
                    this.sourceRootsCache.put(file, new WeakReference<FileObject>(execRoot));
                }
                if (!execRoot.isValid()) {
                    this.sourceClasPathsCache.remove(execRoot);
                } else {
                    try {
                        Reference cpRef = this.sourceClasPathsCache.get(execRoot);
                        if (cpRef == null || (cp = (ClassPath)cpRef.get()) == null) {
                            URL url = execRoot.getURL();
                            if (!execRoot.isValid()) {
                                return null;
                            }
                            cp = ClassPathSupport.createClassPath((URL[])new URL[]{url});
                            this.sourceClasPathsCache.put(execRoot, new WeakReference<ClassPath>(cp));
                        }
                        return cp;
                    }
                    catch (FileStateInvalidException e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private static FileObject getRootForFile(FileObject fo, int type) {
        String pkg = type == 1 ? DefaultClassPathProvider.findJavaPackage(fo) : DefaultClassPathProvider.findClassPackage(fo);
        FileObject packageRoot = null;
        if (pkg == null) {
            packageRoot = fo.getParent();
        } else {
            ArrayList<String> elements = new ArrayList<String>();
            StringTokenizer tk = new StringTokenizer(pkg, ".");
            while (tk.hasMoreTokens()) {
                elements.add(tk.nextToken());
            }
            FileObject tmp = fo;
            for (int i = elements.size() - 1; i >= 0; --i) {
                String name = (String)elements.get(i);
                if ((tmp = tmp.getParent()) != null && tmp.getName().equals(name)) continue;
                tmp = fo;
                break;
            }
            packageRoot = tmp.getParent();
        }
        return packageRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String findClassPackage(FileObject file) {
        block7: {
            String string;
            InputStream in = file.getInputStream();
            try {
                ClassFile cf = new ClassFile(in, false);
                ClassName cn = cf.getName();
                string = cn.getPackage();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (FileNotFoundException fnf) {
                    break block7;
                }
                catch (InvalidClassFormatException icf) {
                    Logger.getLogger(DefaultClassPathProvider.class.getName()).log(Level.WARNING, "{0}: {1}", new Object[]{file.getPath(), icf.getLocalizedMessage()});
                    break block7;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            in.close();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findJavaPackage(FileObject file) {
        String pkg = "";
        boolean packageKnown = false;
        BufferedReader rd = null;
        try {
            rd = new BufferedReader(new SourceReader(file.getInputStream()));
            rd.mark(2);
            char[] cbuf = new char[2];
            rd.read(cbuf, 0, 2);
            if (cbuf[0] == '\u00ff' && cbuf[1] == '\u00fe') {
                rd.close();
                rd = new BufferedReader(new SourceReader(file.getInputStream(), "Unicode"));
            } else {
                rd.reset();
            }
            while (!packageKnown) {
                String line = rd.readLine();
                if (line == null) {
                    packageKnown = true;
                    String string = pkg;
                    return string;
                }
                int pckgPos = line.indexOf(PACKAGE);
                if (pckgPos == -1) continue;
                StringTokenizer tok = new StringTokenizer(line, " \t;");
                boolean gotPackage = false;
                while (tok.hasMoreTokens()) {
                    String theTok = tok.nextToken();
                    if (gotPackage) {
                        StringTokenizer ptok = new StringTokenizer(theTok, ".");
                        boolean ok = ptok.hasMoreTokens();
                        block26: while (ptok.hasMoreTokens()) {
                            String component = ptok.nextToken();
                            if (component.length() == 0) {
                                ok = false;
                                break;
                            }
                            if (!Character.isJavaIdentifierStart(component.charAt(0))) {
                                ok = false;
                                break;
                            }
                            for (int pos = 1; pos < component.length(); ++pos) {
                                if (Character.isJavaIdentifierPart(component.charAt(pos))) continue;
                                ok = false;
                                continue block26;
                            }
                        }
                        if (ok) {
                            pkg = theTok;
                            packageKnown = true;
                            String string = pkg;
                            return string;
                        }
                        gotPackage = false;
                        continue;
                    }
                    if (theTok.equals(PACKAGE)) {
                        gotPackage = true;
                        continue;
                    }
                    if (!theTok.equals("{")) continue;
                    packageKnown = true;
                    String string = pkg;
                    return string;
                }
            }
        }
        catch (FileNotFoundException fnf) {
        }
        catch (IOException e1) {
            ErrorManager.getDefault().notify((Throwable)e1);
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e2) {
                ErrorManager.getDefault().notify((Throwable)e2);
            }
        }
        return null;
    }

    private static class CompileClassPathImpl
    implements ClassPathImplementation,
    GlobalPathRegistryListener {
        private List<? extends PathResourceImplementation> cachedCompiledClassPath;
        private final PropertyChangeSupport support;
        private final ThreadLocal<Boolean> active = new ThreadLocal();
        private long eventId;
        private volatile RequestProcessor.Task task;
        private boolean listening;

        public CompileClassPathImpl() {
            this.support = new PropertyChangeSupport(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            long myEventId;
            GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
            CompileClassPathImpl compileClassPathImpl = this;
            synchronized (compileClassPathImpl) {
                if (this.cachedCompiledClassPath != null) {
                    return this.cachedCompiledClassPath;
                }
                myEventId = this.eventId;
                if (!this.listening) {
                    regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
                    this.listening = true;
                }
            }
            Boolean _active = this.active.get();
            if (_active == Boolean.TRUE) {
                throw new RecursionException();
            }
            this.active.set(true);
            ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
            try {
                HashSet<URL> roots = new HashSet<URL>();
                Set paths = regs.getPaths("classpath/compile");
                for (ClassPath cp : paths) {
                    try {
                        for (ClassPath.Entry entry : cp.entries()) {
                            roots.add(entry.getURL());
                        }
                    }
                    catch (RecursionException e) {
                    }
                }
                Set sources = regs.getPaths("classpath/source");
                HashSet<URL> sroots = new HashSet<URL>();
                for (ClassPath cp : sources) {
                    try {
                        for (ClassPath.Entry entry : cp.entries()) {
                            sroots.add(entry.getURL());
                        }
                    }
                    catch (RecursionException e) {
                    }
                }
                Set exec = regs.getPaths("classpath/execute");
                for (ClassPath cp : exec) {
                    try {
                        for (ClassPath.Entry entry : cp.entries()) {
                            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                            FileObject[] fos = result.getRoots();
                            for (int i = 0; i < fos.length; ++i) {
                                if (fos[i] == null) {
                                    ErrorManager.getDefault().notify((Throwable)new NullPointerException(result + " returns null root for " + entry.getURL()));
                                    continue;
                                }
                                try {
                                    if (!sroots.contains(fos[i].getURL())) continue;
                                    roots.add(entry.getURL());
                                    continue;
                                }
                                catch (FileStateInvalidException e) {
                                    ErrorManager.getDefault().notify((Throwable)e);
                                }
                            }
                        }
                    }
                    catch (RecursionException e) {
                    }
                }
                Iterator it = roots.iterator();
                while (it.hasNext()) {
                    l.add(ClassPathSupport.createResource((URL)((URL)it.next())));
                }
            }
            finally {
                this.active.remove();
            }
            CompileClassPathImpl compileClassPathImpl2 = this;
            synchronized (compileClassPathImpl2) {
                if (myEventId == this.eventId) {
                    this.cachedCompiledClassPath = Collections.unmodifiableList(l);
                    return this.cachedCompiledClassPath;
                }
                return Collections.unmodifiableList(l);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(GlobalPathRegistryEvent event) {
            CompileClassPathImpl compileClassPathImpl = this;
            synchronized (compileClassPathImpl) {
                if ("classpath/compile".equals(event.getId()) || "classpath/source".equals(event.getId())) {
                    this.cachedCompiledClassPath = null;
                    ++this.eventId;
                }
            }
            this.fire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(GlobalPathRegistryEvent event) {
            CompileClassPathImpl compileClassPathImpl = this;
            synchronized (compileClassPathImpl) {
                if ("classpath/compile".equals(event.getId()) || "classpath/source".equals(event.getId())) {
                    this.cachedCompiledClassPath = null;
                    ++this.eventId;
                }
            }
            this.fire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fire() {
            LOG.log(Level.FINEST, "Request to fire an event");
            CompileClassPathImpl compileClassPathImpl = this;
            synchronized (compileClassPathImpl) {
                if (this.task == null) {
                    LOG.log(Level.FINEST, "Scheduled firer task");
                    final Future becomeProjects = OpenProjects.getDefault().openProjects();
                    this.task = RP.create(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                becomeProjects.get();
                                CompileClassPathImpl.this.support.firePropertyChange("resources", null, null);
                                LOG.log(Level.FINEST, "Fired an event");
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            finally {
                                CompileClassPathImpl.this.task = null;
                            }
                        }
                    });
                    this.task.schedule(0);
                }
            }
        }
    }

    private static class RecursionException
    extends IllegalStateException {
        private RecursionException() {
        }
    }

    public static class SourceReader
    extends InputStreamReader {
        private int preRead = -1;
        private boolean inString = false;
        private boolean backslashLast = false;
        private boolean separatorLast = false;
        private static final char[] separators = new char[]{'.'};
        private static final char[] whitespaces = new char[]{' ', '\t', '\r', '\n'};

        public SourceReader(InputStream in) {
            super(in);
        }

        public SourceReader(InputStream in, String encoding) throws UnsupportedEncodingException {
            super(in, encoding);
        }

        @Override
        public int read(char[] data, int pos, int len) throws IOException {
            int numRead = 0;
            char[] onechar = new char[1];
            while (numRead < len) {
                int c;
                if (this.preRead != -1) {
                    c = this.preRead;
                    this.preRead = -1;
                } else {
                    c = super.read(onechar, 0, 1);
                    if (c == -1) {
                        return numRead > 0 ? numRead : -1;
                    }
                    c = onechar[0];
                }
                if (c == 47 && !this.inString) {
                    this.preRead = super.read(onechar, 0, 1);
                    if (this.preRead == 1) {
                        this.preRead = onechar[0];
                    }
                    if (this.preRead != 42 && this.preRead != 47) {
                        data[pos++] = (char)c;
                        ++numRead;
                        if (this.preRead != -1) continue;
                        return numRead;
                    }
                    if (this.preRead == 42) {
                        this.preRead = -1;
                        do {
                            if ((c = this.moveToChar(42)) != 0) continue;
                            c = super.read(onechar, 0, 1);
                            if (c == 1) {
                                c = onechar[0];
                            }
                            if (c != 42) continue;
                            this.preRead = c;
                        } while (c != 47 && c != -1);
                    } else {
                        this.preRead = -1;
                        c = this.moveToChar(10);
                        if (c == 0) {
                            this.preRead = 10;
                        }
                    }
                    if (c != -1) continue;
                    return -1;
                }
                if (!this.inString) {
                    block24: {
                        if (SourceReader.isWhitespace(c)) {
                            do {
                                this.preRead = super.read(onechar, 0, 1);
                                if (this.preRead == -1) {
                                    return numRead > 0 ? numRead : -1;
                                }
                                this.preRead = onechar[0];
                                if (!SourceReader.isSeparator(this.preRead)) continue;
                                c = this.preRead;
                                this.preRead = -1;
                                break block24;
                            } while (SourceReader.isWhitespace(this.preRead));
                            if (this.separatorLast) {
                                c = this.preRead;
                                this.preRead = -1;
                            }
                        }
                    }
                    if (c == 34 || c == 39) {
                        this.inString = true;
                        this.separatorLast = false;
                    } else {
                        this.separatorLast = SourceReader.isSeparator(c);
                    }
                } else if (c == 34 || c == 39) {
                    if (!this.backslashLast) {
                        this.inString = false;
                    } else {
                        this.backslashLast = false;
                    }
                } else {
                    this.backslashLast = c == 92;
                }
                data[pos++] = (char)c;
                ++numRead;
            }
            return numRead;
        }

        private int moveToChar(int c) throws IOException {
            int cc;
            char[] onechar = new char[1];
            if (this.preRead != -1) {
                cc = this.preRead;
                this.preRead = -1;
            } else {
                cc = super.read(onechar, 0, 1);
                if (cc == 1) {
                    cc = onechar[0];
                }
            }
            while (cc != -1 && cc != c) {
                cc = super.read(onechar, 0, 1);
                if (cc != 1) continue;
                cc = onechar[0];
            }
            return cc == -1 ? -1 : 0;
        }

        private static boolean isSeparator(int c) {
            for (int i = 0; i < separators.length; ++i) {
                if (c != separators[i]) continue;
                return true;
            }
            return false;
        }

        private static boolean isWhitespace(int c) {
            for (int i = 0; i < whitespaces.length; ++i) {
                if (c != whitespaces[i]) continue;
                return true;
            }
            return false;
        }
    }
}

