/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.specs.support.bridge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.javaee.specs.support.spi.JaxRsStackSupportImplementation;
import org.openide.filesystems.FileObject;

public class IdeJaxRsSupportImpl
implements JaxRsStackSupportImplementation {
    private static final String RESTAPI_LIBRARY = "restapi";
    private static final String SWDP_LIBRARY = "restlib";

    @Override
    public boolean addJsr311Api(Project project) {
        Library restapiLibrary = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY);
        if (restapiLibrary == null) {
            return false;
        }
        return this.addSwdpLibrary(project, restapiLibrary);
    }

    @Override
    public boolean extendsJerseyProjectClasspath(Project project) {
        Library swdpLibrary = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (swdpLibrary == null) {
            return false;
        }
        return this.addSwdpLibrary(project, swdpLibrary);
    }

    private boolean addSwdpLibrary(Project project, Library lib) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups == null || sourceGroups.length < 1) {
            return false;
        }
        FileObject sourceRoot = sourceGroups[0].getRootFolder();
        try {
            ProjectClassPathModifier.addLibraries((Library[])new Library[]{lib}, (FileObject)sourceRoot, (String)"classpath/compile");
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void removeJaxRsLibraries(Project project) {
        String[] classPathTypes;
        Library restapiLibrary;
        ArrayList<Library> libraries = new ArrayList<Library>(2);
        Library swdpLibrary = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (swdpLibrary != null) {
            libraries.add(swdpLibrary);
        }
        if ((restapiLibrary = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY)) == null) {
            libraries.add(restapiLibrary);
        }
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject sourceRoot = sgs[0].getRootFolder();
        for (String type : classPathTypes = new String[]{"classpath/compile", "classpath/execute"}) {
            try {
                ProjectClassPathModifier.removeLibraries((Library[])libraries.toArray(new Library[libraries.size()]), (FileObject)sourceRoot, (String)type);
            }
            catch (UnsupportedOperationException ex) {
                Logger.getLogger(IdeJaxRsSupportImpl.class.getName()).log(Level.INFO, null, ex);
            }
            catch (IOException e) {
                Logger.getLogger(IdeJaxRsSupportImpl.class.getName()).log(Level.INFO, null, e);
            }
        }
    }
}

