/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.jpacontroller;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.PersistenceClientEntitySelection;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerSetupPanel;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.ProgressReporter;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.ProgressReporterDelegate;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JpaControllerIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private PersistenceUnitWizardDescriptor puPanel;
    private static final String[] EXCEPTION_CLASS_NAMES = new String[]{"IllegalOrphanException", "NonexistentEntityException", "PreexistingEntityException", "RollbackFailureException"};
    public static final String EXCEPTION_FOLDER_NAME = "exceptions";
    private static String RESOURCE_FOLDER = "org/netbeans/modules/j2ee/persistence/wizard/jpacontroller/resources/";

    public Set instantiate(TemplateWizard wizard) throws IOException {
        final List entities = (List)wizard.getProperty("EntityClass");
        final Project project = Templates.getProject((WizardDescriptor)wizard);
        final FileObject jpaControllerPackageFileObject = Templates.getTargetFolder((WizardDescriptor)wizard);
        final String jpaControllerPackage = (String)wizard.getProperty("JpaControllerPackage");
        boolean createPersistenceUnit = (Boolean)wizard.getProperty("CreatePersistenceUnit");
        if (createPersistenceUnit) {
            PersistenceUnit punit = Util.buildPersistenceUnitUsingData(project, this.puPanel.getPersistenceUnitName(), this.puPanel.getPersistenceConnection() != null ? this.puPanel.getPersistenceConnection().getName() : this.puPanel.getDatasource(), PersistenceUnitWizardPanel.TableGeneration.NONE, this.puPanel.getSelectedProvider());
            ProviderUtil.setTableGeneration(punit, this.puPanel.getTableGeneration(), this.puPanel.getSelectedProvider());
            if (punit != null) {
                Util.addPersistenceUnitToProject(project, punit);
            }
        }
        final String title = NbBundle.getMessage(JpaControllerIterator.class, (String)"TITLE_Progress_Jpa_Controller");
        final ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)title);
        final AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)title, (ProgressContributor[])new ProgressContributor[]{progressContributor}, null, null);
        final ProgressPanel progressPanel = new ProgressPanel();
        final JComponent progressComponent = AggregateProgressFactory.createProgressComponent((AggregateProgressHandle)handle);
        final ProgressReporterDelegate reporter = new ProgressReporterDelegate(progressContributor, progressPanel);
        final Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    handle.start();
                    int progressStepCount = JpaControllerIterator.getProgressStepCount(entities.size());
                    progressContributor.start(progressStepCount);
                    JpaControllerIterator.generateJpaControllers(reporter, entities, project, jpaControllerPackage, jpaControllerPackageFileObject, null, true);
                    progressContributor.progress(progressStepCount);
                }
                catch (IOException ioe) {
                    try {
                        Logger.getLogger(JpaControllerIterator.class.getName()).log(Level.INFO, null, ioe);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getLocalizedMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    catch (Throwable throwable) {
                        progressContributor.finish();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressPanel.close();
                            }
                        });
                        handle.finish();
                        throw throwable;
                    }
                    progressContributor.finish();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    handle.finish();
                }
                progressContributor.finish();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                handle.finish();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;

            @Override
            public void run() {
                if (!this.first) {
                    RequestProcessor.getDefault().post(r);
                    progressPanel.open(progressComponent, title);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        return Collections.singleton(DataFolder.findFolder((FileObject)jpaControllerPackageFileObject));
    }

    public static int getProgressStepCount(int entityCount) {
        return EXCEPTION_CLASS_NAMES.length + entityCount + 2;
    }

    public static FileObject[] generateJpaControllers(ProgressReporter reporter, List<String> entities, Project project, String jpaControllerPackage, FileObject jpaControllerPackageFileObject, JpaControllerUtil.EmbeddedPkSupport embeddedPkSupport, boolean evenIfExists) throws IOException {
        String entityClass;
        int i;
        int progressIndex = 0;
        String progressMsg = NbBundle.getMessage(JpaControllerIterator.class, (String)"MSG_Progress_Jpa_Exception_Pre");
        reporter.progress(progressMsg, progressIndex++);
        FileObject exceptionFolder = jpaControllerPackageFileObject.getFileObject(EXCEPTION_FOLDER_NAME);
        if (exceptionFolder == null) {
            exceptionFolder = FileUtil.createFolder((FileObject)jpaControllerPackageFileObject, (String)EXCEPTION_FOLDER_NAME);
        }
        String exceptionPackage = jpaControllerPackage == null || jpaControllerPackage.length() == 0 ? EXCEPTION_FOLDER_NAME : jpaControllerPackage + "." + EXCEPTION_FOLDER_NAME;
        int exceptionClassCount = Util.isContainerManaged(project) ? EXCEPTION_CLASS_NAMES.length : EXCEPTION_CLASS_NAMES.length - 1;
        for (int i2 = 0; i2 < exceptionClassCount; ++i2) {
            if (exceptionFolder.getFileObject(EXCEPTION_CLASS_NAMES[i2], "java") == null) {
                progressMsg = NbBundle.getMessage(JpaControllerIterator.class, (String)"MSG_Progress_Jpa_Now_Generating", (Object)(EXCEPTION_CLASS_NAMES[i2] + ".java"));
                reporter.progress(progressMsg, progressIndex++);
                String content = JpaControllerUtil.readResource(JpaControllerUtil.class.getClassLoader().getResourceAsStream(RESOURCE_FOLDER + EXCEPTION_CLASS_NAMES[i2] + ".java.txt"), "UTF-8");
                content = content.replaceAll("__PACKAGE__", exceptionPackage);
                FileObject target = FileUtil.createData((FileObject)exceptionFolder, (String)(EXCEPTION_CLASS_NAMES[i2] + ".java"));
                String projectEncoding = JpaControllerUtil.getProjectEncodingAsString(project, target);
                JpaControllerUtil.createFile(target, content, projectEncoding);
                continue;
            }
            reporter.progress(null, progressIndex++);
        }
        progressMsg = NbBundle.getMessage(JpaControllerIterator.class, (String)"MSG_Progress_Jpa_Controller_Pre");
        reporter.progress(progressMsg, progressIndex++);
        int[] nameAttemptIndices = null;
        if (evenIfExists) {
            nameAttemptIndices = new int[entities.size()];
        }
        FileObject[] controllerFileObjects = new FileObject[entities.size()];
        for (i = 0; i < controllerFileObjects.length; ++i) {
            String simpleControllerNameBase;
            entityClass = entities.get(i);
            String simpleClassName = JpaControllerUtil.simpleClassName(entityClass);
            String simpleControllerName = simpleControllerNameBase = simpleClassName + "JpaController";
            if (evenIfExists) {
                while (jpaControllerPackageFileObject.getFileObject(simpleControllerName, "java") != null && nameAttemptIndices[i] < 1000) {
                    int n = i;
                    int n2 = nameAttemptIndices[n] + 1;
                    nameAttemptIndices[n] = n2;
                    simpleControllerName = simpleControllerNameBase + n2;
                }
            }
            if (jpaControllerPackageFileObject.getFileObject(simpleControllerName, "java") != null) continue;
            controllerFileObjects[i] = GenerationUtils.createClass((FileObject)jpaControllerPackageFileObject, (String)simpleControllerName, null);
        }
        if (embeddedPkSupport == null) {
            embeddedPkSupport = new JpaControllerUtil.EmbeddedPkSupport();
        }
        for (i = 0; i < controllerFileObjects.length; ++i) {
            if (controllerFileObjects[i] == null) {
                reporter.progress(null, progressIndex++);
                continue;
            }
            entityClass = entities.get(i);
            String controller = (jpaControllerPackage == null || jpaControllerPackage.length() == 0 ? "" : jpaControllerPackage + ".") + controllerFileObjects[i].getName();
            progressMsg = NbBundle.getMessage(JpaControllerIterator.class, (String)"MSG_Progress_Jpa_Now_Generating", (Object)(controllerFileObjects[i].getName() + ".java"));
            reporter.progress(progressMsg, progressIndex++);
            JpaControllerGenerator.generateJpaController(project, entityClass, controller, exceptionPackage, jpaControllerPackageFileObject, controllerFileObjects[i], embeddedPkSupport);
        }
        PersistenceUtils.logUsage(JpaControllerIterator.class, "USG_PERSISTENCE_CONTROLLER_CREATED", new Integer[]{controllerFileObjects.length});
        return controllerFileObjects;
    }

    public void initialize(TemplateWizard wizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        ValidationPanel secondPanel = new ValidationPanel(new PersistenceClientEntitySelection(NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_EntityClasses"), new HelpCtx("org.netbeans.modules.j2ee.persistence.wizard.jpacontroller"), (WizardDescriptor)wizard));
        JpaControllerSetupPanel thirdPanel = new JpaControllerSetupPanel(project, (WizardDescriptor)wizard);
        String[] names = null;
        boolean noPuNeeded = true;
        try {
            noPuNeeded = ProviderUtil.persistenceExists(project) || !ProviderUtil.isValidServerInstanceOrNone(project);
        }
        catch (InvalidPersistenceXmlException ex) {
            Logger.getLogger(JpaControllerIterator.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + ex.getPath());
        }
        if (!noPuNeeded) {
            this.puPanel = new PersistenceUnitWizardDescriptor(project);
            this.panels = new WizardDescriptor.Panel[]{secondPanel, thirdPanel, this.puPanel};
            names = new String[]{NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_JpaControllerClasses"), NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_PersistenceUnitSetup")};
        } else {
            this.panels = new WizardDescriptor.Panel[]{secondPanel, thirdPanel};
            names = new String[]{NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_JpaControllerClasses")};
        }
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(JpaControllerIterator.class, (String)"Templates/Persistence/JpaControllersFromEntities"));
        Wizards.mergeSteps((WizardDescriptor)wizard, (WizardDescriptor.Panel[])this.panels, (String[])names);
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(JpaControllerIterator.class, (String)"LBL_WizardTitle_FromEntity");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private class ValidationPanel
    extends DelegatingWizardDescriptorPanel {
        private ValidationPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }
    }
}

