/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeVisitor;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeRepository;

public class ManagedTypeProvider
implements IManagedTypeProvider {
    private final Project project;
    private Map<String, IManagedType> managedTypes;
    private ITypeRepository typeRepository;

    public ManagedTypeProvider(Project project) {
        this.project = project;
    }

    public Iterable<IEntity> abstractSchemaTypes() {
        this.initializeManagedTypes();
        ArrayList<IEntity> abstractSchemaTypes = null;
        ManagedTypeVisitor visitor = new ManagedTypeVisitor();
        for (IManagedType managedType : this.managedTypes.values()) {
            managedType.accept((IManagedTypeVisitor)visitor);
        }
        abstractSchemaTypes = visitor.getEntities();
        return Collections.unmodifiableCollection(abstractSchemaTypes);
    }

    public IManagedType getManagedType(IType itype) {
        this.initializeManagedTypes();
        for (IManagedType mt : this.managedTypes.values()) {
            if (!mt.getType().equals(itype)) continue;
            return mt;
        }
        return null;
    }

    public IManagedType getManagedType(String name) {
        this.initializeManagedTypes();
        return this.managedTypes.get(name);
    }

    public IPlatform getPlatform() {
        return IPlatform.JAVA;
    }

    public ITypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new TypeRepository(this.project);
        }
        return this.typeRepository;
    }

    public IJPAVersion getVersion() {
        String version = PersistenceUtils.getJPAVersion(this.project);
        return IJPAVersion.value((String)version);
    }

    public Iterable<IManagedType> managedTypes() {
        this.initializeManagedTypes();
        return Collections.unmodifiableCollection(this.managedTypes.values());
    }

    private void initializeManagedTypes() {
        if (this.managedTypes == null) {
            this.managedTypes = new HashMap<String, IManagedType>();
        }
    }
}

