/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeDeclaration;

public class Constructor
implements IConstructor {
    private final ExecutableElement constructor;
    private final IType owner;

    public Constructor(IType owner, ExecutableElement constructor) {
        assert (constructor.getKind() == ElementKind.CONSTRUCTOR);
        this.constructor = constructor;
        this.owner = owner;
    }

    public ITypeDeclaration[] getParameterTypes() {
        ArrayList<TypeDeclaration> ret = new ArrayList<TypeDeclaration>();
        List<? extends VariableElement> params = this.constructor.getParameters();
        for (VariableElement variableElement : params) {
            ret.add(this.typeToTypeDeclaration(variableElement.asType()));
        }
        return ret.toArray(new ITypeDeclaration[0]);
    }

    private TypeDeclaration typeToTypeDeclaration(TypeMirror tMirror) {
        DeclaredType dType;
        List<? extends TypeMirror> parameters;
        int dimension = 0;
        TypeMirror aType = tMirror;
        ITypeDeclaration[] generics = null;
        if (tMirror.getKind() == TypeKind.ARRAY) {
            while (aType.getKind() == TypeKind.ARRAY) {
                ++dimension;
                aType = ((ArrayType)tMirror).getComponentType();
            }
        }
        if (aType.getKind() == TypeKind.DECLARED && (parameters = (dType = (DeclaredType)aType).getTypeArguments()) != null && parameters.size() > 0) {
            generics = new ITypeDeclaration[parameters.size()];
            int i = 0;
            for (TypeMirror typeMirror : parameters) {
                generics[i] = this.typeToTypeDeclaration(typeMirror);
                ++i;
            }
        }
        return new TypeDeclaration(this.owner, generics, dimension);
    }
}

