/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class DebuggerAction
extends AbstractAction {
    private Object action;
    private boolean nameInBundle;

    private DebuggerAction(Object action) {
        this(action, true);
    }

    private DebuggerAction(Object action, boolean nameInBundle) {
        this.action = action;
        this.nameInBundle = nameInBundle;
        new Listener(this);
        this.setEnabled(DebuggerAction.isEnabled(this.getAction()));
    }

    public Object getAction() {
        return this.action;
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name" && this.nameInBundle) {
            return NbBundle.getMessage(DebuggerAction.class, (String)((String)super.getValue(key)));
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        DebuggerAction.getActionsManager(this.action).postAction(this.action);
    }

    private static ActionsManager getCurrentEngineActionsManager() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            return engine.getActionsManager();
        }
        return null;
    }

    private static boolean isEnabled(Object action) {
        ActionsManager manager = DebuggerAction.getCurrentEngineActionsManager();
        if (manager != null && manager.isEnabled(action)) {
            return true;
        }
        return DebuggerManager.getDebuggerManager().getActionsManager().isEnabled(action);
    }

    private static ActionsManager getActionsManager(Object action) {
        ActionsManager manager = DebuggerAction.getCurrentEngineActionsManager();
        if (manager != null && manager.isEnabled(action)) {
            return manager;
        }
        return DebuggerManager.getDebuggerManager().getActionsManager();
    }

    public static DebuggerAction createContinueAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_CONTINUE);
        action.putValue("Name", "CTL_Continue_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Continue.gif");
        return action;
    }

    public static DebuggerAction createFixAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_FIX);
        action.putValue("Name", "CTL_Fix_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Fix.gif");
        return action;
    }

    public static DebuggerAction createKillAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_KILL);
        action.putValue("Name", "CTL_KillAction_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Kill.gif");
        action.setEnabled(false);
        return action;
    }

    public static DebuggerAction createMakeCalleeCurrentAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLEE_CURRENT);
        action.putValue("Name", "CTL_MakeCalleeCurrentAction_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/GoToCalledMethod.gif");
        return action;
    }

    public static DebuggerAction createMakeCallerCurrentAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
        action.putValue("Name", "CTL_MakeCallerCurrentAction_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/GoToCallingMethod.gif");
        return action;
    }

    public static DebuggerAction createPauseAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_PAUSE);
        action.putValue("Name", "CTL_Pause_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Pause.gif");
        return action;
    }

    public static DebuggerAction createPopTopmostCallAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_POP_TOPMOST_CALL);
        action.putValue("Name", "CTL_PopTopmostCallAction_name");
        return action;
    }

    public static DebuggerAction createRunIntoMethodAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_RUN_INTO_METHOD);
        action.putValue("Name", "CTL_Run_into_method_action_name");
        return action;
    }

    public static DebuggerAction createRunToCursorAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_RUN_TO_CURSOR);
        action.putValue("Name", "CTL_Run_to_cursor_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/RunToCursor.gif");
        return action;
    }

    public static DebuggerAction createStepIntoAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_INTO);
        action.putValue("Name", "CTL_Step_into_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepInto.gif");
        return action;
    }

    public static DebuggerAction createStepIntoNextMethodAction() {
        DebuggerAction action = new DebuggerAction((Object)"stepIntoNextMethod");
        action.putValue("Name", "CTL_Step_into_next_method_action_name");
        return action;
    }

    public static DebuggerAction createStepOutAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_OUT);
        action.putValue("Name", "CTL_Step_out_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOut.gif");
        return action;
    }

    public static DebuggerAction createStepOverAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_OVER);
        action.putValue("Name", "CTL_Step_over_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOver.gif");
        return action;
    }

    public static DebuggerAction createStepOperationAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_OPERATION);
        action.putValue("Name", "CTL_Step_operation_action_name");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOverOperation.gif");
        return action;
    }

    public static DebuggerAction createToggleBreakpointAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        action.putValue("Name", "CTL_Toggle_breakpoint");
        return action;
    }

    public static DebuggerAction createEvaluateAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_EVALUATE);
        action.putValue("Name", "CTL_Evaluate");
        return action;
    }

    public static DebuggerAction createAction(Map<String, ?> params) {
        Object action = params.get("action");
        if (action == null) {
            throw new IllegalStateException("\"action\" parameter is missing.");
        }
        String name = (String)params.get("name");
        if (name == null) {
            throw new IllegalStateException("\"name\" parameter is missing.");
        }
        String iconBase = (String)params.get("iconBase");
        DebuggerAction a = new DebuggerAction(action, false);
        a.putValue("Name", name);
        if (iconBase != null) {
            a.putValue("iconBase", iconBase);
        }
        return a;
    }

    public static Action createDebugFileAction() {
        Action a = FileSensitiveActions.fileCommandAction((String)"debug.single", (String)NbBundle.getMessage(DebuggerAction.class, (String)"LBL_DebugSingleAction_Name"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debugSingle.png", (boolean)true));
        a.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugSingle.png");
        a.putValue("noIconInMenu", true);
        return a;
    }

    public static Action createDebugTestFileAction() {
        Action a = FileSensitiveActions.fileCommandAction((String)"debug.test.single", (String)NbBundle.getMessage(DebuggerAction.class, (String)"LBL_DebugTestSingleAction_Name"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debugTestSingle.png", (boolean)true));
        a.putValue("iconBase", "org/netbeans/modules/debugger/resources/debugTestSingle.png");
        a.putValue("noIconInMenu", true);
        return a;
    }

    static class Listener
    extends DebuggerManagerAdapter
    implements ActionsManagerListener {
        private ActionsManager currentActionsManager;
        private WeakReference ref;

        Listener(DebuggerAction da) {
            this.ref = new WeakReference<DebuggerAction>(da);
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            DebuggerManager.getDebuggerManager().getActionsManager().addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.updateCurrentActionsManager();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            final DebuggerAction da = this.getDebuggerAction();
            if (da == null) {
                return;
            }
            this.updateCurrentActionsManager();
            final boolean en = DebuggerAction.isEnabled(da.getAction());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    da.setEnabled(en);
                }
            });
        }

        public void actionPerformed(Object action) {
        }

        public void actionStateChanged(Object action, boolean enabled) {
            final DebuggerAction da = this.getDebuggerAction();
            if (da == null) {
                return;
            }
            if (!action.equals(da.getAction())) {
                return;
            }
            final boolean en = DebuggerAction.isEnabled(da.getAction());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    da.setEnabled(en);
                }
            });
        }

        private void updateCurrentActionsManager() {
            ActionsManager newActionsManager = DebuggerAction.getCurrentEngineActionsManager();
            if (this.currentActionsManager == newActionsManager) {
                return;
            }
            if (this.currentActionsManager != null) {
                this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            if (newActionsManager != null) {
                newActionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            this.currentActionsManager = newActionsManager;
        }

        private DebuggerAction getDebuggerAction() {
            DebuggerAction da = (DebuggerAction)this.ref.get();
            if (da == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
                DebuggerManager.getDebuggerManager().getActionsManager().removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                if (this.currentActionsManager != null) {
                    this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                }
                this.currentActionsManager = null;
                return null;
            }
            return da;
        }
    }
}

