/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.DesignMode;
import java.beans.beancontext.BeanContextChildComponentProxy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.ui.actions.DebuggerAction;
import org.netbeans.spi.debugger.ActionsProvider;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class DebuggerManagerListener
extends DebuggerManagerAdapter {
    private static final String PROPERTY_CLOSED_TC = "closedTopComponents";
    private List<DebuggerEngine> openedGroups = new LinkedList<DebuggerEngine>();
    private final Map<DebuggerEngine, List<? extends Component>> openedComponents = new HashMap<DebuggerEngine, List<? extends Component>>();
    private Set<Reference<Component>> componentsInitiallyOpened = new HashSet<Reference<Component>>();
    private final Map<DebuggerEngine, List<? extends Component>> closedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<DebuggerEngine, List<? extends Component>> usedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<Component, Dimension> toolbarButtonsPrefferedSize = new HashMap<Component, Dimension>();
    private final Map<Mode, Reference<TopComponent>> lastSelectedTopComponents = new WeakHashMap<Mode, Reference<TopComponent>>();
    private ToolbarContainerListener toolbarContainerListener;
    private static final List<Component> OPENED_COMPONENTS = new LinkedList<Component>();

    public void engineAdded(DebuggerEngine engine) {
        this.openEngineComponents(engine);
        this.setupToolbar(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openEngineComponents(DebuggerEngine engine) {
        Map<DebuggerEngine, List<? extends Component>> map = this.openedComponents;
        synchronized (map) {
            if (this.openedComponents.containsKey(engine) || this.openedGroups.contains(engine)) {
                return;
            }
            final List componentProxies = engine.lookup(null, BeanContextChildComponentProxy.class);
            if (componentProxies != null && !componentProxies.isEmpty()) {
                RequestProcessor rp;
                final ArrayList<Label> componentsToOpen = new ArrayList<Label>(componentProxies.size());
                componentsToOpen.add(new Label("EMPTY"));
                if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                    this.fillOpenedDebuggerComponents(this.componentsInitiallyOpened);
                }
                if ((rp = (RequestProcessor)engine.lookupFirst(null, RequestProcessor.class)) == null) {
                    rp = RequestProcessor.getDefault();
                }
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList<Component> cs = new ArrayList<Component>(componentProxies.size());
                        try {
                            final ArrayList<TopComponent> topComponentsToOpen = new ArrayList<TopComponent>(componentProxies.size());
                            for (final BeanContextChildComponentProxy cp : componentProxies) {
                                boolean[] doOpen;
                                Component[] c;
                                block24: {
                                    c = new Component[]{null};
                                    doOpen = new boolean[]{false};
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                c[0] = cp.getComponent();
                                                doOpen[0] = cp instanceof DesignMode ? ((DesignMode)((Object)cp)).isDesignTime() : true;
                                            }
                                        });
                                        if (c[0] == null) {
                                        }
                                        break block24;
                                    }
                                    catch (Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    continue;
                                }
                                cs.add(c[0]);
                                if (c[0] instanceof TopComponent) {
                                    boolean wasOpened;
                                    TopComponent tc = (TopComponent)c[0];
                                    boolean wasClosed = Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(tc.getName(), false);
                                    boolean bl = wasOpened = !Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(tc.getName(), true);
                                    if ((!doOpen[0] || wasClosed) && (doOpen[0] || !wasOpened)) continue;
                                    topComponentsToOpen.add(tc);
                                    continue;
                                }
                                if (!doOpen[0]) continue;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        c[0].setVisible(true);
                                    }
                                });
                            }
                            if (topComponentsToOpen.size() > 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DebuggerManagerListener.this.openTopComponents(topComponentsToOpen);
                                    }
                                });
                            }
                        }
                        finally {
                            Object object = DebuggerManagerListener.this.openedComponents;
                            synchronized (object) {
                                componentsToOpen.clear();
                                componentsToOpen.addAll(cs);
                                DebuggerManagerListener.this.openedComponents.notifyAll();
                            }
                            object = OPENED_COMPONENTS;
                            synchronized (object) {
                                if (DebuggerManagerListener.this.componentsInitiallyOpened.size() == 0) {
                                    OPENED_COMPONENTS.addAll(cs);
                                } else {
                                    ArrayList ocs = new ArrayList(cs);
                                    for (Reference cref : DebuggerManagerListener.this.componentsInitiallyOpened) {
                                        ocs.remove(cref.get());
                                    }
                                    OPENED_COMPONENTS.addAll(ocs);
                                }
                            }
                        }
                    }
                });
                this.openedComponents.put(engine, componentsToOpen);
            } else {
                if (this.openedGroups.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
                            if (group != null) {
                                group.open();
                            }
                        }
                    });
                }
                this.openedGroups.add(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOpenedDebuggerComponents(Set<Reference<Component>> componentsInitiallyOpened) {
        TopComponent.Registry registry;
        TopComponent.Registry registry2 = registry = TopComponent.getRegistry();
        synchronized (registry2) {
            for (TopComponent tc : registry.getOpened()) {
                componentsInitiallyOpened.add(new WeakReference<TopComponent>(tc));
            }
        }
    }

    private void openTopComponents(List<TopComponent> components) {
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<Mode> modesWithVisibleTC = new HashSet<Mode>();
        for (TopComponent tc : components) {
            tc.open();
            Mode mode = WindowManager.getDefault().findMode(tc);
            if (!modesWithVisibleTC.add(mode)) continue;
            TopComponent tcSel = mode.getSelectedTopComponent();
            if (tcSel != null && tcSel != tc) {
                WeakReference<TopComponent> lastSelectedTCRef = new WeakReference<TopComponent>(tcSel);
                this.lastSelectedTopComponents.put(mode, lastSelectedTCRef);
            }
            String side = null;
            try {
                side = (String)mode.getClass().getMethod("getSide", new Class[0]).invoke((Object)mode, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (side != null) continue;
            tc.requestVisible();
        }
    }

    private void closeTopComponentsList(List<TopComponent> components) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<TopComponent> componentToActivateAfterClose = new ArrayList<TopComponent>();
        for (TopComponent tc : components) {
            TopComponent tcAct;
            Reference<TopComponent> tcActRef;
            Mode mode = WindowManager.getDefault().findMode(tc);
            if (mode.getSelectedTopComponent() == tc && (tcActRef = this.lastSelectedTopComponents.remove(mode)) != null && (tcAct = tcActRef.get()) != null && tcAct.isOpened()) {
                componentToActivateAfterClose.add(tcAct);
            }
            tc.close();
        }
        for (TopComponent tc : componentToActivateAfterClose) {
            tc.requestVisible();
        }
    }

    private DebuggerAction getDebuggerAction(Component c) {
        if (c instanceof AbstractButton) {
            Action a = ((AbstractButton)c).getAction();
            if (a == null) {
                ActionListener[] actionListeners;
                for (ActionListener l : actionListeners = ((AbstractButton)c).getActionListeners()) {
                    if (!(l instanceof Action)) continue;
                    a = (Action)l;
                    break;
                }
            }
            if (a != null && a instanceof DebuggerAction) {
                return (DebuggerAction)a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupToolbar(final DebuggerEngine engine) {
        boolean isFirst;
        List actionsProviderList = engine.lookup(null, ActionsProvider.class);
        final HashSet engineActions = new HashSet();
        for (ActionsProvider ap : actionsProviderList) {
            engineActions.addAll(ap.getActions());
        }
        final ArrayList<Label> buttonsToClose = new ArrayList<Label>();
        buttonsToClose.add(new Label("EMPTY"));
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            isFirst = this.closedToolbarButtons.isEmpty();
            this.closedToolbarButtons.put(engine, buttonsToClose);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Component> buttonsClosed = new ArrayList<Component>();
                ArrayList<Component> buttonsUsed = new ArrayList<Component>();
                try {
                    Toolbar debugToolbar;
                    if (ToolbarPool.getDefault().getConfiguration().equals("Standard")) {
                        ToolbarPool.getDefault().setConfiguration("Debugging");
                    }
                    if ((debugToolbar = ToolbarPool.getDefault().findToolbar("Debug")) == null) {
                        return;
                    }
                    DebuggerManagerListener.this.registerToolbarListener(debugToolbar);
                    for (Component c : debugToolbar.getComponents()) {
                        DebuggerAction a = DebuggerManagerListener.this.getDebuggerAction(c);
                        if (a == null) continue;
                        Object action = a.getAction();
                        boolean containsAction = engineActions.contains(action);
                        if (isFirst && !containsAction) {
                            c.setVisible(false);
                            buttonsClosed.add(c);
                            DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                            c.setPreferredSize(new Dimension(0, 0));
                        }
                        if (!isFirst && containsAction) {
                            Dimension d = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
                            if (d != null) {
                                c.setPreferredSize(d);
                            }
                            c.setVisible(true);
                        }
                        if (!containsAction) continue;
                        buttonsUsed.add(c);
                    }
                    debugToolbar.revalidate();
                    debugToolbar.repaint();
                }
                finally {
                    Map map = DebuggerManagerListener.this.closedToolbarButtons;
                    synchronized (map) {
                        DebuggerManagerListener.this.usedToolbarButtons.put(engine, buttonsUsed);
                        buttonsToClose.clear();
                        buttonsToClose.addAll(buttonsClosed);
                        DebuggerManagerListener.this.closedToolbarButtons.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineRemoved(DebuggerEngine engine) {
        Map<DebuggerEngine, List<? extends Component>> map = this.openedComponents;
        synchronized (map) {
            List<? extends Component> openedWindows = this.openedComponents.remove(engine);
            if (openedWindows != null) {
                if (openedWindows.size() == 1 && openedWindows.get(0) instanceof Label) {
                    try {
                        this.openedComponents.wait();
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                }
                ArrayList<? extends Component> retainOpened = new ArrayList<Component>();
                for (List<? extends Component> ltc : this.openedComponents.values()) {
                    retainOpened.addAll(ltc);
                }
                final ArrayList<? extends Component> windowsToClose = new ArrayList<Component>(openedWindows);
                windowsToClose.removeAll(retainOpened);
                for (Reference<Component> cref : this.componentsInitiallyOpened) {
                    windowsToClose.remove(cref.get());
                }
                if (!windowsToClose.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<TopComponent> topComponentsToClose = new ArrayList<TopComponent>(windowsToClose.size());
                            for (Component c : windowsToClose) {
                                if (c instanceof TopComponent) {
                                    TopComponent tc = (TopComponent)c;
                                    boolean isOpened = tc.isOpened();
                                    Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).setBoolean(tc.getName(), !isOpened);
                                    if (!isOpened) continue;
                                    topComponentsToClose.add(tc);
                                    continue;
                                }
                                c.setVisible(false);
                            }
                            DebuggerManagerListener.this.closeTopComponentsList(topComponentsToClose);
                        }
                    });
                }
                List<Component> list = OPENED_COMPONENTS;
                synchronized (list) {
                    OPENED_COMPONENTS.removeAll(windowsToClose);
                }
            }
            this.openedGroups.remove(engine);
            if (this.openedGroups.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
                        if (group != null) {
                            group.close();
                        }
                    }
                });
            }
            if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                this.componentsInitiallyOpened.clear();
            }
        }
        this.closeToolbar(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeToolbar(DebuggerEngine engine) {
        boolean doCloseToolbar;
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            List<? extends Component> closedButtons = this.closedToolbarButtons.remove(engine);
            doCloseToolbar = this.closedToolbarButtons.isEmpty();
            if (closedButtons != null) {
                while (closedButtons.size() == 1 && closedButtons.get(0) instanceof Label) {
                    try {
                        this.closedToolbarButtons.wait();
                    }
                    catch (InterruptedException iex) {}
                }
                List<? extends Component> usedButtons = this.usedToolbarButtons.remove(engine);
                ToolbarPool.getDefault().waitFinished();
                if (!ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
                    return;
                }
                final Toolbar debugToolbar = ToolbarPool.getDefault().findToolbar("Debug");
                if (!doCloseToolbar) {
                    ArrayList<? extends Component> usedByAllButtons = new ArrayList<Component>();
                    for (List<? extends Component> ltc : this.usedToolbarButtons.values()) {
                        usedByAllButtons.addAll(ltc);
                    }
                    final ArrayList<? extends Component> buttonsToClose = new ArrayList<Component>(usedButtons);
                    buttonsToClose.removeAll(usedByAllButtons);
                    if (!buttonsToClose.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (Component c : buttonsToClose) {
                                    c.setVisible(false);
                                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                                    c.setPreferredSize(new Dimension(0, 0));
                                }
                                debugToolbar.revalidate();
                                debugToolbar.repaint();
                            }
                        });
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (Component c : debugToolbar.getComponents()) {
                                if (!(c instanceof AbstractButton)) continue;
                                Dimension d = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
                                if (d != null) {
                                    c.setPreferredSize(d);
                                }
                                c.setVisible(true);
                            }
                            debugToolbar.revalidate();
                            debugToolbar.repaint();
                        }
                    });
                }
            }
        }
        if (doCloseToolbar) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Toolbar debugToolbar = ToolbarPool.getDefault().findToolbar("Debug");
                    DebuggerManagerListener.this.unregisterToolbarListener(debugToolbar);
                    ToolbarPool.getDefault().setConfiguration("Standard");
                }
            });
        }
    }

    private void registerToolbarListener(Toolbar debugToolbar) {
        if (this.toolbarContainerListener == null) {
            this.toolbarContainerListener = new ToolbarContainerListener();
            debugToolbar.addContainerListener((ContainerListener)this.toolbarContainerListener);
        }
    }

    private void unregisterToolbarListener(Toolbar debugToolbar) {
        if (this.toolbarContainerListener != null) {
            debugToolbar.removeContainerListener((ContainerListener)this.toolbarContainerListener);
            this.toolbarContainerListener = null;
        }
    }

    static void closeDebuggerUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerManagerListener.doCloseDebuggerUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebuggerManagerListener.doCloseDebuggerUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCloseDebuggerUI() {
        TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("debugger");
        if (group != null) {
            group.close();
        }
        List<Component> list = OPENED_COMPONENTS;
        synchronized (list) {
            for (Component c : OPENED_COMPONENTS) {
                if (c instanceof TopComponent) {
                    ((TopComponent)c).close();
                    continue;
                }
                c.setVisible(false);
            }
            OPENED_COMPONENTS.clear();
        }
        ToolbarPool.getDefault().waitFinished();
        if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
            ToolbarPool.getDefault().setConfiguration("Standard");
        }
    }

    private class ToolbarContainerListener
    implements ContainerListener {
        private final Map<DebuggerAction, Set<DebuggerEngine>> buttonActionsUsed = new HashMap<DebuggerAction, Set<DebuggerEngine>>();
        private final Map<DebuggerAction, Set<DebuggerEngine>> buttonActionsClosed = new HashMap<DebuggerAction, Set<DebuggerEngine>>();
        private boolean clearScheduled = false;

        private ToolbarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            DebuggerAction action = DebuggerManagerListener.this.getDebuggerAction(c);
            if (action != null) {
                Set<DebuggerEngine> closedEngines;
                Set<DebuggerEngine> usedEngines = this.buttonActionsUsed.get(action);
                if (usedEngines != null) {
                    for (DebuggerEngine engine : usedEngines) {
                        List buttonsUsed = (List)DebuggerManagerListener.this.usedToolbarButtons.get(engine);
                        buttonsUsed.add(c);
                    }
                }
                if ((closedEngines = this.buttonActionsClosed.get(action)) != null) {
                    for (DebuggerEngine engine : closedEngines) {
                        List buttonsClosed = (List)DebuggerManagerListener.this.closedToolbarButtons.get(engine);
                        buttonsClosed.add(c);
                    }
                }
                if (usedEngines == null && closedEngines != null) {
                    c.setVisible(false);
                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(c, c.getPreferredSize());
                    c.setPreferredSize(new Dimension(0, 0));
                }
                if (usedEngines == null && closedEngines == null) {
                    for (DebuggerEngine engine : DebuggerManagerListener.this.usedToolbarButtons.keySet()) {
                        List buttonsUsed = (List)DebuggerManagerListener.this.usedToolbarButtons.get(engine);
                        buttonsUsed.add(c);
                    }
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            DebuggerAction action = DebuggerManagerListener.this.getDebuggerAction(c);
            if (action != null) {
                HashSet<DebuggerEngine> usedEngines = null;
                HashSet<DebuggerEngine> closedEngines = null;
                for (DebuggerEngine engine : DebuggerManagerListener.this.usedToolbarButtons.keySet()) {
                    if (!((List)DebuggerManagerListener.this.usedToolbarButtons.get(engine)).remove(c)) continue;
                    if (usedEngines == null) {
                        usedEngines = new HashSet<DebuggerEngine>();
                    }
                    usedEngines.add(engine);
                }
                for (DebuggerEngine engine : DebuggerManagerListener.this.closedToolbarButtons.keySet()) {
                    if (!((List)DebuggerManagerListener.this.closedToolbarButtons.get(engine)).remove(c)) continue;
                    if (closedEngines == null) {
                        closedEngines = new HashSet<DebuggerEngine>();
                    }
                    closedEngines.add(engine);
                }
                if (usedEngines != null) {
                    this.buttonActionsUsed.put(action, usedEngines);
                }
                if (closedEngines != null) {
                    this.buttonActionsClosed.put(action, closedEngines);
                }
            }
            DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(c);
            if (!this.clearScheduled) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolbarContainerListener.this.buttonActionsUsed.clear();
                        ToolbarContainerListener.this.buttonActionsClosed.clear();
                        ToolbarContainerListener.this.clearScheduled = false;
                    }
                });
            }
        }
    }
}

