/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerListUI;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class LDErrorParser
implements ErrorParserProvider.ErrorParser {
    private static final Pattern LD_LIB_BUILD_TRACE = Pattern.compile(".*ld\\.so.*libBuildTrace.so");
    private static final Pattern LD_RFS_PRELOAD = Pattern.compile(".*ld\\.so.*rfs_preload.so");
    private final ExecutionEnvironment execEnv;
    private boolean checkBuildTrace = false;
    private boolean checkRfs = false;

    public LDErrorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
        this.execEnv = execEnv;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            switch (hostInfo.getOSFamily()) {
                case LINUX: 
                case SUNOS: 
                case UNKNOWN: {
                    this.checkBuildTrace = true;
                    this.checkRfs = execEnv.isRemote();
                    break;
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public ErrorParserProvider.Result handleLine(final String line) throws IOException {
        Matcher m;
        if (this.checkBuildTrace && (m = LD_LIB_BUILD_TRACE.matcher(line)).find()) {
            return new ErrorParserProvider.Result(){

                @Override
                public boolean result() {
                    return true;
                }

                @Override
                public List<ConvertedLine> converted() {
                    ArrayList<ConvertedLine> lines = new ArrayList<ConvertedLine>();
                    lines.add(ConvertedLine.forText((String)line, (OutputListener)new OutputListenerBuildTrace(LDErrorParser.this.execEnv)));
                    return lines;
                }
            };
        }
        if (this.checkRfs && (m = LD_RFS_PRELOAD.matcher(line)).find()) {
            return new ErrorParserProvider.Result(){

                @Override
                public boolean result() {
                    return true;
                }

                @Override
                public List<ConvertedLine> converted() {
                    ArrayList<ConvertedLine> lines = new ArrayList<ConvertedLine>();
                    lines.add(ConvertedLine.forText((String)line, (OutputListener)new OutputListenerRfs(LDErrorParser.this.execEnv)));
                    return lines;
                }
            };
        }
        return null;
    }

    private static final class OutputListenerRfs
    implements OutputListener {
        private final ExecutionEnvironment execEnv;

        private OutputListenerRfs(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            JButton change = new JButton(NbBundle.getMessage(LDErrorParser.class, (String)"ResolveRfsLibrary.Forbid.text"));
            JButton close = new JButton(NbBundle.getMessage(LDErrorParser.class, (String)"ResolveRfsLibrary.Close.text"));
            NotifyDescriptor d = new NotifyDescriptor((Object)NbBundle.getMessage(LDErrorParser.class, (String)"ResolveRfsLibrary.Explanation.text"), NbBundle.getMessage(LDErrorParser.class, (String)"ResolveRfsLibrary.Title.text"), 2, 2, (Object[])new JButton[]{change, close}, (Object)change);
            if (DialogDisplayer.getDefault().notify(d) == change) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ServerListUI.showServerRecordPropertiesDialog((ExecutionEnvironment)OutputListenerRfs.this.execEnv);
                    }
                });
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class OutputListenerBuildTrace
    implements OutputListener {
        private final ExecutionEnvironment execEnv;

        private OutputListenerBuildTrace(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            JButton forbid = new JButton(NbBundle.getMessage(LDErrorParser.class, (String)"ResolveBuildLibrary.Forbid.text"));
            JButton close = new JButton(NbBundle.getMessage(LDErrorParser.class, (String)"ResolveBuildLibrary.Close.text"));
            NotifyDescriptor d = new NotifyDescriptor((Object)NbBundle.getMessage(LDErrorParser.class, (String)"ResolveBuildLibrary.Explanation.text"), NbBundle.getMessage(LDErrorParser.class, (String)"ResolveBuildLibrary.Title.text"), 2, 2, (Object[])new JButton[]{forbid, close}, (Object)forbid);
            if (DialogDisplayer.getDefault().notify(d) == forbid) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsDisplayer.getDefault().open("CPlusPlus/ProjectsTab");
                    }
                });
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

