/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.toolchain.compilers.SPICompilerAccesor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetPreferences;
import org.netbeans.modules.cnd.toolchain.compilerset.FixCodeAssistancePanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ToolchainValidator {
    private static final boolean DISABLED = Boolean.getBoolean("cnd.toolchain.validator.disabled") || CompilerSetManagerImpl.DISABLED;
    public static final ToolchainValidator INSTANCE = new ToolchainValidator();
    private static final RequestProcessor RP = new RequestProcessor("Tool collection validator", 1);

    private ToolchainValidator() {
    }

    public void validate(final ExecutionEnvironment env, final CompilerSetManagerImpl csm) {
        boolean postpone;
        if (DISABLED) {
            return;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ToolchainValidator.this.validateImpl(env, csm);
            }
        };
        boolean bl = postpone = env.isRemote() && !ConnectionManager.getInstance().isConnectedTo(env);
        if (postpone) {
            ConnectionManager.getInstance().addConnectionListener(new ConnectionListener(){

                public void connected(ExecutionEnvironment e) {
                    if (e.equals(env)) {
                        RP.post(runnable);
                        ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
                    }
                }

                public void disconnected(ExecutionEnvironment env2) {
                }
            });
        } else {
            RP.post(runnable);
        }
    }

    void applyChanges(Map<Tool, List<List<String>>> needReset, CompilerSetManagerImpl csm) {
        for (Map.Entry<Tool, List<List<String>>> entry : needReset.entrySet()) {
            Tool tool = entry.getKey();
            List<List<String>> pair = entry.getValue();
            new SPICompilerAccesor(tool).applySystemIncludesAndDefines(pair);
        }
        CompilerSetPreferences.saveToDisk(csm);
        ToolsPanelSupport.fireCodeAssistanceChange(csm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImpl(ExecutionEnvironment env, CompilerSetManagerImpl csm) {
        ProgressHandle createHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ToolchainValidator.class, (String)"ToolCollectionValidation", (Object)env.getDisplayName()));
        createHandle.start();
        try {
            HashMap<Tool, List<List<String>>> needReset = new HashMap<Tool, List<List<String>>>();
            for (CompilerSet cs : csm.getCompilerSets()) {
                for (Tool tool : cs.getTools()) {
                    List<List<String>> systemIncludesAndDefines;
                    if (!(tool instanceof AbstractCompiler) || tool.getKind() != PredefinedToolKind.CCompiler && tool.getKind() != PredefinedToolKind.CCCompiler || this.isEqualsSystemIncludesAndDefines(systemIncludesAndDefines = new SPICompilerAccesor(tool).getSystemIncludesAndDefines(), (AbstractCompiler)tool)) continue;
                    needReset.put(tool, systemIncludesAndDefines);
                }
            }
            if (needReset.size() > 0) {
                FixCodeAssistancePanel.showNotification(needReset, csm);
            }
        }
        finally {
            createHandle.finish();
        }
    }

    private boolean isEqualsSystemIncludesAndDefines(List<List<String>> systemIncludesAndDefines, AbstractCompiler tool) {
        if (systemIncludesAndDefines == null) {
            return true;
        }
        List<String> systemIncludeDirectories = tool.getSystemIncludeDirectories();
        List<String> systemPreprocessorSymbols = tool.getSystemPreprocessorSymbols();
        if (!this.compareLists(systemIncludesAndDefines.get(0), systemIncludeDirectories)) {
            return false;
        }
        return this.compareLists(systemIncludesAndDefines.get(1), systemPreprocessorSymbols);
    }

    private boolean compareLists(List<String> newList, List<String> oldList) {
        HashSet<String> oldSet = new HashSet<String>(oldList);
        for (String s : newList) {
            if (s.startsWith("__TIME__") || s.startsWith("__DATE__") || s.startsWith("__FILE__") || s.startsWith("__LINE__") || oldSet.contains(s)) continue;
            return false;
        }
        return true;
    }
}

