/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.PersistentList;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class CCCCompiler
extends AbstractCompiler {
    private static final String DEV_NULL = "/dev/null";
    private static final String NB69_VERSION_PATTERN = "/var/cache/cnd/remote-includes/";
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private volatile Pair compilerDefinitions;
    private static File emptyFile = null;

    protected CCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> values) {
        return this.copySystemIncludeDirectoriesImpl(values, true);
    }

    protected final boolean copySystemIncludeDirectories(List<String> values) {
        boolean res = this.copySystemIncludeDirectoriesImpl(values, false);
        if (res && values instanceof CompilerDefinition) {
            this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions.clear();
            this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions.addAll(((CompilerDefinition)values).userAddedDefinitions);
        }
        return res;
    }

    private boolean copySystemIncludeDirectoriesImpl(List<String> values, boolean normalize) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)values).equals(this.compilerDefinitions.systemIncludeDirectoriesList)) {
            return false;
        }
        CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition((Collection<String>)values);
        if (normalize) {
            this.normalizePaths(systemIncludeDirectoriesList);
        }
        systemIncludeDirectoriesList.userAddedDefinitions.addAll(this.compilerDefinitions.systemIncludeDirectoriesList.userAddedDefinitions);
        this.compilerDefinitions.systemIncludeDirectoriesList = systemIncludeDirectoriesList;
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> values) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)values).equals(this.compilerDefinitions.systemPreprocessorSymbolsList)) {
            return false;
        }
        CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition((Collection<String>)values);
        systemPreprocessorSymbolsList.userAddedDefinitions.addAll(this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions);
        this.compilerDefinitions.systemPreprocessorSymbolsList = systemPreprocessorSymbolsList;
        return true;
    }

    protected final boolean copySystemPreprocessorSymbols(List<String> values) {
        boolean res = this.setSystemPreprocessorSymbols(values);
        if (res && values instanceof CompilerDefinition) {
            this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions.clear();
            this.compilerDefinitions.systemPreprocessorSymbolsList.userAddedDefinitions.addAll(((CompilerDefinition)values).userAddedDefinitions);
        }
        return res;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        if (this.compilerDefinitions == null) {
            this.resetSystemProperties();
        }
        return this.compilerDefinitions.systemPreprocessorSymbolsList;
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        if (this.compilerDefinitions == null) {
            this.resetSystemProperties();
        }
        return this.compilerDefinitions.systemIncludeDirectoriesList;
    }

    @Override
    public boolean isReady() {
        return this.compilerDefinitions != null;
    }

    @Override
    public void waitReady(boolean reset) {
        if (reset || !this.isReady()) {
            this.resetSystemProperties();
        }
    }

    @Override
    public void resetSystemProperties(boolean lazy) {
        if (lazy) {
            this.compilerDefinitions = null;
        } else {
            CndUtils.assertNonUiThread();
            this.compilerDefinitions = this.getFreshSystemIncludesAndDefines();
        }
    }

    @Override
    public void loadSettings(Preferences prefs, String prefix) {
        PersistentList<String> oldPreprocSymbolList;
        PersistentList<String> oldIncludeDirList;
        String version = prefs.get("csm.version", "1.0");
        ArrayList<String> includeDirList = new ArrayList<String>();
        ArrayList<Integer> userAddedInclude = new ArrayList<Integer>();
        String includeDirPrefix = prefix + ".systemIncludes";
        int includeDirCount = prefs.getInt(includeDirPrefix + ".count", 0);
        for (int i = 0; i < includeDirCount; ++i) {
            String includeDir = prefs.get(includeDirPrefix + '.' + i, null);
            if (includeDir == null) continue;
            if ("1.1".equals(version)) {
                int index;
                int start;
                if (Utilities.isWindows()) {
                    includeDir = includeDir.replace('\\', '/');
                }
                if ((start = includeDir.indexOf(NB69_VERSION_PATTERN)) > 0 && (index = (includeDir = includeDir.substring(start + NB69_VERSION_PATTERN.length())).indexOf(47)) > 0) {
                    includeDir = includeDir.substring(index);
                }
            }
            includeDirList.add(includeDir);
            String added = prefs.get(includeDirPrefix + ".useradded." + i, null);
            if (!"true".equals(added)) continue;
            userAddedInclude.add(includeDirList.size() - 1);
        }
        if (includeDirList.isEmpty() && (oldIncludeDirList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList")) != null) {
            includeDirList.addAll(oldIncludeDirList);
        }
        this.copySystemIncludeDirectories(includeDirList);
        if (!userAddedInclude.isEmpty()) {
            for (Integer i : userAddedInclude) {
                this.compilerDefinitions.systemIncludeDirectoriesList.setUserAdded(true, i);
            }
        }
        ArrayList<String> preprocSymbolList = new ArrayList<String>();
        ArrayList<Integer> userAddedpreprocSymbol = new ArrayList<Integer>();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        int preprocSymbolCount = prefs.getInt(preprocSymbolPrefix + ".count", 0);
        for (int i = 0; i < preprocSymbolCount; ++i) {
            String preprocSymbol = prefs.get(preprocSymbolPrefix + '.' + i, null);
            if (preprocSymbol == null) continue;
            preprocSymbolList.add(preprocSymbol);
            String added = prefs.get(preprocSymbolPrefix + ".useradded." + i, null);
            if (!"true".equals(added)) continue;
            userAddedpreprocSymbol.add(preprocSymbolList.size() - 1);
        }
        if (preprocSymbolList.isEmpty() && (oldPreprocSymbolList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList")) != null) {
            preprocSymbolList.addAll(oldPreprocSymbolList);
        }
        this.copySystemPreprocessorSymbols(preprocSymbolList);
        if (!userAddedpreprocSymbol.isEmpty()) {
            for (Integer i : userAddedpreprocSymbol) {
                this.compilerDefinitions.systemPreprocessorSymbolsList.setUserAdded(true, i);
            }
        }
    }

    @Override
    public void saveSettings(Preferences prefs, String prefix) {
        List<String> includeDirList = this.getSystemIncludeDirectories();
        String includeDirPrefix = prefix + ".systemIncludes";
        prefs.putInt(includeDirPrefix + ".count", includeDirList.size());
        for (int i = 0; i < includeDirList.size(); ++i) {
            prefs.put(includeDirPrefix + '.' + i, includeDirList.get(i));
            if (!this.compilerDefinitions.systemIncludeDirectoriesList.isUserAdded(i)) continue;
            prefs.put(includeDirPrefix + ".useradded." + i, "true");
        }
        List<String> preprocSymbolList = this.getSystemPreprocessorSymbols();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        prefs.putInt(preprocSymbolPrefix + ".count", preprocSymbolList.size());
        for (int i = 0; i < preprocSymbolList.size(); ++i) {
            prefs.put(preprocSymbolPrefix + '.' + i, preprocSymbolList.get(i));
            if (!this.compilerDefinitions.systemPreprocessorSymbolsList.isUserAdded(i)) continue;
            prefs.put(preprocSymbolPrefix + ".useradded." + i, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getSystemIncludesAndDefines(String arguments, final boolean stdout, Pair pair) throws IOException {
        block16: {
            String compilerPath = this.getPath();
            if (compilerPath == null || compilerPath.length() == 0) {
                return;
            }
            ExecutionEnvironment execEnv = this.getExecutionEnvironment();
            NativeProcess startedProcess = null;
            RequestProcessor.Task errorTask = null;
            try {
                NativeProcess process;
                if (execEnv.isLocal() && Utilities.isWindows()) {
                    compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
                }
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath)) {
                    compilerPath = this.getDefaultPath();
                }
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath)) {
                    return;
                }
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
                argsList.add(this.getEmptyFile(execEnv));
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
                npb.setExecutable(compilerPath);
                npb.setArguments(argsList.toArray(new String[argsList.size()]));
                npb.getEnvironment().prependPathVariable("PATH", ToolUtils.getDirName(compilerPath));
                startedProcess = process = npb.call();
                if (process.getState() == NativeProcess.State.ERROR) break block16;
                InputStream stream = stdout ? process.getInputStream() : process.getErrorStream();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (stdout) {
                                ProcessUtils.readProcessError((Process)process);
                            } else {
                                ProcessUtils.readProcessOutput((Process)process);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                if (stream == null) break block16;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    this.parseCompilerOutput(reader, pair);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IOException(ex);
            }
            finally {
                if (errorTask != null) {
                    errorTask.cancel();
                }
                if (startedProcess != null) {
                    startedProcess.destroy();
                }
            }
        }
    }

    protected abstract void parseCompilerOutput(BufferedReader var1, Pair var2);

    protected abstract Pair getFreshSystemIncludesAndDefines();

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getNames().length > 0) {
            return compiler.getNames()[0];
        }
        return "";
    }

    protected boolean containsMacro(List<String> macrosList, String macroToFind) {
        int len = macroToFind.length();
        for (String macro : macrosList) {
            if (!macro.startsWith(macroToFind)) continue;
            if (macro.length() == len) {
                return true;
            }
            if (macro.charAt(len) != '=') continue;
            return true;
        }
        return false;
    }

    protected void parseUserMacros(String line, List<String> preprocessorList) {
        int defineIndex = line.indexOf("-D");
        while (defineIndex >= 0) {
            String token;
            int spaceIndex = line.indexOf(32, defineIndex + 1);
            if (spaceIndex > 0) {
                token = line.substring(defineIndex + 2, spaceIndex);
                if (defineIndex > 0 && line.charAt(defineIndex - 1) == '\"' && token.length() > 0 && token.charAt(token.length() - 1) == '\"') {
                    token = token.substring(0, token.length() - 1);
                }
                CCCCompiler.addUnique(preprocessorList, token);
                defineIndex = line.indexOf("-D", spaceIndex);
                continue;
            }
            token = line.substring(defineIndex + 2);
            if (defineIndex > 0 && line.charAt(defineIndex - 1) == '\"' && token.length() > 0 && token.charAt(token.length() - 1) == '\"') {
                token = token.substring(0, token.length() - 1);
            }
            CCCCompiler.addUnique(preprocessorList, token);
            break;
        }
    }

    private String getEmptyFile(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal() && Utilities.isWindows()) {
            if (emptyFile == null) {
                try {
                    File tmpFile = File.createTempFile("xyz", ".c");
                    tmpFile.deleteOnExit();
                    emptyFile = tmpFile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return emptyFile == null ? DEV_NULL : emptyFile.getAbsolutePath();
        }
        return DEV_NULL;
    }

    protected String getUniqueID() {
        if (this.getCompilerSet() == null || this.getCompilerSet().isAutoGenerated()) {
            return this.getClass().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
        }
        return this.getClass().getName() + this.getCompilerSet().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
    }

    protected static <T> void addUnique(List<? super T> list, T element) {
        if (!list.contains(element)) {
            list.add(element);
        }
    }

    public static final class CompilerDefinition
    extends ArrayList<String> {
        private List<Integer> userAddedDefinitions = new ArrayList<Integer>(0);

        public CompilerDefinition() {
        }

        public CompilerDefinition(int size) {
            super(size);
        }

        public CompilerDefinition(Collection<String> c) {
            super(c);
        }

        public boolean isUserAdded(int i) {
            return this.userAddedDefinitions.contains(i);
        }

        public void setUserAdded(boolean isUserAddes, int i) {
            if (isUserAddes) {
                if (!this.userAddedDefinitions.contains(i)) {
                    this.userAddedDefinitions.add(i);
                }
            } else if (this.userAddedDefinitions.contains(i)) {
                this.userAddedDefinitions.remove((Object)i);
            }
        }

        public void sort() {
            HashSet set = new HashSet();
            for (Integer i : this.userAddedDefinitions) {
                if (i >= this.size()) continue;
                set.add(this.get(i));
            }
            Collections.sort(this, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
            this.userAddedDefinitions.clear();
            for (String s : set) {
                this.userAddedDefinitions.add(this.indexOf(s));
            }
        }
    }

    protected static final class Pair {
        public CompilerDefinition systemIncludeDirectoriesList = new CompilerDefinition(0);
        public CompilerDefinition systemPreprocessorSymbolsList = new CompilerDefinition(0);
    }
}

