/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TakeSnapshotCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TakeSnapshotProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpDefaultName");
    public static final String TAKE_SNAPSHOT_PP_TYPE = PP_TYPE;
    public static final String TAKE_SNAPSHOT_PP_DESCR = PP_DESCR;

    @Override
    public String getDescription() {
        return TAKE_SNAPSHOT_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.TakeSnapshot");
    }

    @Override
    public Icon getDisabledIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.TakeSnapshotDisabled");
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return TAKE_SNAPSHOT_PP_TYPE;
    }

    @Override
    public TakeSnapshotProfilingPoint create(Lookup.Provider project) {
        CodeProfilingPoint.Location location;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((location = Utils.getCurrentLocation(Integer.MAX_VALUE)).equals(CodeProfilingPoint.Location.EMPTY)) {
            String filename = "";
            String name = Utils.getUniqueName(this.getType(), "", project);
            return new TakeSnapshotProfilingPoint(name, location, project, this);
        }
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        String filename = FileUtil.toFileObject((File)file).getName();
        String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", filename, location.getLine()), project);
        return new TakeSnapshotProfilingPoint(name, location, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return TakeSnapshotProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TakeSnapshotCustomizer createCustomizer() {
        return new TakeSnapshotCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Lookup.Provider project, Properties properties, int index) {
        String name = properties.getProperty(index + "_" + "p_name", null);
        String enabledStr = properties.getProperty(index + "_" + "p_enabled", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, index, properties);
        String type = properties.getProperty(index + "_" + "p_snapshot", null);
        String target = properties.getProperty(index + "_" + "p_target", null);
        String file = properties.getProperty(index + "_" + "p_file", null);
        String resetResultsStr = properties.getProperty(index + "_" + "p_reset_results", null);
        if (name == null || enabledStr == null || location == null || type == null || target == null || file == null || resetResultsStr == null) {
            return null;
        }
        TakeSnapshotProfilingPoint profilingPoint = null;
        try {
            profilingPoint = new TakeSnapshotProfilingPoint(name, location, project, this);
            profilingPoint.setEnabled(Boolean.parseBoolean(enabledStr));
            profilingPoint.setSnapshotType(type);
            profilingPoint.setSnapshotTarget(target);
            profilingPoint.setSnapshotFile(file);
            profilingPoint.setResetResults(Boolean.parseBoolean(resetResultsStr));
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        return profilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int index, Properties properties) {
        TakeSnapshotProfilingPoint takeSnapshot = (TakeSnapshotProfilingPoint)profilingPoint;
        properties.put(index + "_" + "p_name", takeSnapshot.getName());
        properties.put(index + "_" + "p_enabled", Boolean.toString(takeSnapshot.isEnabled()));
        properties.put(index + "_" + "p_snapshot", takeSnapshot.getSnapshotType());
        properties.put(index + "_" + "p_target", takeSnapshot.getSnapshotTarget());
        properties.put(index + "_" + "p_file", takeSnapshot.getSnapshotFile() == null ? "" : takeSnapshot.getSnapshotFile());
        properties.put(index + "_" + "p_reset_results", Boolean.toString(takeSnapshot.getResetResults()));
        takeSnapshot.getLocation().store(takeSnapshot.getProject(), index, properties);
    }
}

